/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.Messages;
import net.i2p.router.web.StatSummarizer;
import net.i2p.router.web.SummaryListener;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;
import org.rrd4j.core.RrdException;
import org.rrd4j.data.Variable;
import org.rrd4j.graph.ElementsNames;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;

class SummaryRenderer {
    private final Log _log;
    private final SummaryListener _listener;
    private final I2PAppContext _context;
    private static final Color BACK_COLOR = new Color(246, 246, 255);
    private static final Color SHADEA_COLOR = new Color(246, 246, 255);
    private static final Color SHADEB_COLOR = new Color(246, 246, 255);
    private static final Color GRID_COLOR = new Color(100, 100, 100, 75);
    private static final Color MGRID_COLOR = new Color(255, 91, 91, 110);
    private static final Color FONT_COLOR = new Color(51, 51, 63);
    private static final Color FRAME_COLOR = new Color(51, 51, 63);
    private static final Color AREA_COLOR = new Color(100, 160, 200, 200);
    private static final Color LINE_COLOR = new Color(0, 30, 110, 255);
    private static final Color RESTART_BAR_COLOR = new Color(223, 13, 13, 255);
    private static final Color ARROW_COLOR = new Color(0, 0, 0, 0);
    private static final boolean IS_WIN = SystemVersion.isWindows();
    private static final String DEFAULT_FONT_NAME = IS_WIN ? "Lucida Console" : "Monospaced";
    private static final String DEFAULT_TITLE_FONT_NAME = "Dialog";
    private static final String DEFAULT_LEGEND_FONT_NAME = "Dialog";
    private static final String PROP_FONT_MONO = "routerconsole.graphFont.unit";
    private static final String PROP_FONT_LEGEND = "routerconsole.graphFont.legend";
    private static final String PROP_FONT_TITLE = "routerconsole.graphFont.title";
    private static final int SIZE_MONO = 10;
    private static final int SIZE_LEGEND = 10;
    private static final int SIZE_TITLE = 13;
    private static final long[] RATES = new long[]{3600000L};
    private static final Stroke GRID_STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f, 1.0f}, 0.0f);

    public SummaryRenderer(I2PAppContext ctx, SummaryListener lsnr) {
        this._log = ctx.logManager().getLog(SummaryRenderer.class);
        this._listener = lsnr;
        this._context = ctx;
        ctx.statManager().createRateStat("graph.renderTime", "", "Router", RATES);
    }

    @Deprecated
    public static synchronized void render(I2PAppContext ctx, OutputStream out, String filename) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void render(OutputStream out) throws IOException {
        this.render(out, 400, 100, false, false, false, false, -1, 0, false);
    }

    public void render(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int endp, boolean showCredit) throws IOException {
        this.render(out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, endp, showCredit, null, null);
    }

    public void render(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int endp, boolean showCredit, SummaryListener lsnr2, String titleOverride) throws IOException {
        long begin = System.currentTimeMillis();
        long end = Math.min(this._listener.now(), begin - 75000L);
        long period = this._listener.getRate().getPeriod();
        if (endp > 0) {
            end -= period * (long)endp;
        }
        if (periodCount <= 0 || periodCount > this._listener.getRows()) {
            periodCount = this._listener.getRows();
        }
        long start = end - period * (long)periodCount;
        ImageInputStream ios = null;
        try {
            RrdGraph graph;
            String descr;
            String plotName;
            RrdGraphDef def = new RrdGraphDef();
            def.setColor(ElementsNames.back, (Paint)BACK_COLOR);
            def.setColor(ElementsNames.shadea, (Paint)SHADEA_COLOR);
            def.setColor(ElementsNames.shadeb, (Paint)SHADEB_COLOR);
            def.setColor(ElementsNames.grid, (Paint)GRID_COLOR);
            def.setColor(ElementsNames.mgrid, (Paint)MGRID_COLOR);
            def.setColor(ElementsNames.font, (Paint)FONT_COLOR);
            def.setColor(ElementsNames.frame, (Paint)FRAME_COLOR);
            def.setColor(ElementsNames.arrow, (Paint)ARROW_COLOR);
            String lang = Messages.getLanguage(this._context);
            int smallSize = 10;
            int legendSize = 10;
            int largeSize = 13;
            if ("ar".equals(lang) || "ja".equals(lang) || "zh".equals(lang) && !IS_WIN) {
                smallSize += 2;
                legendSize += 2;
                largeSize += 3;
            }
            String ssmall = this._context.getProperty(PROP_FONT_MONO, DEFAULT_FONT_NAME);
            String slegend = this._context.getProperty(PROP_FONT_LEGEND, "Dialog");
            String stitle = this._context.getProperty(PROP_FONT_TITLE, "Dialog");
            Font small = new Font(ssmall, 0, smallSize);
            Font legnd = new Font(slegend, 0, legendSize);
            Font large = new Font(stitle, 0, largeSize);
            def.setFont(RrdGraphDef.FONTTAG_DEFAULT, small);
            def.setFont(RrdGraphDef.FONTTAG_AXIS, small);
            def.setFont(RrdGraphDef.FONTTAG_UNIT, small);
            def.setFont(RrdGraphDef.FONTTAG_LEGEND, legnd);
            def.setFont(RrdGraphDef.FONTTAG_TITLE, large);
            def.setTimeSpan(start / 1000L, end / 1000L);
            def.setMinValue(0.0);
            String name = this._listener.getRate().getRateStat().getName();
            if (!(name.indexOf("Size") < 0 && name.indexOf("memory") < 0 || showEvents)) {
                def.setBase(1024.0);
            }
            if (titleOverride != null) {
                def.setTitle(titleOverride);
            } else if (!hideTitle) {
                String p = IS_WIN && "zh".equals(Messages.getLanguage(this._context)) ? DataHelper.formatDuration(period) : DataHelper.formatDuration2(period).replace("&nbsp;", " ");
                String title = showEvents ? name + ' ' + this._t("events in {0}", p) : name + ' ' + this._t("averaged for {0}", p);
                def.setTitle(title);
            }
            String path = this._listener.getData().getPath();
            String[] dsNames = this._listener.getData().getDsNames();
            if (showEvents) {
                plotName = dsNames[1];
                descr = this._t("Events per period");
            } else {
                plotName = dsNames[0];
                descr = this._t(this._listener.getRate().getRateStat().getDescription());
            }
            def.datasource(plotName, path, plotName, SummaryListener.CF, this._listener.getBackendFactory());
            if (descr.length() > 0) {
                def.area(plotName, (Paint)AREA_COLOR, descr + "\\l");
            } else {
                def.area(plotName, AREA_COLOR);
            }
            if (!hideLegend) {
                Variable var = new Variable.AVERAGE();
                def.datasource("avg", plotName, var);
                def.gprint("avg", "   " + this._t("Avg") + ": %.2f%s");
                var = new Variable.MAX();
                def.datasource("max", plotName, var);
                def.gprint("max", ' ' + this._t("Max") + ": %.2f%S");
                var = new Variable.LAST();
                def.datasource("last", plotName, var);
                def.gprint("last", ' ' + this._t("Now") + ": %.2f%S\\l");
            }
            String plotName2 = null;
            if (lsnr2 != null) {
                String[] dsNames2 = lsnr2.getData().getDsNames();
                plotName2 = dsNames2[0];
                String path2 = lsnr2.getData().getPath();
                String descr2 = this._t(lsnr2.getRate().getRateStat().getDescription());
                def.datasource(plotName2, path2, plotName2, SummaryListener.CF, lsnr2.getBackendFactory());
                def.line(plotName2, (Paint)LINE_COLOR, (String)descr2 + "\\l", 2.0f);
                if (!hideLegend) {
                    Variable.AVERAGE aVERAGE = new Variable.AVERAGE();
                    def.datasource("avg2", plotName2, aVERAGE);
                    def.gprint("avg2", "   " + this._t("Avg") + ": %.2f%s");
                    Variable.MAX mAX = new Variable.MAX();
                    def.datasource("max2", plotName2, mAX);
                    def.gprint("max2", ' ' + this._t("Max") + ": %.2f%S");
                    Variable.LAST lAST = new Variable.LAST();
                    def.datasource("last2", plotName2, lAST);
                    def.gprint("last2", ' ' + this._t("Now") + ": %.2f%S\\l");
                }
            }
            if (!hideLegend) {
                SimpleDateFormat sdf = new SimpleDateFormat("dd MMM HH:mm");
                SortedMap<Long, String> events = ((RouterContext)this._context).router().eventLog().getEvents("started", start);
                for (Map.Entry entry : events.entrySet()) {
                    long started = (Long)entry.getKey();
                    if (started <= start || started >= end) continue;
                    String legend = Messages.isRTL(lang) ? this._t("Restart") + ' ' + sdf.format(new Date(started)) + " - " + (String)entry.getValue() + "\\l" : this._t("Restart") + ' ' + sdf.format(new Date(started)) + " [" + (String)entry.getValue() + "]\\l";
                    def.vrule(started / 1000L, (Paint)RESTART_BAR_COLOR, legend, 2.0f);
                }
                def.comment(sdf.format(new Date(start)) + " \u2014 " + sdf.format(new Date(end)) + " UTC\\r");
            }
            if (!showCredit) {
                def.setShowSignature(false);
            }
            if (hideLegend) {
                def.setNoLegend(true);
            }
            if (hideGrid) {
                def.setDrawXGrid(false);
                def.setDrawYGrid(false);
            }
            def.setAntiAliasing(false);
            def.setTextAntiAliasing(true);
            def.setGridStroke(GRID_STROKE);
            def.setWidth(width);
            def.setHeight(height);
            def.setImageFormat("PNG");
            def.setLazy(true);
            try {
                graph = new RrdGraph(def);
            }
            catch (NullPointerException npe) {
                this._log.error("Error rendering", npe);
                StatSummarizer.setDisabled(this._context);
                throw new IOException("Error rendering - disabling graph generation. Missing font? See http://trac.i2p2.i2p/ticket/915");
            }
            int totalWidth = graph.getRrdGraphInfo().getWidth();
            int totalHeight = graph.getRrdGraphInfo().getHeight();
            BufferedImage bufferedImage = new BufferedImage(totalWidth, totalHeight, 8);
            Graphics gfx = bufferedImage.getGraphics();
            graph.render(gfx);
            ios = new MemoryCacheImageOutputStream(out);
            ImageIO.write((RenderedImage)bufferedImage, "png", (ImageOutputStream)ios);
            this._context.statManager().addRateData("graph.renderTime", System.currentTimeMillis() - begin);
        }
        catch (RrdException re) {
            this._log.error("Error rendering", re);
            throw new IOException("Error plotting: " + re.getLocalizedMessage());
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error rendering", ioe);
            }
            throw ioe;
        }
        catch (OutOfMemoryError oom) {
            this._log.error("Error rendering", oom);
            throw new IOException("Error plotting: " + oom.getLocalizedMessage());
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String _t(String s) {
        if (IS_WIN && "zh".equals(Messages.getLanguage(this._context))) {
            return s;
        }
        return Messages.getString(s, this._context);
    }

    private String _t(String s, String o) {
        if (IS_WIN && "zh".equals(Messages.getLanguage(this._context))) {
            return s.replace("{0}", o);
        }
        return Messages.getString(s, o, this._context);
    }
}

