/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.i2p.I2PAppContext;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateTask;
import net.i2p.update.UpdateType;
import net.i2p.util.EepGet;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.PartialEepGet;
import net.i2p.util.SSLEepGet;
import net.i2p.util.VersionComparator;

class UpdateRunner
extends I2PAppThread
implements UpdateTask,
EepGet.StatusListener {
    protected final RouterContext _context;
    protected final Log _log;
    protected final ConsoleUpdateManager _mgr;
    protected final UpdateType _type;
    protected final UpdateMethod _method;
    protected final List<URI> _urls;
    protected final String _updateFile;
    protected volatile boolean _isRunning;
    protected boolean done;
    protected EepGet _get;
    protected boolean _isPartial;
    protected String _newVersion;
    protected final ByteArrayOutputStream _baos;
    protected URI _currentURI;
    private final String _currentVersion;
    protected static final long CONNECT_TIMEOUT = 55000L;
    protected static final long INACTIVITY_TIMEOUT = 300000L;
    protected static final long NOPROXY_INACTIVITY_TIMEOUT = 60000L;

    public UpdateRunner(RouterContext ctx, ConsoleUpdateManager mgr, UpdateType type, List<URI> uris) {
        this(ctx, mgr, type, uris, "0.9.45");
    }

    public UpdateRunner(RouterContext ctx, ConsoleUpdateManager mgr, UpdateType type, UpdateMethod method, List<URI> uris) {
        this(ctx, mgr, type, method, uris, "0.9.45");
    }

    public UpdateRunner(RouterContext ctx, ConsoleUpdateManager mgr, UpdateType type, List<URI> uris, String currentVersion) {
        this(ctx, mgr, type, UpdateMethod.HTTP, uris, currentVersion);
    }

    public UpdateRunner(RouterContext ctx, ConsoleUpdateManager mgr, UpdateType type, UpdateMethod method, List<URI> uris, String currentVersion) {
        super("Update Runner");
        this.setDaemon(true);
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._mgr = mgr;
        this._type = type;
        this._method = method;
        this._urls = uris;
        this._baos = new ByteArrayOutputStream(TrustedUpdate.HEADER_BYTES);
        this._updateFile = new File(ctx.getTempDir(), "update" + ctx.random().nextInt() + ".tmp").getAbsolutePath();
        this._currentVersion = currentVersion;
    }

    @Override
    public boolean isRunning() {
        return this._isRunning;
    }

    @Override
    public void shutdown() {
        this._isRunning = false;
        this.interrupt();
    }

    @Override
    public UpdateType getType() {
        return this._type;
    }

    @Override
    public UpdateMethod getMethod() {
        return this._method;
    }

    @Override
    public URI getURI() {
        return this._currentURI;
    }

    @Override
    public String getID() {
        return "";
    }

    @Override
    public void run() {
        this._isRunning = true;
        try {
            this.update();
        }
        catch (Throwable t) {
            this._mgr.notifyTaskFailed(this, "", t);
        }
        finally {
            this._isRunning = false;
        }
    }

    protected void update() {
        int proxyPort;
        String proxyHost;
        boolean shouldProxy;
        boolean isSSL = false;
        if (this._method == UpdateMethod.HTTP) {
            shouldProxy = this._context.getProperty("router.updateThroughProxy", true);
            if (shouldProxy) {
                proxyHost = this._context.getProperty("router.updateProxyHost", "127.0.0.1");
                proxyPort = ConfigUpdateHandler.proxyPort(this._context);
                if (proxyPort == 4444 && proxyHost.equals("127.0.0.1") && this._context.portMapper().getPort("HTTP") < 0) {
                    String msg = this._t("HTTP client proxy tunnel must be running");
                    if (this._log.shouldWarn()) {
                        this._log.warn(msg);
                    }
                    this.updateStatus("<b>" + msg + "</b>");
                    this._mgr.notifyTaskFailed(this, msg, null);
                    return;
                }
            } else {
                proxyHost = null;
                proxyPort = 0;
            }
        } else if (this._method == UpdateMethod.HTTP_CLEARNET) {
            shouldProxy = false;
            proxyHost = null;
            proxyPort = 0;
        } else if (this._method == UpdateMethod.HTTPS_CLEARNET) {
            shouldProxy = false;
            proxyHost = null;
            proxyPort = 0;
            isSSL = true;
        } else {
            throw new IllegalArgumentException();
        }
        if (this._urls.isEmpty()) {
            String msg = "Update source list is empty, cannot download update";
            this.updateStatus("<b>" + msg + "</b>");
            this._log.error(msg);
            this._mgr.notifyTaskFailed(this, msg, null);
            return;
        }
        Iterator<URI> iterator = this._urls.iterator();
        while (iterator.hasNext()) {
            URI uri;
            this._currentURI = uri = iterator.next();
            String updateURL = uri.toString();
            if (this._method == UpdateMethod.HTTP && !"http".equals(uri.getScheme()) || this._method == UpdateMethod.HTTP_CLEARNET && !"http".equals(uri.getScheme()) || this._method == UpdateMethod.HTTPS_CLEARNET && !"https".equals(uri.getScheme()) || uri.getHost() == null || this._method != UpdateMethod.HTTP && uri.getHost().toLowerCase(Locale.US).endsWith(".i2p")) {
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("Bad update URI " + uri + " for method " + (Object)((Object)this._method));
                continue;
            }
            this.updateStatus("<b>" + this._t("Updating from {0}", UpdateRunner.linkify(updateURL)) + "</b>");
            if (this._log.shouldLog(10)) {
                this._log.debug("Selected update URL: " + updateURL);
            }
            this._newVersion = null;
            if (!isSSL) {
                this._isPartial = true;
                this._baos.reset();
                try {
                    this._get = new PartialEepGet((I2PAppContext)this._context, proxyHost, proxyPort, this._baos, updateURL, TrustedUpdate.HEADER_BYTES);
                    this._get.addStatusListener(this);
                    this._get.fetch(55000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this._isPartial = false;
                if (this._newVersion == null) continue;
            }
            try {
                this._get = shouldProxy ? new EepGet((I2PAppContext)this._context, proxyHost, proxyPort, 40, this._updateFile, updateURL, false) : (isSSL ? new SSLEepGet((I2PAppContext)this._context, this._updateFile, updateURL) : new EepGet(this._context, 1, this._updateFile, updateURL, false));
                this._get.addStatusListener(this);
                this._get.fetch(55000L, -1L, shouldProxy ? 300000L : 60000L);
            }
            catch (Throwable t) {
                this._log.error("Error updating", t);
            }
            if (!this.done) continue;
            break;
        }
        new File(this._updateFile).delete();
        if (!this.done) {
            this._mgr.notifyTaskFailed(this, "", null);
        }
    }

    @Override
    public void attemptFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt, int numRetries, Exception cause) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Attempt failed on " + url, cause);
        }
        this._mgr.notifyAttemptFailed(this, url, null);
    }

    @Override
    public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
        if (this._isPartial) {
            return;
        }
        long d = (long)currentWrite + bytesTransferred;
        String status = "<b>" + this._t("Updating I2P") + "</b>";
        this._mgr.notifyProgress(this, status, d, d + bytesRemaining);
    }

    @Override
    public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
        File tmp;
        if (this._isPartial) {
            boolean newer;
            String newVersion = TrustedUpdate.getVersionString(new ByteArrayInputStream(this._baos.toByteArray()));
            boolean bl = newer = VersionComparator.comp(newVersion, this._currentVersion) > 0;
            if (newer) {
                this._newVersion = newVersion;
            } else {
                this.updateStatus("<b>" + this._t("No new version found at {0}", UpdateRunner.linkify(url)) + "</b>");
                if (this._log.shouldLog(30)) {
                    this._log.warn("Found old version \"" + newVersion + "\" at " + url);
                }
            }
            return;
        }
        if (this._newVersion == null) {
            this._newVersion = "unknown";
        }
        if (this._mgr.notifyComplete(this, this._newVersion, tmp = new File(this._updateFile))) {
            this.done = true;
        } else {
            tmp.delete();
        }
    }

    @Override
    public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Update from " + url + " did not download completely (" + bytesRemaining + " remaining after " + currentAttempt + " tries)");
        }
        this.updateStatus("<b>" + this._t("Transfer failed from {0}", UpdateRunner.linkify(url)) + "</b>");
        this._mgr.notifyAttemptFailed(this, url, null);
    }

    @Override
    public void headerReceived(String url, int attemptNum, String key, String val) {
    }

    @Override
    public void attempting(String url) {
    }

    protected void updateStatus(String s) {
        this._mgr.notifyProgress(this, s);
    }

    protected static String linkify(String url) {
        return ConsoleUpdateManager.linkify(url);
    }

    protected String _t(String s) {
        return this._mgr._t(s);
    }

    protected String _t(String s, Object o) {
        return this._mgr._t(s, o);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ' ' + (Object)((Object)this.getType()) + ' ' + this.getID() + ' ' + (Object)((Object)this.getMethod()) + ' ' + this.getURI();
    }
}

