/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.i2p.I2PAppContext;
import net.i2p.crypto.HMAC256Generator;

public final class HKDF {
    private final I2PAppContext _context;
    private static final byte[] ONE = new byte[]{1};

    public HKDF(I2PAppContext context) {
        this._context = context;
    }

    public void calculate(byte[] key, byte[] data, byte[] out) {
        HMAC256Generator hmac = this._context.hmac256();
        hmac.calculate(key, data, 0, data.length, out, 0);
        hmac.calculate(out, ONE, 0, 1, out, 0);
    }

    public void calculate(byte[] key, byte[] data, String info, byte[] out) {
        HMAC256Generator hmac = this._context.hmac256();
        int ilen = info.length();
        hmac.calculate(key, data, 0, data.length, out, 0);
        byte[] tmp = new byte[ilen + 1];
        for (int i = 0; i < ilen; ++i) {
            tmp[i] = (byte)info.charAt(i);
        }
        tmp[ilen] = 1;
        hmac.calculate(out, tmp, 0, tmp.length, out, 0);
    }

    public void calculate(byte[] key, byte[] data, byte[] out, byte[] out2, int off2) {
        this.calculate(key, data, "", out, out2, off2);
    }

    public void calculate(byte[] key, byte[] data, String info, byte[] out, byte[] out2, int off2) {
        int ilen = info.length();
        byte[] tmp = new byte[ilen + 1];
        for (int i = 0; i < ilen; ++i) {
            tmp[i] = (byte)info.charAt(i);
        }
        tmp[ilen] = 1;
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKey keyObj = new HMAC256Generator.HMACKey(key);
            mac.init(keyObj);
            mac.update(data);
            mac.doFinal(out, 0);
            keyObj = new SecretKeySpec(out, 0, 32, "HmacSHA256");
            mac.init(keyObj);
            mac.update(tmp, 0, ilen + 1);
            mac.doFinal(out, 0);
            tmp[ilen] = 2;
            mac.reset();
            mac.update(out, 0, 32);
            mac.update(tmp, 0, ilen + 1);
            mac.doFinal(out2, off2);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("HmacSHA256", e);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("HmacSHA256", e);
        }
    }
}

