/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.BOB;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.i2p.BOB.DoCMDS;
import net.i2p.BOB.Logger;
import net.i2p.BOB.NamedDB;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.util.I2PAppThread;
import net.i2p.util.SimpleTimer2;

public class BOB
implements Runnable,
ClientApp {
    public static final String PROP_CONFIG_LOCATION = "BOB.config";
    public static final String PROP_BOB_PORT = "BOB.port";
    public static final String PROP_BOB_HOST = "BOB.host";
    public static final String PROP_CFG_VER = "BOB.CFG.VER";
    private static BOB _bob;
    private final NamedDB database;
    private final Properties props = new Properties();
    private final AtomicBoolean spin = new AtomicBoolean(true);
    private static final String P_RUNNING = "RUNNING";
    private static final String P_STARTING = "STARTING";
    private static final String P_STOPPING = "STOPPING";
    private final AtomicBoolean lock = new AtomicBoolean(false);
    private final I2PAppContext _context;
    private final Logger _log;
    private final ClientAppManager _mgr;
    private final String[] _args;
    private volatile ClientAppState _state = ClientAppState.UNINITIALIZED;
    private volatile ServerSocket listener;
    private volatile Thread _runner;

    @Deprecated
    public static synchronized void stop() {
        if (_bob != null) {
            _bob.shutdown(null);
        }
    }

    public BOB(I2PAppContext context, ClientAppManager mgr, String[] args) {
        String classPath;
        this._context = context;
        boolean logToStdout = false;
        URL classResource = BOB.class.getResource("BOB.class");
        if (classResource != null && (classPath = classResource.toString()).startsWith("jar")) {
            String manifestPath = classPath.substring(0, classPath.lastIndexOf(33) + 1) + "/META-INF/MANIFEST.MF";
            try {
                Manifest manifest = new Manifest(new URL(manifestPath).openStream());
                Attributes attrs = manifest.getMainAttributes();
                String mainClass = attrs.getValue("Main-Class");
                if ("net.i2p.BOB.Main".equals(mainClass)) {
                    logToStdout = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._log = new Logger(context.logManager().getLog(BOB.class), logToStdout);
        this._mgr = mgr;
        this._args = args;
        this._state = ClientAppState.INITIALIZED;
        this.database = new NamedDB();
        this.loadConfig();
    }

    public static synchronized void main(String[] args) {
        try {
            _bob = new BOB(I2PAppContext.getGlobalContext(), null, args);
            _bob.startup();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig() {
        int i = 0;
        boolean save = false;
        String configLocation = System.getProperty(PROP_CONFIG_LOCATION, "bob.config");
        SimpleTimer2 Y2 = SimpleTimer2.getInstance();
        i = Y2.hashCode();
        File cfg = new File(configLocation);
        if (!cfg.isAbsolute()) {
            cfg = new File(this._context.getConfigDir(), configLocation);
        }
        FileInputStream fi = null;
        try {
            fi = new FileInputStream(cfg);
            this.props.load(fi);
        }
        catch (FileNotFoundException fnfe) {
            this._log.warn("Unable to load up the BOB config file " + cfg.getAbsolutePath() + ", Using defaults.", fnfe);
            save = true;
        }
        catch (IOException ioe) {
            this._log.warn("IOException on BOB config file " + cfg.getAbsolutePath() + ", using defaults.", ioe);
        }
        finally {
            if (fi != null) {
                try {
                    fi.close();
                }
                catch (IOException fnfe) {}
            }
        }
        if (!this.props.containsKey("i2cp.tcp.host")) {
            this.props.setProperty("i2cp.tcp.host", "localhost");
            save = true;
        }
        if (!this.props.containsKey("i2cp.tcp.port")) {
            this.props.setProperty("i2cp.tcp.port", Integer.toString(7654));
            save = true;
        }
        if (!this.props.containsKey(PROP_BOB_PORT)) {
            this.props.setProperty(PROP_BOB_PORT, "2827");
            save = true;
        }
        if (!this.props.containsKey("inbound.length")) {
            this.props.setProperty("inbound.length", "3");
            save = true;
        }
        if (!this.props.containsKey("outbound.length")) {
            this.props.setProperty("outbound.length", "3");
            save = true;
        }
        if (!this.props.containsKey("inbound.lengthVariance")) {
            this.props.setProperty("inbound.lengthVariance", "0");
            save = true;
        }
        if (!this.props.containsKey("outbound.lengthVariance")) {
            this.props.setProperty("outbound.lengthVariance", "0");
            save = true;
        }
        if (!this.props.containsKey(PROP_BOB_HOST)) {
            this.props.setProperty(PROP_BOB_HOST, "localhost");
            save = true;
        }
        if (!this.props.containsKey(PROP_CFG_VER)) {
            this.props.setProperty("i2cp.messageReliability", "none");
            this.props.setProperty(PROP_CFG_VER, "1");
            save = true;
        }
        if (save) {
            cfg = new File(configLocation);
            if (!cfg.isAbsolute()) {
                cfg = new File(this._context.getConfigDir(), configLocation);
            }
            FileOutputStream fo = null;
            try {
                this._log.warn("Writing new defaults file " + cfg.getAbsolutePath());
                fo = new FileOutputStream(cfg);
                this.props.store(fo, cfg.getAbsolutePath());
            }
            catch (IOException ioe) {
                this._log.error("IOException on BOB config file " + cfg.getAbsolutePath(), ioe);
            }
            finally {
                if (fo != null) {
                    try {
                        fo.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void startListener() throws IOException {
        this.listener = new ServerSocket(Integer.parseInt(this.props.getProperty(PROP_BOB_PORT)), 10, InetAddress.getByName(this.props.getProperty(PROP_BOB_HOST)));
        this.listener.setSoTimeout(500);
    }

    private void startThread() {
        I2PAppThread t = new I2PAppThread((Runnable)this, "BOBListener");
        t.start();
        this._runner = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.listener == null) {
            return;
        }
        this.changeState(ClientAppState.RUNNING);
        this._log.info("BOB is now running.");
        if (this._mgr != null) {
            this._mgr.register((ClientApp)this);
        }
        this._context.portMapper().register("BOB", this.props.getProperty(PROP_BOB_HOST), Integer.parseInt(this.props.getProperty(PROP_BOB_PORT)));
        int i = 0;
        boolean g = false;
        this.spin.set(true);
        try {
            Socket server = null;
            while (this.spin.get()) {
                try {
                    server = this.listener.accept();
                    server.setKeepAlive(true);
                    g = true;
                }
                catch (ConnectException ce) {
                    g = false;
                }
                catch (SocketTimeoutException ste) {
                    g = false;
                }
                if (!g) continue;
                DoCMDS conn_c = new DoCMDS(this.spin, this.lock, server, this.props, this.database, this._log);
                I2PAppThread t = new I2PAppThread((Runnable)conn_c);
                t.setName("BOB.DoCMDS " + i);
                t.start();
                ++i;
            }
            this.changeState(ClientAppState.STOPPING);
        }
        catch (Exception e) {
            if (this.spin.get()) {
                this._log.error("Unexpected error while listening for connections", e);
            } else {
                e = null;
            }
            this.changeState(ClientAppState.STOPPING, e);
        }
        finally {
            this._log.info("BOB is now shutting down...");
            this._context.portMapper().unregister("BOB");
            try {
                this.listener.close();
            }
            catch (Exception e) {}
            BOB.visitAllThreads();
            this.database.getReadLock();
            try {
                for (Object ndb : this.database.values()) {
                    NamedDB nickinfo = (NamedDB)ndb;
                    nickinfo.getReadLock();
                    boolean released = false;
                    try {
                        if (!nickinfo.get(P_RUNNING).equals(Boolean.TRUE) || !nickinfo.get(P_STOPPING).equals(Boolean.FALSE) || !nickinfo.get(P_STARTING).equals(Boolean.FALSE)) continue;
                        nickinfo.releaseReadLock();
                        released = true;
                        nickinfo.getWriteLock();
                        try {
                            nickinfo.add(P_STOPPING, Boolean.TRUE);
                        }
                        finally {
                            nickinfo.releaseWriteLock();
                        }
                    }
                    finally {
                        if (released) continue;
                        nickinfo.releaseReadLock();
                    }
                }
            }
            finally {
                this.database.releaseReadLock();
            }
            this.changeState(ClientAppState.STOPPED);
            this._log.info("BOB is now stopped.");
        }
    }

    private static void visitAllThreads() {
        ThreadGroup root = Thread.currentThread().getThreadGroup().getParent();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        BOB.waitjoin(root, 0, root.getName());
    }

    private static void waitjoin(ThreadGroup group, int level, String tn) {
        int numThreads = group.activeCount();
        Thread[] threads = new Thread[numThreads * 2];
        numThreads = group.enumerate(threads, false);
        for (int i = 0; i < numThreads; ++i) {
            Thread thread = threads[i];
            if (!thread.getName().startsWith("BOB.DoCMDS ")) continue;
            try {
                if (!thread.isAlive()) continue;
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        int numGroups = group.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[numGroups * 2];
        numGroups = group.enumerate(groups, false);
        for (int i = 0; i < numGroups; ++i) {
            BOB.waitjoin(groups[i], level + 1, groups[i].getName());
        }
    }

    public void startup() throws IOException {
        if (this._state != ClientAppState.INITIALIZED) {
            return;
        }
        this.changeState(ClientAppState.STARTING);
        try {
            this.startListener();
        }
        catch (IOException e) {
            this._log.error("Error starting BOB on" + this.props.getProperty(PROP_BOB_HOST) + ":" + this.props.getProperty(PROP_BOB_PORT), e);
            this.changeState(ClientAppState.START_FAILED, e);
            throw e;
        }
        this.startThread();
    }

    public void shutdown(String[] args) {
        if (this._state != ClientAppState.RUNNING) {
            return;
        }
        this.changeState(ClientAppState.STOPPING);
        this.spin.set(false);
        if (this._runner != null) {
            this._runner.interrupt();
        } else {
            this.changeState(ClientAppState.STOPPED);
        }
    }

    public ClientAppState getState() {
        return this._state;
    }

    public String getName() {
        return "BOB";
    }

    public String getDisplayName() {
        return "BOB " + Arrays.toString(this._args);
    }

    private void changeState(ClientAppState state) {
        this.changeState(state, null);
    }

    private synchronized void changeState(ClientAppState state, Exception e) {
        this._state = state;
        if (this._mgr != null) {
            this._mgr.notify((ClientApp)this, state, null, e);
        }
    }
}

