/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Properties;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.sam.SAMRawReceiver;
import net.i2p.sam.SAMRawSession;
import net.i2p.sam.SAMv3DatagramServer;
import net.i2p.sam.SAMv3Handler;
import net.i2p.sam.Session;
import net.i2p.sam.SessionRecord;

class SAMv3RawSession
extends SAMRawSession
implements Session,
SAMRawReceiver {
    private final String nick;
    private final SAMv3Handler handler;
    private final SAMv3DatagramServer server;
    private final SocketAddress clientAddress;
    private final boolean _sendHeader;

    @Override
    public String getNick() {
        return this.nick;
    }

    public SAMv3RawSession(String nick, SAMv3DatagramServer dgServer) throws IOException, DataFormatException, I2PSessionException {
        super(SAMv3Handler.sSessionsHash.get(nick).getDest(), SAMv3Handler.sSessionsHash.get(nick).getProps(), null);
        this.nick = nick;
        this.recv = this;
        this.server = dgServer;
        SessionRecord rec = SAMv3Handler.sSessionsHash.get(nick);
        if (rec == null) {
            throw new InterruptedIOException();
        }
        this.handler = rec.getHandler();
        Properties props = rec.getProps();
        this.clientAddress = SAMv3RawSession.getSocketAddress(props, this.handler);
        this._sendHeader = (this.handler.verMajor == 3 && this.handler.verMinor >= 2 || this.handler.verMajor > 3) && Boolean.parseBoolean(props.getProperty("HEADER"));
    }

    public SAMv3RawSession(String nick, Properties props, SAMv3Handler handler, I2PSession isess, int listenProtocol, int listenPort, SAMv3DatagramServer dgServer) throws IOException, DataFormatException, I2PSessionException {
        super(isess, props, listenProtocol, listenPort, null);
        this.nick = nick;
        this.recv = this;
        this.server = dgServer;
        this.handler = handler;
        this.clientAddress = SAMv3RawSession.getSocketAddress(props, handler);
        this._sendHeader = (handler.verMajor == 3 && handler.verMinor >= 2 || handler.verMajor > 3) && Boolean.parseBoolean(props.getProperty("HEADER"));
    }

    static SocketAddress getSocketAddress(Properties props, SAMv3Handler handler) {
        String portStr = props.getProperty("PORT");
        if (portStr == null) {
            return null;
        }
        int port = Integer.parseInt(portStr);
        String host = props.getProperty("HOST");
        if (host == null) {
            host = handler.getClientIP();
        }
        return new InetSocketAddress(host, port);
    }

    @Override
    public void receiveRawBytes(byte[] data, int proto, int fromPort, int toPort) throws IOException {
        if (this.clientAddress == null) {
            this.handler.receiveRawBytes(data, proto, fromPort, toPort);
        } else {
            ByteBuffer msgBuf;
            if (this._sendHeader) {
                StringBuilder buf = new StringBuilder(64);
                buf.append("PROTOCOL=").append(proto).append(" FROM_PORT=").append(fromPort).append(" TO_PORT=").append(toPort).append('\n');
                String msg = buf.toString();
                msgBuf = ByteBuffer.allocate(msg.length() + data.length);
                msgBuf.put(DataHelper.getASCII(msg));
            } else {
                msgBuf = ByteBuffer.allocate(data.length);
            }
            msgBuf.put(data);
            msgBuf.flip();
            this.server.send(this.clientAddress, msgBuf);
        }
    }

    @Override
    public void stopRawReceiving() {
    }
}

