/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jsp;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jasper.servlet.JspServlet;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;

public class JettyJspServlet
extends JspServlet {
    private static final long serialVersionUID = -5387857473125086791L;

    @Override
    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpServletRequest request = null;
        if (!(req instanceof HttpServletRequest)) {
            throw new ServletException("Request not HttpServletRequest");
        }
        request = req;
        String servletPath = null;
        String pathInfo = null;
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (servletPath == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            }
        } else {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        String pathInContext = URIUtil.addPaths((String)servletPath, (String)pathInfo);
        String jspFile = this.getInitParameter("jspFile");
        if (jspFile == null) {
            if (pathInContext.endsWith("/")) {
                this.getServletContext().getNamedDispatcher("default").forward((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            Resource resource = ((ContextHandler.Context)this.getServletContext()).getContextHandler().getResource(pathInContext);
            if (resource != null && resource.isDirectory()) {
                this.getServletContext().getNamedDispatcher("default").forward((ServletRequest)req, (ServletResponse)resp);
                return;
            }
        }
        super.service(req, resp);
    }
}

