/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.app.RouterApp;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.startup.RouterAppManager;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

public class LoadClientAppsJob
extends JobImpl {
    private final Log _log;
    private static boolean _loaded = false;

    public LoadClientAppsJob(RouterContext ctx) {
        super(ctx);
        this._log = ctx.logManager().getLog(LoadClientAppsJob.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runJob() {
        Class<LoadClientAppsJob> clazz = LoadClientAppsJob.class;
        synchronized (LoadClientAppsJob.class) {
            if (_loaded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            _loaded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            List<ClientAppConfig> apps = ClientAppConfig.getClientApps(this.getContext());
            if (apps.isEmpty()) {
                this._log.logAlways(30, "Warning - No client apps or router console configured - we are just a router");
                System.err.println("Warning - No client apps or router console configured - we are just a router");
                return;
            }
            for (int i = 0; i < apps.size(); ++i) {
                ClientAppConfig app = apps.get(i);
                if (app.disabled) {
                    if (!"net.i2p.router.web.RouterConsoleRunner".equals(app.className)) continue;
                    String s = "Warning - Router console is disabled. To enable,\n edit the file " + ClientAppConfig.configFile(this.getContext()) + ",\n change the line \"clientApp." + i + ".startOnLoad=false\" to \"clientApp." + i + ".startOnLoad=true\",\n and restart.";
                    this._log.logAlways(30, s);
                    System.err.println(s);
                    continue;
                }
                String[] argVal = LoadClientAppsJob.parseArgs(app.args);
                if (app.delay == 0L) {
                    LoadClientAppsJob.runClient(app.className, app.clientName, argVal, this.getContext(), this._log);
                    continue;
                }
                if (app.delay > 0L) {
                    DelayedRunClient drc = new DelayedRunClient(this.getContext().simpleTimer2(), this.getContext(), app.className, app.clientName, argVal);
                    drc.schedule(app.delay);
                    continue;
                }
                WaitForRunningClient wfrc = new WaitForRunningClient(this.getContext().simpleTimer2(), this.getContext(), app.className, app.clientName, argVal);
                wfrc.schedule(1000L);
            }
            return;
        }
    }

    public static String[] parseArgs(String args) {
        ArrayList<String> argList = new ArrayList<String>(4);
        if (args != null) {
            String str;
            StringBuilder buf = new StringBuilder(32);
            boolean isQuoted = false;
            block4: for (int i = 0; i < args.length(); ++i) {
                char c = args.charAt(i);
                switch (c) {
                    case '\"': 
                    case '\'': {
                        String str2;
                        if (isQuoted) {
                            str2 = buf.toString().trim();
                            if (str2.length() > 0) {
                                argList.add(str2);
                            }
                            buf.setLength(0);
                        }
                        isQuoted = !isQuoted;
                        continue block4;
                    }
                    case '\t': 
                    case ' ': {
                        if (isQuoted) {
                            buf.append(c);
                            continue block4;
                        }
                        String str2 = buf.toString().trim();
                        if (str2.length() > 0) {
                            argList.add(str2);
                        }
                        buf.setLength(0);
                        continue block4;
                    }
                    default: {
                        buf.append(c);
                    }
                }
            }
            if (buf.length() > 0 && (str = buf.toString().trim()).length() > 0) {
                argList.add(str);
            }
        }
        String[] rv = new String[argList.size()];
        for (int i = 0; i < argList.size(); ++i) {
            rv[i] = (String)argList.get(i);
        }
        return rv;
    }

    public static void testClient(String className, ClassLoader cl) throws ClassNotFoundException {
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        Class.forName(className, false, cl);
    }

    public static void runClientInline(String className, String clientName, String[] args, Log log) throws Exception {
        LoadClientAppsJob.runClientInline(className, clientName, args, log, null);
    }

    public static void runClientInline(String className, String clientName, String[] args, Log log, ClassLoader cl) throws Exception {
        if (log.shouldLog(20)) {
            log.info("Loading up the client application " + clientName + ": " + className + " " + Arrays.toString(args));
        }
        if (args == null) {
            args = new String[]{};
        }
        Class<?> cls = Class.forName(className, true, cl);
        Method method = cls.getMethod("main", String[].class);
        method.invoke(cls, new Object[]{args});
    }

    public static void runClient(String className, String clientName, String[] args, RouterContext ctx, Log log) {
        LoadClientAppsJob.runClient(className, clientName, args, ctx, log, null, null);
    }

    public static void runClient(String className, String clientName, String[] args, RouterContext ctx, Log log, ThreadGroup threadGroup, ClassLoader cl) {
        if (log.shouldLog(20)) {
            log.info("Loading up the client application " + clientName + ": " + className + " " + Arrays.toString(args));
        }
        I2PThread t = threadGroup != null ? new I2PThread(threadGroup, new RunApp(className, clientName, args, ctx, log, cl)) : new I2PThread(new RunApp(className, clientName, args, ctx, log, cl));
        if (clientName == null) {
            clientName = className + " client";
        }
        t.setName(clientName);
        t.setDaemon(true);
        if (cl != null) {
            t.setContextClassLoader(cl);
        }
        t.start();
    }

    @Override
    public String getName() {
        return "Load up any client applications";
    }

    private static final class RunApp
    implements Runnable {
        private final String _className;
        private final String _appName;
        private final String[] _args;
        private final RouterContext _ctx;
        private final Log _log;
        private final ClassLoader _cl;

        public RunApp(String className, String appName, String[] args, RouterContext ctx, Log log, ClassLoader cl) {
            this._className = className;
            this._appName = appName;
            this._args = args == null ? new String[0] : args;
            this._ctx = ctx;
            this._log = log;
            this._cl = cl == null ? ClassLoader.getSystemClassLoader() : cl;
        }

        @Override
        public void run() {
            try {
                Class<?> cls = Class.forName(this._className, true, this._cl);
                if (RunApp.isRouterApp(cls)) {
                    Constructor<?> con = cls.getConstructor(RouterContext.class, ClientAppManager.class, String[].class);
                    RouterAppManager mgr = this._ctx.routerAppManager();
                    Object[] conArgs = new Object[]{this._ctx, this._ctx.clientAppManager(), this._args};
                    RouterApp app = (RouterApp)con.newInstance(conArgs);
                    mgr.addAndStart(app, this._args);
                } else if (RunApp.isClientApp(cls)) {
                    Constructor<?> con = cls.getConstructor(I2PAppContext.class, ClientAppManager.class, String[].class);
                    RouterAppManager mgr = this._ctx.routerAppManager();
                    Object[] conArgs = new Object[]{this._ctx, this._ctx.clientAppManager(), this._args};
                    ClientApp app = (ClientApp)con.newInstance(conArgs);
                    mgr.addAndStart(app, this._args);
                } else {
                    Method method = cls.getMethod("main", String[].class);
                    method.invoke(cls, new Object[]{this._args});
                }
            }
            catch (Throwable t) {
                this._log.log(50, "Error starting up the client class " + this._className, t);
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Done running client application " + this._appName);
            }
        }

        private static boolean isRouterApp(Class<?> cls) {
            return RunApp.isInterface(cls, RouterApp.class);
        }

        private static boolean isClientApp(Class<?> cls) {
            return RunApp.isInterface(cls, ClientApp.class);
        }

        private static boolean isInterface(Class<?> cls, Class<?> intfc) {
            try {
                Class<?>[] intfcs = cls.getInterfaces();
                for (int i = 0; i < intfcs.length; ++i) {
                    if (intfcs[i] != intfc) continue;
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
    }

    private static class WaitForRunningClient
    extends DelayedRunClient {
        WaitForRunningClient(SimpleTimer2 pool, RouterContext enclosingContext, String className, String clientName, String[] args) {
            super(pool, enclosingContext, className, clientName, args, null, null);
        }

        @Override
        public void timeReached() {
            if (!this._ctx.router().isRunning()) {
                this.reschedule(1000L);
                return;
            }
            super.timeReached();
        }
    }

    public static class DelayedRunClient
    extends SimpleTimer2.TimedEvent {
        protected final RouterContext _ctx;
        private final String _className;
        private final String _clientName;
        private final String[] _args;
        private final Log _log;
        private final ThreadGroup _threadGroup;
        private final ClassLoader _cl;

        public DelayedRunClient(SimpleTimer2 pool, RouterContext enclosingContext, String className, String clientName, String[] args) {
            this(pool, enclosingContext, className, clientName, args, null, null);
        }

        public DelayedRunClient(SimpleTimer2 pool, RouterContext enclosingContext, String className, String clientName, String[] args, ThreadGroup threadGroup, ClassLoader cl) {
            super(pool);
            this._ctx = enclosingContext;
            this._className = className;
            this._clientName = clientName;
            this._args = args;
            this._log = enclosingContext.logManager().getLog(LoadClientAppsJob.class);
            this._threadGroup = threadGroup;
            this._cl = cl;
        }

        @Override
        public void timeReached() {
            LoadClientAppsJob.runClient(this._className, this._clientName, this._args, this._ctx, this._log, this._threadGroup, this._cl);
        }
    }
}

