/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.MessageSelector;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

class StoreMessageSelector
implements MessageSelector {
    private final Log _log;
    private final Hash _peer;
    private final long _storeJobId;
    private final long _waitingForId;
    private final long _expiration;
    private volatile boolean _found;

    public StoreMessageSelector(RouterContext ctx, long storeJobId, RouterInfo peer, long waitingForId, long expiration) {
        this._log = ctx.logManager().getLog(StoreMessageSelector.class);
        this._peer = peer.getIdentity().getHash();
        this._storeJobId = storeJobId;
        this._waitingForId = waitingForId;
        this._expiration = expiration;
    }

    @Override
    public boolean continueMatching() {
        return !this._found;
    }

    @Override
    public long getExpiration() {
        return this._expiration;
    }

    @Override
    public boolean isMatch(I2NPMessage message) {
        if (message.getType() == 10) {
            DeliveryStatusMessage msg = (DeliveryStatusMessage)message;
            if (msg.getMessageId() == this._waitingForId) {
                if (this._log.shouldInfo()) {
                    this._log.info(this._storeJobId + ": Found match for the key we're waiting for: " + this._waitingForId);
                }
                this._found = true;
                return true;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuilder rv = new StringBuilder(128);
        rv.append("Waiting for netDb confirm from ").append(this._peer).append(", found? ");
        rv.append(this._found).append(" waiting for ").append(this._waitingForId);
        return rv.toString();
    }
}

