/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Collection;
import java.util.Date;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.LeaseSet;
import net.i2p.data.LeaseSet2;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.FastI2NPMessageImpl;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.message.SendMessageDirectJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.UnsupportedCryptoException;
import net.i2p.util.Log;

class HandleFloodfillDatabaseStoreMessageJob
extends JobImpl {
    private final Log _log;
    private final DatabaseStoreMessage _message;
    private final RouterIdentity _from;
    private Hash _fromHash;
    private final FloodfillNetworkDatabaseFacade _facade;
    private static final int REPLY_TIMEOUT = 60000;
    private static final int MESSAGE_PRIORITY = 300;

    public HandleFloodfillDatabaseStoreMessageJob(RouterContext ctx, DatabaseStoreMessage receivedMessage, RouterIdentity from, Hash fromHash, FloodfillNetworkDatabaseFacade facade) {
        super(ctx);
        this._log = ctx.logManager().getLog(this.getClass());
        this._message = receivedMessage;
        this._from = from;
        this._fromHash = fromHash;
        this._facade = facade;
    }

    @Override
    public void runJob() {
        DatabaseEntry entry;
        Hash key;
        boolean wasNew;
        boolean dontBlamePeer;
        String invalidMessage;
        long recvBegin;
        block40: {
            recvBegin = System.currentTimeMillis();
            invalidMessage = null;
            dontBlamePeer = false;
            wasNew = false;
            RouterInfo prevNetDb = null;
            key = this._message.getKey();
            entry = this._message.getEntry();
            int type = entry.getType();
            if (DatabaseEntry.isLeaseSet(type)) {
                this.getContext().statManager().addRateData("netDb.storeLeaseSetHandled", 1L);
                if (this._log.shouldLog(20)) {
                    this._log.info("Handling dbStore of leaseset " + this._message);
                }
                try {
                    LeaseSet match;
                    if (this.getContext().clientManager().isLocal(key)) {
                        dontBlamePeer = true;
                        throw new IllegalArgumentException("Peer attempted to store local leaseSet: " + key.toBase64().substring(0, 4));
                    }
                    LeaseSet ls = (LeaseSet)entry;
                    if (!ls.getReceivedAsReply()) {
                        ls.setReceivedAsPublished(true);
                    }
                    if ((match = this.getContext().netDb().store(key, ls)) == null) {
                        wasNew = true;
                        break block40;
                    }
                    if (match.getEarliestLeaseDate() < ls.getEarliestLeaseDate()) {
                        wasNew = true;
                        if (match.getReceivedAsPublished()) {
                            ls.setReceivedAsPublished(true);
                        }
                        break block40;
                    }
                    if (type != 1 && match.getType() != 1) {
                        LeaseSet2 ls2 = (LeaseSet2)ls;
                        LeaseSet2 match2 = (LeaseSet2)match;
                        if (match2.getPublished() < ls2.getPublished()) {
                            wasNew = true;
                            if (match.getReceivedAsPublished()) {
                                ls.setReceivedAsPublished(true);
                            }
                        } else {
                            wasNew = false;
                        }
                        break block40;
                    }
                    wasNew = false;
                }
                catch (UnsupportedCryptoException uce) {
                    invalidMessage = uce.getMessage();
                    dontBlamePeer = true;
                }
                catch (IllegalArgumentException iae) {
                    invalidMessage = iae.getMessage();
                }
            } else if (type == 0) {
                RouterInfo ri = (RouterInfo)entry;
                this.getContext().statManager().addRateData("netDb.storeRouterInfoHandled", 1L);
                if (this._log.shouldLog(20)) {
                    this._log.info("Handling dbStore of router " + key + " with publishDate of " + new Date(ri.getPublished()));
                }
                try {
                    if (this.getContext().routerHash().equals(key)) {
                        dontBlamePeer = true;
                        throw new IllegalArgumentException("Peer attempted to store our RouterInfo");
                    }
                    this.getContext().profileManager().heardAbout(key);
                    prevNetDb = this.getContext().netDb().store(key, ri);
                    boolean bl = wasNew = null == prevNetDb || prevNetDb.getPublished() < ri.getPublished();
                    if (!wasNew) break block40;
                    if (prevNetDb == null) {
                        if (!this.getContext().banlist().isBanlistedForever(key) && this.getContext().blocklist().isBlocklisted(ri) && this._log.shouldLog(30)) {
                            this._log.warn("Blocklisting new peer " + key + ' ' + ri);
                        }
                    } else {
                        Collection<RouterAddress> oldAddr = prevNetDb.getAddresses();
                        Collection<RouterAddress> newAddr = ri.getAddresses();
                        if (!newAddr.equals(oldAddr) && !this.getContext().banlist().isBanlistedForever(key) && this.getContext().blocklist().isBlocklisted(ri) && this._log.shouldLog(30)) {
                            this._log.warn("New address received, Blocklisting old peer " + key + ' ' + ri);
                        }
                    }
                }
                catch (UnsupportedCryptoException uce) {
                    invalidMessage = uce.getMessage();
                    dontBlamePeer = true;
                }
                catch (IllegalArgumentException iae) {
                    invalidMessage = iae.getMessage();
                }
            } else {
                if (this._log.shouldLog(40)) {
                    this._log.error("Invalid DatabaseStoreMessage data type - " + type + ": " + this._message);
                }
                return;
            }
        }
        long recvEnd = System.currentTimeMillis();
        this.getContext().statManager().addRateData("netDb.storeRecvTime", recvEnd - recvBegin);
        if (this._message.getReplyToken() > 0L) {
            this.sendAck(key);
        }
        long ackEnd = System.currentTimeMillis();
        if (this._from != null) {
            this._fromHash = this._from.getHash();
        }
        if (this._fromHash != null) {
            if (invalidMessage == null || dontBlamePeer) {
                this.getContext().profileManager().dbStoreReceived(this._fromHash, wasNew);
                this.getContext().statManager().addRateData("netDb.storeHandled", ackEnd - recvEnd);
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Peer " + this._fromHash.toBase64() + " sent bad data: " + invalidMessage);
            }
        } else if (invalidMessage != null && !dontBlamePeer && this._log.shouldLog(30)) {
            this._log.warn("Unknown peer sent bad data: " + invalidMessage);
        }
        if (invalidMessage == null && this.getContext().netDb().floodfillEnabled() && this._message.getReplyToken() > 0L) {
            if (wasNew) {
                if (this._facade.shouldThrottleFlood(key)) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Too many recent stores, not flooding key: " + key);
                    }
                    this.getContext().statManager().addRateData("netDb.floodThrottled", 1L);
                    return;
                }
                long floodBegin = System.currentTimeMillis();
                this._facade.flood(entry);
                long floodEnd = System.currentTimeMillis();
                this.getContext().statManager().addRateData("netDb.storeFloodNew", floodEnd - floodBegin, 60000L);
            } else {
                this.getContext().statManager().addRateData("netDb.storeFloodOld", 1L);
            }
        }
    }

    private void sendAck(Hash storedKey) {
        LeaseSet ls;
        int count;
        DatabaseEntry entry;
        int type;
        DatabaseStoreMessage msg2;
        DeliveryStatusMessage msg = new DeliveryStatusMessage(this.getContext());
        msg.setMessageId(this._message.getReplyToken());
        msg.setArrival(this.getContext().clock().now() - (long)this.getContext().random().nextInt(3000));
        TunnelId replyTunnel = this._message.getReplyTunnel();
        if (this.getContext().netDb().floodfillEnabled() || storedKey.equals(this.getContext().routerHash())) {
            msg2 = null;
        } else {
            msg2 = new DatabaseStoreMessage(this.getContext());
            RouterInfo me = this.getContext().router().getRouterInfo();
            msg2.setEntry(me);
            if (this._log.shouldWarn()) {
                this._log.warn("Got a store w/ reply token, but we aren't ff: from: " + this._from + " fromHash: " + this._fromHash + " msg: " + this._message, new Exception());
            }
        }
        Hash toPeer = this._message.getReplyGateway();
        boolean toUs = this.getContext().routerHash().equals(toPeer);
        if (toUs && replyTunnel != null) {
            TunnelGatewayMessage tgm = new TunnelGatewayMessage(this.getContext());
            tgm.setMessage(msg);
            tgm.setTunnelId(replyTunnel);
            tgm.setMessageExpiration(msg.getMessageExpiration());
            this.getContext().tunnelDispatcher().dispatch(tgm);
            if (msg2 != null) {
                TunnelGatewayMessage tgm2 = new TunnelGatewayMessage(this.getContext());
                tgm2.setMessage(msg2);
                tgm2.setTunnelId(replyTunnel);
                tgm2.setMessageExpiration(msg.getMessageExpiration());
                this.getContext().tunnelDispatcher().dispatch(tgm2);
            }
            return;
        }
        if (toUs) {
            SendMessageDirectJob send = new SendMessageDirectJob(this.getContext(), msg, toPeer, 60000, 300);
            send.runJob();
            if (msg2 != null) {
                SendMessageDirectJob send2 = new SendMessageDirectJob(this.getContext(), msg2, toPeer, 60000, 300);
                send2.runJob();
            }
            return;
        }
        boolean isEstab = this.getContext().commSystem().isEstablished(toPeer);
        if (!(isEstab || replyTunnel == null || (type = (entry = this._message.getEntry()).getType()) != 1 && type != 3 || (count = (ls = (LeaseSet)entry).getLeaseCount()) <= 1)) {
            Lease lease;
            int i;
            boolean found = false;
            for (i = 0; i < count; ++i) {
                lease = ls.getLease(i);
                if (!lease.getGateway().equals(toPeer) || !lease.getTunnelId().equals(replyTunnel)) continue;
                found = true;
                break;
            }
            if (found) {
                for (i = 0; i < count; ++i) {
                    lease = ls.getLease(i);
                    Hash gw = lease.getGateway();
                    if (gw.equals(toPeer) || lease.isExpired() || !this.getContext().commSystem().isEstablished(gw)) continue;
                    toPeer = gw;
                    replyTunnel = lease.getTunnelId();
                    isEstab = true;
                    break;
                }
                if (this._log.shouldWarn()) {
                    if (isEstab) {
                        this._log.warn("Switched to alt connected peer " + toPeer + " in LS with " + count + " leases");
                    } else {
                        this._log.warn("Alt connected peer not found in LS with " + count + " leases");
                    }
                }
            } else if (this._log.shouldWarn()) {
                this._log.warn("Reply gw not found in LS with " + count + " leases");
            }
        }
        if (isEstab) {
            FastI2NPMessageImpl out1 = msg;
            FastI2NPMessageImpl out2 = msg2;
            if (replyTunnel != null) {
                TunnelGatewayMessage tgm = new TunnelGatewayMessage(this.getContext());
                tgm.setMessage(msg);
                tgm.setTunnelId(replyTunnel);
                tgm.setMessageExpiration(msg.getMessageExpiration());
                out1 = tgm;
                if (out2 != null) {
                    TunnelGatewayMessage tgm2 = new TunnelGatewayMessage(this.getContext());
                    tgm2.setMessage(msg2);
                    tgm2.setTunnelId(replyTunnel);
                    tgm2.setMessageExpiration(msg.getMessageExpiration());
                    out2 = tgm2;
                }
            }
            SendMessageDirectJob send = new SendMessageDirectJob(this.getContext(), out1, toPeer, 60000, 300);
            send.runJob();
            if (msg2 != null) {
                SendMessageDirectJob send2 = new SendMessageDirectJob(this.getContext(), out2, toPeer, 60000, 300);
                send2.runJob();
            }
            return;
        }
        TunnelInfo outTunnel = this.getContext().tunnelManager().selectOutboundExploratoryTunnel(toPeer);
        if (outTunnel == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No outbound tunnel could be found");
            }
            return;
        }
        this.getContext().tunnelDispatcher().dispatchOutbound(msg, outTunnel.getSendTunnelId(0), replyTunnel, toPeer);
        if (msg2 != null) {
            this.getContext().tunnelDispatcher().dispatchOutbound(msg2, outTunnel.getSendTunnelId(0), replyTunnel, toPeer);
        }
    }

    @Override
    public String getName() {
        return "Handle Database Store Message";
    }

    @Override
    public void dropped() {
        this.getContext().messageHistory().messageProcessingError(this._message.getUniqueId(), this._message.getClass().getName(), "Dropped due to overload");
    }
}

