/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.i2p.client.SendMessageOptions;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.crypto.TagSetHandle;
import net.i2p.data.Certificate;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.LeaseSet;
import net.i2p.data.Payload;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2np.DataMessage;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.ClientMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.LeaseSetKeys;
import net.i2p.router.MessageSelector;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.crypto.ratchet.ReplyCallback;
import net.i2p.router.message.GarlicMessageBuilder;
import net.i2p.router.message.OutboundCache;
import net.i2p.router.message.OutboundClientMessageJobHelper;
import net.i2p.router.message.PayloadGarlicConfig;
import net.i2p.util.Log;

public class OutboundClientMessageOneShotJob
extends JobImpl {
    private final Log _log;
    private final OutboundCache _cache;
    private final long _overallExpiration;
    private final ClientMessage _clientMessage;
    private final MessageId _clientMessageId;
    private final int _clientMessageSize;
    private final Destination _from;
    private final Destination _to;
    private final String _toString;
    private LeaseSet _leaseSet;
    private Lease _lease;
    private PublicKey _encryptionKey;
    private final long _start;
    private Result _finished = Result.NONE;
    private long _leaseSetLookupBegin;
    private TunnelInfo _outTunnel;
    private TunnelInfo _inTunnel;
    private boolean _wantACK;
    private final OutboundCache.HashPair _hashPair;
    public static final String OVERALL_TIMEOUT_MS_PARAM = "clientMessageTimeout";
    private static final long OVERALL_TIMEOUT_MS_DEFAULT = 60000L;
    private static final long OVERALL_TIMEOUT_MS_MIN = 8000L;
    private static final long OVERALL_TIMEOUT_MS_MAX = 90000L;
    private static final long LS_LOOKUP_TIMEOUT = 15000L;
    private static final long OVERALL_TIMEOUT_NOLS_MIN = 23000L;
    private static final long REPLY_TIMEOUT_MS_MIN = 55000L;
    public static final String BUNDLE_REPLY_LEASESET = "shouldBundleReplyInfo";
    private static final int REPLY_REQUEST_INTERVAL = 60000;

    public OutboundClientMessageOneShotJob(RouterContext ctx, OutboundCache cache, ClientMessage msg) {
        super(ctx);
        this._start = ctx.clock().now();
        this._cache = cache;
        this._log = ctx.logManager().getLog(OutboundClientMessageOneShotJob.class);
        long timeoutMs = 60000L;
        this._clientMessage = msg;
        this._clientMessageId = msg.getMessageId();
        this._clientMessageSize = msg.getPayload().getSize();
        this._from = msg.getFromDestination();
        this._to = msg.getDestination();
        Hash toHash = this._to.calculateHash();
        this._hashPair = new OutboundCache.HashPair(this._from.calculateHash(), toHash);
        this._toString = toHash.toBase64().substring(0, 4);
        this._leaseSet = ctx.netDb().lookupLeaseSetLocally(toHash);
        long overallExpiration = msg.getExpiration();
        if (overallExpiration > 0L) {
            if (overallExpiration < 86400000L) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Client bug - interval instead of timestamp " + overallExpiration);
                }
                overallExpiration += this._start;
            }
            if (overallExpiration > this._start) {
                long minTimeout = this._leaseSet != null ? 8000L : 23000L;
                overallExpiration = Math.max(overallExpiration, this._start + minTimeout);
                overallExpiration = Math.min(overallExpiration, this._start + 90000L);
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getJobId() + ": Message Expiration (ms): " + (overallExpiration - this._start));
                }
            } else if (this._log.shouldLog(30)) {
                this._log.warn(this.getJobId() + ": Expired before we got to it");
            }
        } else {
            String param = msg.getSenderConfig().getOptions().getProperty(OVERALL_TIMEOUT_MS_PARAM);
            if (param == null) {
                param = ctx.router().getConfigSetting(OVERALL_TIMEOUT_MS_PARAM);
            }
            if (param != null) {
                try {
                    timeoutMs = Long.parseLong(param);
                }
                catch (NumberFormatException nfe) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Invalid client message timeout specified [" + param + "], defaulting to " + 60000L, nfe);
                    }
                    timeoutMs = 60000L;
                }
            }
            overallExpiration = timeoutMs + this._start;
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getJobId() + " Default Expiration (ms): " + timeoutMs);
            }
        }
        this._overallExpiration = overallExpiration;
    }

    public static void init(RouterContext ctx) {
        ctx.statManager().createFrequencyStat("client.sendMessageFailFrequency", "How often does a client fail to send a message?", "ClientMessages", new long[]{60000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.sendMessageSize", "How large are messages sent by the client?", "ClientMessages", new long[]{60000L, 3600000L, 86400000L});
        ctx.statManager().createRequiredRateStat("client.sendAckTime", "Message round trip time (ms)", "ClientMessages", new long[]{60000L, 300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.timeoutCongestionTunnel", "How lagged our tunnels are when a send times out?", "ClientMessages", new long[]{60000L, 300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.timeoutCongestionMessage", "How fast we process messages locally when a send times out?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.timeoutCongestionInbound", "How much faster we are receiving data than our average bps when a send times out?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.leaseSetFoundRemoteTime", "How long we tried to look for a remote leaseSet (when we succeeded)?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.leaseSetFailedRemoteTime", "How long we tried to look for a remote leaseSet (when we failed)?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.dispatchPrepareTime", "How long until we've queued up the dispatch job (since we started)?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.dispatchTime", "How long until we've dispatched the message (since we started)?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.dispatchSendTime", "How long the actual dispatching takes?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.dispatchNoTunnels", "How long after start do we run out of tunnels to send/receive with?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.dispatchNoACK", "Repeated message sends to a peer (no ack required)", "ClientMessages", new long[]{60000L, 300000L, 3600000L});
        ctx.statManager().createRateStat("crypto.garlic.decryptFail", "How often garlic messages are undecryptable", "Encryption", new long[]{300000L, 3600000L, 86400000L});
    }

    @Override
    public String getName() {
        return "Outbound client message";
    }

    @Override
    public void runJob() {
        long now = this.getContext().clock().now();
        if (now >= this._overallExpiration) {
            this.dieFatal(14);
            return;
        }
        if (this._leaseSet != null && this._leaseSet.getType() == 7) {
            this.dieFatal(19);
            return;
        }
        SendJob success = new SendJob(this.getContext());
        if (this._leaseSet != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getJobId() + ": Send outbound client message - leaseSet found locally for " + this._toString);
            }
            if (!this._leaseSet.isCurrent(15000L)) {
                if (this._log.shouldWarn()) {
                    long exp = now - this._leaseSet.getLatestLeaseDate();
                    this._log.warn(this.getJobId() + ": leaseSet expired " + DataHelper.formatDuration(exp) + " ago, firing search: " + this._leaseSet.getHash().toBase32());
                }
                this.getContext().netDb().lookupLeaseSetRemotely(this._leaseSet.getHash(), this._from.calculateHash());
            }
            success.runJob();
        } else {
            this._leaseSetLookupBegin = this.getContext().clock().now();
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getJobId() + ": Send outbound client message - sending off leaseSet lookup job for " + this._toString);
            }
            LookupLeaseSetFailedJob failed = new LookupLeaseSetFailedJob(this.getContext());
            Hash key = this._to.calculateHash();
            this.getContext().netDb().lookupLeaseSet(key, success, failed, 15000L, this._from.calculateHash());
        }
    }

    private LeaseSet getReplyLeaseSet(boolean force) {
        LeaseSet newLS = this.getContext().netDb().lookupLeaseSetLocally(this._from.calculateHash());
        if (newLS == null) {
            return null;
        }
        if (!force) {
            LeaseSet ls = this._cache.leaseSetCache.get(this._hashPair);
            if (ls != null) {
                if (ls.getDate() >= newLS.getDate()) {
                    if (this._log.shouldLog(20)) {
                        this._log.info(this.getJobId() + ": LS already acked - NOT sending reply LS to " + this._toString);
                    }
                    return null;
                }
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getJobId() + ": Expired from cache - sending reply LS to " + this._toString);
                }
            } else if (this._log.shouldInfo()) {
                this._log.info(this.getJobId() + ": Not acked - sending reply LS to " + this._toString);
            }
        }
        return newLS;
    }

    private int getNextLease() {
        Lease lease;
        int i;
        int lsType;
        if (this._leaseSet == null) {
            this._leaseSet = this.getContext().netDb().lookupLeaseSetLocally(this._to.calculateHash());
            if (this._leaseSet == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn(this.getJobId() + ": Lookup locally didn't find the leaseSet for " + this._toString);
                }
                return 21;
            }
        }
        if ((lsType = this._leaseSet.getType()) != 1 && lsType != 3) {
            return 19;
        }
        LeaseSetKeys ourKeys = this.getContext().keyManager().getKeys(this._from);
        Set<EncType> supported = ourKeys != null ? ourKeys.getSupportedEncryption() : LeaseSetKeys.SET_ELG;
        this._encryptionKey = this._leaseSet.getEncryptionKey(supported);
        if (this._encryptionKey == null) {
            if (this._leaseSet.getEncryptionKey() != null) {
                return 17;
            }
            return 19;
        }
        this._lease = this._cache.leaseCache.get(this._hashPair);
        if (this._lease != null) {
            if (!this._lease.isExpired(15000L)) {
                for (int i2 = 0; i2 < this._leaseSet.getLeaseCount(); ++i2) {
                    Lease lease2 = this._leaseSet.getLease(i2);
                    if (!this._lease.getTunnelId().equals(lease2.getTunnelId()) || !this._lease.getGateway().equals(lease2.getGateway())) continue;
                    if (this._log.shouldLog(20)) {
                        this._log.info(this.getJobId() + ": Found in cache - lease for " + this._toString);
                    }
                    return 0;
                }
            }
            this._cache.leaseCache.remove(this._hashPair, this._lease);
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Expired from cache - lease for " + this._toString);
            }
        }
        ArrayList<Lease> leases = new ArrayList<Lease>(this._leaseSet.getLeaseCount());
        for (i = 0; i < this._leaseSet.getLeaseCount(); ++i) {
            lease = this._leaseSet.getLease(i);
            if (lease.isExpired(15000L)) continue;
            leases.add(lease);
        }
        if (leases.isEmpty()) {
            for (i = 0; i < this._leaseSet.getLeaseCount(); ++i) {
                lease = this._leaseSet.getLease(i);
                if (lease.isExpired(60000L)) continue;
                leases.add(lease);
            }
        }
        if (leases.isEmpty()) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": No leases found from: " + this._leaseSet);
            }
            return 19;
        }
        if (leases.size() > 1) {
            Collections.shuffle(leases, this.getContext().random());
        }
        for (i = 0; i < leases.size(); ++i) {
            Lease l = (Lease)leases.get(i);
            RouterInfo ri = this.getContext().netDb().lookupRouterInfoLocally(l.getGateway());
            if (ri == null || ri.getCapabilities().indexOf(85) < 0) {
                this._lease = l;
                break;
            }
            if (!this._log.shouldLog(30)) continue;
            this._log.warn(this.getJobId() + ": Skipping unreachable gateway " + l.getGateway() + " for " + this._toString);
        }
        if (this._lease == null) {
            this._lease = (Lease)leases.get(0);
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getJobId() + ": All leases are unreachable for " + this._toString);
            }
        }
        this._cache.leaseCache.put(this._hashPair, this._lease);
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Added to cache - lease for " + this._toString);
        }
        this._wantACK = true;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send() {
        ReplySelector selector;
        SendSuccessJob onReply;
        SendTimeoutJob onFail;
        ECIESReplyCallback callback;
        SendTimeoutJob eciesTimeout;
        long token;
        LeaseSet replyLeaseSet;
        boolean allowLeaseBundle;
        OutboundClientMessageOneShotJob outboundClientMessageOneShotJob = this;
        synchronized (outboundClientMessageOneShotJob) {
            if (this._finished != Result.NONE) {
                if (this._log.shouldLog(30)) {
                    this._log.warn(this.getJobId() + ": SEND-AFTER-" + (Object)((Object)this._finished));
                }
                return;
            }
        }
        long now = this.getContext().clock().now();
        if (now >= this._overallExpiration) {
            this.dieFatal(14);
            return;
        }
        this._outTunnel = this.selectOutboundTunnel(this._to);
        if (this._outTunnel == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getJobId() + ": Could not find any outbound tunnels to send the payload through... this might take a while");
            }
            this.getContext().statManager().addRateData("client.dispatchNoTunnels", now - this._start);
            this.dieFatal(16);
            return;
        }
        Long lastReplyRequestSent = this._cache.lastReplyRequestCache.get(this._hashPair);
        boolean shouldRequestReply = lastReplyRequestSent == null || lastReplyRequestSent < now - 60000L;
        int sendFlags = this._clientMessage.getFlags();
        int tagsRequired = SendMessageOptions.getTagThreshold(sendFlags);
        boolean wantACK = this._wantACK || shouldRequestReply || GarlicMessageBuilder.needsTags(this.getContext(), this._encryptionKey, this._from.calculateHash(), tagsRequired);
        String allow = this._clientMessage.getSenderConfig().getOptions().getProperty(BUNDLE_REPLY_LEASESET);
        boolean bl = allowLeaseBundle = SendMessageOptions.getSendLeaseSet(sendFlags) && (allow == null || Boolean.parseBoolean(allow));
        if (allowLeaseBundle) {
            replyLeaseSet = this.getReplyLeaseSet(false);
            if (replyLeaseSet != null) {
                wantACK = true;
            }
        } else {
            replyLeaseSet = null;
        }
        if (wantACK) {
            this._cache.lastReplyRequestCache.put(this._hashPair, now);
            token = this.getContext().random().nextLong(0xFFFFFFFFL);
            this._inTunnel = this.selectInboundTunnel();
        } else {
            token = -1L;
        }
        PayloadGarlicConfig clove = this.buildClove();
        if (clove == null) {
            this.dieFatal(17);
            return;
        }
        SessionKey sessKey = new SessionKey();
        HashSet<SessionTag> tags = new HashSet<SessionTag>();
        int tagsToSend = SendMessageOptions.getTagsToSend(sendFlags);
        if (wantACK && this._encryptionKey.getType() == EncType.ECIES_X25519) {
            eciesTimeout = new SendTimeoutJob(null, null);
            callback = new ECIESReplyCallback(replyLeaseSet, eciesTimeout);
        } else {
            eciesTimeout = null;
            callback = null;
        }
        GarlicMessage msg = OutboundClientMessageJobHelper.createGarlicMessage(this.getContext(), token, this._overallExpiration, this._encryptionKey, clove, this._from.calculateHash(), this._to, this._inTunnel, tagsToSend, tagsRequired, sessKey, tags, wantACK, replyLeaseSet, callback);
        if (msg == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getJobId() + ": Unable to create the garlic message (no tunnels left or too lagged) to " + this._toString);
            }
            this.getContext().statManager().addRateData("client.dispatchNoTunnels", now - this._start);
            this.dieFatal(16);
            return;
        }
        if (wantACK && this._encryptionKey.getType() == EncType.ELGAMAL_2048) {
            SessionKeyManager skm;
            TagSetHandle tsh = null;
            if (!tags.isEmpty() && (skm = this.getContext().clientManager().getClientSessionKeyManager(this._from.calculateHash())) != null) {
                tsh = skm.tagsDelivered(this._encryptionKey, sessKey, tags);
            }
            onFail = new SendTimeoutJob(sessKey, tsh);
            onReply = new SendSuccessJob(sessKey, tsh, replyLeaseSet, onFail);
            long expiration = Math.max(this._overallExpiration, this._start + 55000L);
            selector = new ReplySelector(token, expiration);
        } else if (wantACK && this._encryptionKey.getType() == EncType.ECIES_X25519) {
            onReply = null;
            onFail = eciesTimeout;
            selector = null;
        } else {
            onReply = null;
            onFail = null;
            selector = null;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": Sending msg out " + this._outTunnel.getSendTunnelId(0) + " to " + this._toString + " at " + this._lease.getTunnelId() + " on " + this._lease.getGateway());
        }
        DispatchJob dispatchJob = new DispatchJob(msg, selector, onReply, onFail);
        dispatchJob.runJob();
        this.getContext().statManager().addRateData("client.dispatchPrepareTime", now - this._start);
        if (!wantACK) {
            this.getContext().statManager().addRateData("client.dispatchNoACK", 1L);
        }
    }

    private void clearCaches() {
        this._cache.clearCaches(this._hashPair, this._lease, this._inTunnel, this._outTunnel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TunnelInfo selectOutboundTunnel(Destination to) {
        TunnelInfo tunnel;
        Map<OutboundCache.HashPair, TunnelInfo> map = this._cache.tunnelCache;
        synchronized (map) {
            tunnel = this._cache.backloggedTunnelCache.get(this._hashPair);
            if (tunnel != null) {
                if (this.getContext().tunnelManager().isValidTunnel(this._from.calculateHash(), tunnel)) {
                    if (!this.getContext().commSystem().isBacklogged(tunnel.getPeer(1))) {
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Switching back to tunnel " + tunnel + " for " + this._toString);
                        }
                        this._cache.backloggedTunnelCache.remove(this._hashPair);
                        this._cache.tunnelCache.put(this._hashPair, tunnel);
                        this._wantACK = true;
                        return tunnel;
                    }
                } else {
                    this._cache.backloggedTunnelCache.remove(this._hashPair);
                }
            }
            if ((tunnel = this._cache.tunnelCache.get(this._hashPair)) != null) {
                if (this.getContext().tunnelManager().isValidTunnel(this._from.calculateHash(), tunnel)) {
                    if (tunnel.getLength() <= 1 || !this.getContext().commSystem().isBacklogged(tunnel.getPeer(1))) {
                        return tunnel;
                    }
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Switching from backlogged " + tunnel + " for " + this._toString);
                    }
                    this._cache.backloggedTunnelCache.put(this._hashPair, tunnel);
                }
                this._cache.tunnelCache.remove(this._hashPair);
            }
            if ((tunnel = this.selectOutboundTunnel()) != null) {
                this._cache.tunnelCache.put(this._hashPair, tunnel);
            }
            this._wantACK = true;
        }
        return tunnel;
    }

    private TunnelInfo selectOutboundTunnel() {
        return this.getContext().tunnelManager().selectOutboundTunnel(this._from.calculateHash());
    }

    private TunnelInfo selectInboundTunnel() {
        return this.getContext().tunnelManager().selectInboundTunnel(this._from.calculateHash(), this._to.calculateHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dieFatal(int status) {
        OutboundClientMessageOneShotJob outboundClientMessageOneShotJob = this;
        synchronized (outboundClientMessageOneShotJob) {
            if (this._finished != Result.NONE) {
                if (this._log.shouldLog(30)) {
                    this._log.warn(this.getJobId() + ": FAIL-AFTER-" + (Object)((Object)this._finished));
                }
                return;
            }
            this._finished = Result.FAIL;
        }
        long sendTime = this.getContext().clock().now() - this._start;
        if (this._log.shouldLog(30)) {
            this._log.warn(this.getJobId() + ": Send failed (cause: " + status + ") " + this._clientMessageId + " to " + this._toString + " out " + this._outTunnel + " in " + this._lease + " ack " + this._inTunnel + " after " + sendTime + "ms");
        }
        long messageDelay = this.getContext().throttle().getMessageDelay();
        long tunnelLag = this.getContext().throttle().getTunnelLag();
        long inboundDelta = (long)this.getContext().throttle().getInboundRateDelta();
        this.getContext().statManager().addRateData("client.timeoutCongestionTunnel", tunnelLag, 1L);
        this.getContext().statManager().addRateData("client.timeoutCongestionMessage", messageDelay, 1L);
        this.getContext().statManager().addRateData("client.timeoutCongestionInbound", inboundDelta, 1L);
        this.clearCaches();
        this.getContext().messageHistory().sendPayloadMessage(this._clientMessageId.getMessageId(), false, sendTime);
        this.getContext().clientManager().messageDeliveryStatusUpdate(this._from, this._clientMessageId, this._clientMessage.getMessageNonce(), status);
        this.getContext().statManager().updateFrequency("client.sendMessageFailFrequency");
    }

    private PayloadGarlicConfig buildClove() {
        DeliveryInstructions instructions = new DeliveryInstructions();
        instructions.setDeliveryMode(1);
        instructions.setDestination(this._to.calculateHash());
        DataMessage msg = new DataMessage(this.getContext());
        Payload p = this._clientMessage.getPayload();
        if (p == null) {
            return null;
        }
        byte[] d = p.getEncryptedData();
        if (d == null) {
            return null;
        }
        msg.setData(d);
        long expires = 60000L + this.getContext().clock().now();
        msg.setMessageExpiration(expires);
        PayloadGarlicConfig clove = new PayloadGarlicConfig(Certificate.NULL_CERT, this.getContext().random().nextLong(0xFFFFFFFFL), expires, instructions, msg);
        return clove;
    }

    private class SendTimeoutJob
    extends JobImpl {
        private final SessionKey _key;
        private final TagSetHandle _tags;

        public SendTimeoutJob(SessionKey key, TagSetHandle tags) {
            super(OutboundClientMessageOneShotJob.this.getContext());
            this._key = key;
            this._tags = tags;
        }

        @Override
        public String getName() {
            return "Outbound client message send timeout";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() {
            Result old;
            OutboundClientMessageOneShotJob outboundClientMessageOneShotJob = OutboundClientMessageOneShotJob.this;
            synchronized (outboundClientMessageOneShotJob) {
                SessionKeyManager skm;
                old = OutboundClientMessageOneShotJob.this._finished;
                if (old == Result.SUCCESS) {
                    if (OutboundClientMessageOneShotJob.this._log.shouldLog(20)) {
                        OutboundClientMessageOneShotJob.this._log.info(OutboundClientMessageOneShotJob.this.getJobId() + ": TIMEOUT-AFTER-SUCCESS");
                    }
                    return;
                }
                if (this._key != null && this._tags != null && OutboundClientMessageOneShotJob.this._leaseSet != null && (skm = this.getContext().clientManager().getClientSessionKeyManager(OutboundClientMessageOneShotJob.this._from.calculateHash())) != null) {
                    skm.failTags(OutboundClientMessageOneShotJob.this._encryptionKey, this._key, this._tags);
                }
            }
            if (old == Result.NONE) {
                OutboundClientMessageOneShotJob.this.dieFatal(3);
            }
        }
    }

    private class ECIESReplyCallback
    extends SendSuccessJob
    implements ReplyCallback {
        public ECIESReplyCallback(LeaseSet ls, SendTimeoutJob timeout) {
            super(null, null, ls, timeout);
        }

        @Override
        public long getExpiration() {
            return Math.max(OutboundClientMessageOneShotJob.this._overallExpiration, OutboundClientMessageOneShotJob.this._start + 55000L);
        }

        @Override
        public void onReply() {
            this.runJob();
        }
    }

    private class SendSuccessJob
    extends JobImpl
    implements ReplyJob {
        private final SessionKey _key;
        private final TagSetHandle _tags;
        private final LeaseSet _deliveredLS;
        private final SendTimeoutJob _replyTimeout;

        public SendSuccessJob(SessionKey key, TagSetHandle tags, LeaseSet ls, SendTimeoutJob timeout) {
            super(OutboundClientMessageOneShotJob.this.getContext());
            this._key = key;
            this._tags = tags;
            this._deliveredLS = ls;
            this._replyTimeout = timeout;
        }

        @Override
        public String getName() {
            return "Outbound client message send success";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() {
            int i;
            Result old;
            if (this._deliveredLS != null) {
                LeaseSet oldls = ((OutboundClientMessageOneShotJob)OutboundClientMessageOneShotJob.this)._cache.leaseSetCache.putIfAbsent(OutboundClientMessageOneShotJob.this._hashPair, this._deliveredLS);
                if (oldls != null) {
                    if (this._deliveredLS.getDate() > oldls.getDate()) {
                        ((OutboundClientMessageOneShotJob)OutboundClientMessageOneShotJob.this)._cache.leaseSetCache.put(OutboundClientMessageOneShotJob.this._hashPair, this._deliveredLS);
                        if (OutboundClientMessageOneShotJob.this._log.shouldInfo()) {
                            OutboundClientMessageOneShotJob.this._log.info(this.getJobId() + ": added to cache - got reply LS from " + OutboundClientMessageOneShotJob.this._toString);
                        }
                    }
                } else if (OutboundClientMessageOneShotJob.this._log.shouldInfo()) {
                    OutboundClientMessageOneShotJob.this._log.info(this.getJobId() + ": added to cache - got reply LS from " + OutboundClientMessageOneShotJob.this._toString);
                }
            }
            OutboundClientMessageOneShotJob outboundClientMessageOneShotJob = OutboundClientMessageOneShotJob.this;
            synchronized (outboundClientMessageOneShotJob) {
                SessionKeyManager skm;
                old = OutboundClientMessageOneShotJob.this._finished;
                if (old == Result.SUCCESS) {
                    if (OutboundClientMessageOneShotJob.this._log.shouldLog(30)) {
                        OutboundClientMessageOneShotJob.this._log.warn(OutboundClientMessageOneShotJob.this.getJobId() + ": SUCCESS-AFTER-SUCCESS");
                    }
                    return;
                }
                OutboundClientMessageOneShotJob.this._finished = Result.SUCCESS;
                if (this._key != null && this._tags != null && OutboundClientMessageOneShotJob.this._leaseSet != null && (skm = this.getContext().clientManager().getClientSessionKeyManager(OutboundClientMessageOneShotJob.this._from.calculateHash())) != null) {
                    skm.tagsAcked(OutboundClientMessageOneShotJob.this._encryptionKey, this._key, this._tags);
                }
            }
            if (this._replyTimeout != null) {
                this.getContext().jobQueue().removeJob(this._replyTimeout);
            }
            long sendTime = this.getContext().clock().now() - OutboundClientMessageOneShotJob.this._start;
            if (old == Result.FAIL) {
                if (OutboundClientMessageOneShotJob.this._log.shouldLog(30)) {
                    OutboundClientMessageOneShotJob.this._log.warn(OutboundClientMessageOneShotJob.this.getJobId() + ": SUCCESS-AFTER-TIMEOUT " + OutboundClientMessageOneShotJob.this._clientMessageId + " acked by DSM after " + sendTime + "ms");
                }
            } else if (OutboundClientMessageOneShotJob.this._log.shouldLog(20)) {
                OutboundClientMessageOneShotJob.this._log.info(OutboundClientMessageOneShotJob.this.getJobId() + ": SUCCESS " + OutboundClientMessageOneShotJob.this._clientMessageId + " acked by DSM after " + sendTime + "ms");
            }
            this.getContext().messageHistory().sendPayloadMessage(99999L, true, sendTime);
            this.getContext().clientManager().messageDeliveryStatusUpdate(OutboundClientMessageOneShotJob.this._from, OutboundClientMessageOneShotJob.this._clientMessageId, OutboundClientMessageOneShotJob.this._clientMessage.getMessageNonce(), 4);
            int size = OutboundClientMessageOneShotJob.this._clientMessageSize;
            this.getContext().statManager().addRateData("client.sendAckTime", sendTime);
            this.getContext().statManager().addRateData("client.sendMessageSize", OutboundClientMessageOneShotJob.this._clientMessageSize, sendTime);
            if (OutboundClientMessageOneShotJob.this._outTunnel != null) {
                if (OutboundClientMessageOneShotJob.this._outTunnel.getLength() > 0) {
                    size = (size + 1023) / 1024 * 1024;
                }
                for (i = 1; i < OutboundClientMessageOneShotJob.this._outTunnel.getLength(); ++i) {
                    this.getContext().profileManager().tunnelTestSucceeded(OutboundClientMessageOneShotJob.this._outTunnel.getPeer(i), sendTime);
                    this.getContext().profileManager().tunnelDataPushed(OutboundClientMessageOneShotJob.this._outTunnel.getPeer(i), sendTime, size);
                }
                OutboundClientMessageOneShotJob.this._outTunnel.incrementVerifiedBytesTransferred(size);
            }
            if (OutboundClientMessageOneShotJob.this._inTunnel != null) {
                for (i = 0; i < OutboundClientMessageOneShotJob.this._inTunnel.getLength() - 1; ++i) {
                    this.getContext().profileManager().tunnelTestSucceeded(OutboundClientMessageOneShotJob.this._inTunnel.getPeer(i), sendTime);
                }
            }
        }

        @Override
        public void setMessage(I2NPMessage msg) {
        }
    }

    private static class ReplySelector
    implements MessageSelector {
        private final long _pendingToken;
        private final long _expiration;

        public ReplySelector(long token, long expiration) {
            this._pendingToken = token;
            this._expiration = expiration;
        }

        @Override
        public boolean continueMatching() {
            return false;
        }

        @Override
        public long getExpiration() {
            return this._expiration;
        }

        @Override
        public boolean isMatch(I2NPMessage inMsg) {
            if (inMsg.getType() == 10) {
                return this._pendingToken == ((DeliveryStatusMessage)inMsg).getMessageId();
            }
            return false;
        }

        public String toString() {
            return "OCMOSJ.RS waiting for token " + this._pendingToken + " until " + new Date(this._expiration);
        }
    }

    private class DispatchJob
    extends JobImpl {
        private final GarlicMessage _msg;
        private final ReplySelector _selector;
        private final SendSuccessJob _replyFound;
        private final SendTimeoutJob _replyTimeout;

        public DispatchJob(GarlicMessage msg, ReplySelector sel, SendSuccessJob success, SendTimeoutJob timeout) {
            super(OutboundClientMessageOneShotJob.this.getContext());
            this._msg = msg;
            this._selector = sel;
            this._replyFound = success;
            this._replyTimeout = timeout;
        }

        @Override
        public String getName() {
            return "Outbound client message dispatch";
        }

        @Override
        public void runJob() {
            if (this._selector != null) {
                if (OutboundClientMessageOneShotJob.this._overallExpiration >= this._selector.getExpiration()) {
                    this.getContext().messageRegistry().registerPending(this._selector, this._replyFound, this._replyTimeout);
                    if (OutboundClientMessageOneShotJob.this._log.shouldLog(20)) {
                        OutboundClientMessageOneShotJob.this._log.info(OutboundClientMessageOneShotJob.this.getJobId() + ": Reply selector expires " + DataHelper.formatDuration(OutboundClientMessageOneShotJob.this._overallExpiration - this._selector.getExpiration()) + " before message, using selector only");
                    }
                } else {
                    this.getContext().messageRegistry().registerPending(this._selector, this._replyFound, null);
                    this._replyTimeout.getTiming().setStartAfter(OutboundClientMessageOneShotJob.this._overallExpiration);
                    this.getContext().jobQueue().addJob(this._replyTimeout);
                    if (OutboundClientMessageOneShotJob.this._log.shouldLog(20)) {
                        OutboundClientMessageOneShotJob.this._log.info(OutboundClientMessageOneShotJob.this.getJobId() + ": Reply selector expires " + DataHelper.formatDuration(this._selector.getExpiration() - OutboundClientMessageOneShotJob.this._overallExpiration) + " after message, queueing separate timeout job");
                    }
                }
            } else if (this._replyTimeout != null) {
                long expiration = Math.max(OutboundClientMessageOneShotJob.this._overallExpiration, OutboundClientMessageOneShotJob.this._start + 55000L);
                this._replyTimeout.getTiming().setStartAfter(expiration);
                this.getContext().jobQueue().addJob(this._replyTimeout);
            }
            if (OutboundClientMessageOneShotJob.this._log.shouldLog(20)) {
                OutboundClientMessageOneShotJob.this._log.info(OutboundClientMessageOneShotJob.this.getJobId() + ": Dispatching message to " + OutboundClientMessageOneShotJob.this._toString + ": " + this._msg);
            }
            long before = this.getContext().clock().now();
            this.getContext().tunnelDispatcher().dispatchOutbound(this._msg, OutboundClientMessageOneShotJob.this._outTunnel.getSendTunnelId(0), OutboundClientMessageOneShotJob.this._lease.getTunnelId(), OutboundClientMessageOneShotJob.this._lease.getGateway());
            long dispatchSendTime = this.getContext().clock().now() - before;
            this.getContext().statManager().addRateData("client.dispatchTime", this.getContext().clock().now() - OutboundClientMessageOneShotJob.this._start);
            this.getContext().statManager().addRateData("client.dispatchSendTime", dispatchSendTime);
        }
    }

    private class LookupLeaseSetFailedJob
    extends JobImpl {
        public LookupLeaseSetFailedJob(RouterContext enclosingContext) {
            super(enclosingContext);
        }

        @Override
        public String getName() {
            return "Outbound client message lease lookup failed";
        }

        @Override
        public void runJob() {
            int cause;
            if (OutboundClientMessageOneShotJob.this._leaseSetLookupBegin > 0L) {
                long lookupTime = this.getContext().clock().now() - OutboundClientMessageOneShotJob.this._leaseSetLookupBegin;
                this.getContext().statManager().addRateData("client.leaseSetFailedRemoteTime", lookupTime);
            }
            if (this.getContext().netDb().isNegativeCachedForever(OutboundClientMessageOneShotJob.this._to.calculateHash())) {
                if (OutboundClientMessageOneShotJob.this._log.shouldLog(30)) {
                    OutboundClientMessageOneShotJob.this._log.warn("Unable to send to " + OutboundClientMessageOneShotJob.this._toString + " because the sig type is unsupported");
                }
                cause = 17;
            } else {
                if (OutboundClientMessageOneShotJob.this._log.shouldLog(30)) {
                    OutboundClientMessageOneShotJob.this._log.warn("Unable to send to " + OutboundClientMessageOneShotJob.this._toString + " because we couldn't find their leaseSet");
                }
                cause = 21;
            }
            OutboundClientMessageOneShotJob.this.dieFatal(cause);
        }
    }

    private class SendJob
    extends JobImpl {
        public SendJob(RouterContext enclosingContext) {
            super(enclosingContext);
        }

        @Override
        public String getName() {
            return "Outbound client message delayed send";
        }

        @Override
        public void runJob() {
            if (OutboundClientMessageOneShotJob.this._leaseSetLookupBegin > 0L) {
                long lookupTime = this.getContext().clock().now() - OutboundClientMessageOneShotJob.this._leaseSetLookupBegin;
                this.getContext().statManager().addRateData("client.leaseSetFoundRemoteTime", lookupTime);
            }
            OutboundClientMessageOneShotJob.this._wantACK = false;
            int rc = OutboundClientMessageOneShotJob.this.getNextLease();
            if (rc == 0) {
                OutboundClientMessageOneShotJob.this.send();
            } else {
                if (OutboundClientMessageOneShotJob.this._log.shouldLog(30)) {
                    OutboundClientMessageOneShotJob.this._log.warn("Got the lease but can't send to it, failure code " + rc + " (to=" + OutboundClientMessageOneShotJob.this._toString + ")");
                }
                OutboundClientMessageOneShotJob.this.dieFatal(rc);
            }
        }
    }

    private static enum Result {
        NONE,
        FAIL,
        SUCCESS;

    }
}

