/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.db;

import com.maxmind.db.BufferHolder;
import com.maxmind.db.ClosedDatabaseException;
import com.maxmind.db.Decoder;
import com.maxmind.db.InvalidDatabaseException;
import com.maxmind.db.Metadata;
import com.maxmind.db.NoCache;
import com.maxmind.db.NodeCache;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public final class Reader
implements Closeable {
    private static final int DATA_SECTION_SEPARATOR_SIZE = 16;
    private static final byte[] METADATA_START_MARKER = new byte[]{-85, -51, -17, 77, 97, 120, 77, 105, 110, 100, 46, 99, 111, 109};
    private final int ipV4Start;
    private final Metadata metadata;
    private final AtomicReference<BufferHolder> bufferHolderReference;
    private final NodeCache cache;

    public Reader(File database) throws IOException {
        this(database, (NodeCache)NoCache.getInstance());
    }

    public Reader(File database, NodeCache cache) throws IOException {
        this(database, FileMode.MEMORY_MAPPED, cache);
    }

    public Reader(InputStream source) throws IOException {
        this(source, (NodeCache)NoCache.getInstance());
    }

    public Reader(InputStream source, NodeCache cache) throws IOException {
        this(new BufferHolder(source), "<InputStream>", cache);
    }

    public Reader(File database, FileMode fileMode) throws IOException {
        this(database, fileMode, (NodeCache)NoCache.getInstance());
    }

    public Reader(File database, FileMode fileMode, NodeCache cache) throws IOException {
        this(new BufferHolder(database, fileMode), database.getName(), cache);
    }

    private Reader(BufferHolder bufferHolder, String name, NodeCache cache) throws IOException {
        this.bufferHolderReference = new AtomicReference<BufferHolder>(bufferHolder);
        if (cache == null) {
            throw new NullPointerException("Cache cannot be null");
        }
        this.cache = cache;
        ByteBuffer buffer = bufferHolder.get();
        int start = this.findMetadataStart(buffer, name);
        Decoder metadataDecoder = new Decoder(this.cache, buffer, start);
        this.metadata = new Metadata((Map)metadataDecoder.decode(start));
        this.ipV4Start = this.findIpV4StartNode(buffer);
    }

    public Object get(InetAddress ipAddress) throws IOException {
        ByteBuffer buffer = this.getBufferHolder().get();
        int pointer = this.findAddressInTree(buffer, ipAddress);
        if (pointer == 0) {
            return null;
        }
        return this.resolveDataPointer(buffer, pointer);
    }

    private BufferHolder getBufferHolder() throws ClosedDatabaseException {
        BufferHolder bufferHolder = this.bufferHolderReference.get();
        if (bufferHolder == null) {
            throw new ClosedDatabaseException();
        }
        return bufferHolder;
    }

    private int findAddressInTree(ByteBuffer buffer, InetAddress address) throws InvalidDatabaseException {
        byte[] rawAddress = address.getAddress();
        int bitLength = rawAddress.length * 8;
        int record = this.startNode(bitLength);
        for (int i = 0; i < bitLength && record < this.metadata.getNodeCount(); ++i) {
            int b = 0xFF & rawAddress[i / 8];
            int bit = 1 & b >> 7 - i % 8;
            record = this.readNode(buffer, record, bit);
        }
        if (record == this.metadata.getNodeCount()) {
            return 0;
        }
        if (record > this.metadata.getNodeCount()) {
            return record;
        }
        throw new InvalidDatabaseException("Something bad happened");
    }

    private int startNode(int bitLength) {
        if (this.metadata.getIpVersion() == 6 && bitLength == 32) {
            return this.ipV4Start;
        }
        return 0;
    }

    private int findIpV4StartNode(ByteBuffer buffer) throws InvalidDatabaseException {
        if (this.metadata.getIpVersion() == 4) {
            return 0;
        }
        int node = 0;
        for (int i = 0; i < 96 && node < this.metadata.getNodeCount(); ++i) {
            node = this.readNode(buffer, node, 0);
        }
        return node;
    }

    private int readNode(ByteBuffer buffer, int nodeNumber, int index) throws InvalidDatabaseException {
        int baseOffset = nodeNumber * this.metadata.getNodeByteSize();
        switch (this.metadata.getRecordSize()) {
            case 24: {
                buffer.position(baseOffset + index * 3);
                return Decoder.decodeInteger(buffer, 0, 3);
            }
            case 28: {
                int middle = buffer.get(baseOffset + 3);
                middle = index == 0 ? (0xF0 & middle) >>> 4 : 0xF & middle;
                buffer.position(baseOffset + index * 4);
                return Decoder.decodeInteger(buffer, middle, 3);
            }
            case 32: {
                buffer.position(baseOffset + index * 4);
                return Decoder.decodeInteger(buffer, 0, 4);
            }
        }
        throw new InvalidDatabaseException("Unknown record size: " + this.metadata.getRecordSize());
    }

    private Object resolveDataPointer(ByteBuffer buffer, int pointer) throws IOException {
        int resolved = pointer - this.metadata.getNodeCount() + this.metadata.getSearchTreeSize();
        if (resolved >= buffer.capacity()) {
            throw new InvalidDatabaseException("The MaxMind DB file's search tree is corrupt: contains pointer larger than the database.");
        }
        Decoder decoder = new Decoder(this.cache, buffer, this.metadata.getSearchTreeSize() + 16);
        return decoder.decode(resolved);
    }

    private int findMetadataStart(ByteBuffer buffer, String databaseName) throws InvalidDatabaseException {
        int fileSize = buffer.capacity();
        block0: for (int i = 0; i < fileSize - METADATA_START_MARKER.length + 1; ++i) {
            for (int j = 0; j < METADATA_START_MARKER.length; ++j) {
                byte b = buffer.get(fileSize - i - j - 1);
                if (b != METADATA_START_MARKER[METADATA_START_MARKER.length - j - 1]) continue block0;
            }
            return fileSize - i;
        }
        throw new InvalidDatabaseException("Could not find a MaxMind DB metadata marker in this file (" + databaseName + "). Is this a valid MaxMind DB file?");
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void close() throws IOException {
        this.bufferHolderReference.set(null);
    }

    public static enum FileMode {
        MEMORY_MAPPED,
        MEMORY;

    }
}

