/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.streamr;

import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.streamr.MultiSource;
import net.i2p.i2ptunnel.udp.Sink;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

public class Subscriber
implements Sink {
    private final Set<Destination> subscriptions;
    private final MultiSource multi;

    public Subscriber(MultiSource multi) {
        this.multi = multi;
        this.subscriptions = new ConcurrentHashSet<Destination>();
    }

    @Override
    public void send(Destination dest, byte[] data) {
        if (dest == null || data.length < 1) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(this.getClass());
            if (log.shouldWarn()) {
                log.warn("bad subscription from " + dest);
            }
        } else {
            byte ctrl = data[0];
            if (ctrl == 0) {
                if (!this.subscriptions.contains(dest)) {
                    System.out.println("Add subscription: " + dest.toBase64().substring(0, 4));
                    this.subscriptions.add(dest);
                    this.multi.add(dest);
                }
            } else if (ctrl == 1) {
                System.out.println("Remove subscription: " + dest.toBase64().substring(0, 4));
                boolean removed = this.subscriptions.remove(dest);
                if (removed) {
                    this.multi.remove(dest);
                }
            } else {
                Log log = I2PAppContext.getGlobalContext().logManager().getLog(this.getClass());
                if (log.shouldWarn()) {
                    log.warn("bad subscription from " + dest);
                }
            }
        }
    }
}

