/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SEEDLESSMANAGER_H
#define SEEDLESSMANAGER_H

#include <QtGlobal>
#include <QtDebug>
#include <QByteArray>
#include <QTextStream>
#include <QStringList>
#include <QList>
#include <QMap>
#include <QTimer>
#include <QSettings>

#include "User.h"
#include "SeedlessAnnouncer.h"
#include "SeedlessSearcher.h"
#include "HttpOverStreamObject.h"


#define SEEDLESS_SERVICE_NAME "i2p-messenger"
#define SEEDLESS_SERVICE_STRUCT_VERSION "X01X"

#define SEEDLESSFALLBACK1 "eaq3jag3crgljljkczky5wa3zhuiqvcbv3m5cp62av6qgugtodmq.b32.i2p"
#define SEEDLESSFALLBACK2 "eomdwleo4rs3n4xfmeja6sbdaauqj75hlfchxkzl4jmqpgziyexa.b32.i2p"
#define SEEDLESSFALLBACK3 "nrg4ys4hjqljnh6pq7ww7pyy3v6f47i7hfs4cmxiwrb3anl6zxda.b32.i2p"
#define SEEDLESSFALLBACK4 "o5hu7phy7udffuhts6w5wn5mw3sepwe3hyvw6kthti33wa2xn5tq.b32.i2p"


#define COUNT_FOR_SEEDLESSSERVER_SEARCH 3
#define COUNT_FOR_SEEDLESSSERVER_ANNOUNCE 3
#define COUNT_FOR_SEEDLESSMESSENGER_SEARCH 3

#define MAX_FAILCOUNT 6

using namespace User;
class CSeedlessAnnouncer;
class CSeedlessSearcher;
class CCore;
class CSeedlessManager :public QObject{
  
  public: struct SeedlessServerInformation{
	QString b32Dest;
	int	failCount;  
  };
  
  public: struct SeedlessSearchStruct
  {
	QString NickName;
	int	Age;
	QString Gender;
	QString Interests;
	QString b32Dest;
	QString b64Dest;
	int	TTL;
	void operator =(const SeedlessSearchStruct& str){
	    this->NickName=str.NickName;
	    this->Age=str.Age;
	    this->Gender=str.Gender;
	    this->Interests=str.Interests;
	    this->b32Dest=str.b32Dest;
	    this->b64Dest=str.b64Dest;
	    this->TTL=str.TTL;
	} 

  };
  

	Q_OBJECT
	public:
		CSeedlessManager( CCore& Core,
				  QString FilePathToSeedlessList,
				  QString FilePathForSettings);				

		~CSeedlessManager();
		
		
		void 		doSeedlessMessangerSearch(SeedlessSearchStruct str);
		void		doStart();
		void 		printSeedlessServerList();
		QMap<QString,SeedlessServerInformation> getSeedlessServer(){return mSeedlessServerList;};
		bool		addNewUser(const SeedlessSearchStruct str);
		void		doStop();


	
	private slots:
		void slotSeedlessAnnouncerFinished   (bool t,QStringList Header,QByteArray Data,QString ID);
		void slotSeedlessSearcherFinished    (bool t,QStringList Header,QList<QByteArray> Data,QString ID);
		void slotSeedlessServerSearchFinished(bool t,QStringList Header,QList<QByteArray> Data,QString ID);
		void slotTimerForReAnncounging();

	signals:
		void DebugMessages(QString);
		void signSeedlessSearchResults(QMap<QString,CSeedlessManager::SeedlessSearchStruct>);
		void signSeedlessSearchNothingFound();
		void signSearchState(QString);

	private:
		bool ExtractInteressingInformation(QString dataStringIn, QString& Destination, QString& TTL, const QString Service);
		SeedlessSearchStruct ExtractMessengerInformation(QByteArray data,bool &OK );
		
		void doSeedlessAnnounce();
		void doSeedlessSearch(QByteArray Data);
		void LoadSeedlessServerList();
		void SaveSeedlessServerList();
		void LoadFallBackSeedlessServerList();
		void SearchForMoreUseFullSeedlessServer();
		void CheckForMax_FailCount();
		void CheckAndFilterResult();
		QString getMetaDataForAnnouncing();

		CCore& mCore;
	const 	QString			   mFilePathToSeedlessList;
	const 	QString			   mFilePathForSettings;
		
		QMap<QString, CSeedlessSearcher*>  mSeedlessServerSearchList;
		QMap<QString, CSeedlessSearcher*>  mSeedlessUserSearcherList;
		QMap<QString, CSeedlessAnnouncer*> mSeedlessAnnouncerList;		
		QMap<QString,SeedlessServerInformation> mSeedlessServerList;

		bool				   mFirstServerSearch;
		SeedlessSearchStruct		   mCurrentSearch;
		QMap<QString,SeedlessSearchStruct> mSearchResult;
		QTimer				   mReAnnouncingTimer;
};
#endif
