/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CMESSAGEACKMANAGER_H
#define CMESSAGEACKMANAGER_H

#include <QObject>
#include <QHash>
#include <QHashIterator>
#include <QString>
#include <QByteArray>
#include <QDebug>
#include <QCryptographicHash>

#include "ChatMessageAckEntry.h"

class CCMessageAckManager : public QObject
{
  Q_OBJECT
public:
  CCMessageAckManager(quint32 timeOutInSec);
  ~CCMessageAckManager();
  
  void doReset();
  QByteArray doCalcHash(QByteArray Data);
  
  QByteArray inputNewChatMessage(QByteArray ChatMessage); //return number\tChatmessage (number=4Byte hex)
  void inputNewAckMessage(QByteArray Data);

signals:
  void signChatMessageTimeOut(QString ChatMessage,bool b);
  
private slots:
  void slotChatMessageTimeOutEntry(QString ChatMessage,QByteArray ChatMessageHash);
  
private:
  quint32 getNextNumber();
  
  
  CCMessageAckManager(const CCMessageAckManager&);
  CCMessageAckManager& operator=(const CCMessageAckManager&);
  QHash<QByteArray,CChatMessageAckEntry*> mHashForAck;
  
  const quint32 mTimeOutInSec;
  quint32 mLastNumber;

};

#endif // CMESSAGEACKMANAGER_H
