/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef USER_H
#define USER_H

#include <QtGui>
#include <QStringList>
#include <QTime>
#include <QtGlobal>
#include <QByteArray>

#include "I2PStream.h"


namespace User
{
	enum CONNECTIONTOUSER{
		OFFLINE,
		ONLINE,
		TRYTOCONNECT,
		ERROR
	};

	enum ONLINESTATE{
		USERONLINE,
		USEROFFLINE,
		USERINVISIBLE,
		USERWANTTOCHAT,
		USERAWAY,
		USERDONT_DISTURB,
		USERTRYTOCONNECT,
		USERBLOCKEDYOU
	};

	enum RECIVEDINFOS{
		NICKNAME,
		GENDER,
		AGE,
		INTERESTS
	};

	struct CRecivedInfos{
		QString Nickname;
		QString Gender;
		qint32  Age;
		QString Interests;
		QByteArray AvatarImage;
	};

}//namespace user

using namespace User;
class CCore;
class CProtocol;
class CChatMessageChanger;
class CCMessageAckManager;
class CUser: public QObject
{
	Q_OBJECT
	public:
					CUser(	CCore&	Core,
						CProtocol& Protocol,
						QString Name,
						QString I2PDestination,
						qint32 I2PStream_ID
					);
					~CUser();
	
	const 	QString 		getName()const;
	const 	QString 		getI2PDestination()const;
	      	qint32  		getI2PStreamID()const;
	const 	QString 		getProtocolVersion()const;
		double			getProtocolVersion_D()const;
	const 	QString 		getClientName()const;
	const	QString 		getClientVersion()const;
	      	QColor  		getTextColor();
	      	QFont   		getTextFont();
		CONNECTIONTOUSER 	getConnectionStatus()const;
		ONLINESTATE 	 	getOnlineState()const;
	const 	QStringList&		getAllChatMessages();
	const	QStringList		getNewMessages(bool haveFocus);
	const	CRecivedInfos		getRecivedUserInfos()const;
	const   QString			getRecivedUserNickname()const;

	const	QString			getHighestUsableProtocolVersionFiletransfer();
		double			getHighestUsableProtocolVersionFiletransfer_D();
	const	QString			getMaxProtocolVersionFiletransfer(){return mMaxProtocolVersionFiletransfer;};
	 	double			getMaxProtocolVersionFiletransfer_D();
	const	QString			getMinProtocolVersionFiletransfer(){return mMinProtocolVersionFiletransfer;};
		double			getMinProtocolVersionFiletransfer_D();
		bool 			getHaveNewUnreadMessages();
		bool			getHaveNewUnreadChatmessages();
		bool			getIsInvisible(){return mInvisible;};
		bool			getUsedB32Dest(){return mUseB32Dest;};

		void 			setConnectionStatus(CONNECTIONTOUSER Status);
		void 			setOnlineState(const ONLINESTATE newState);
		void			setName(QString newName);
		void 			setI2PStreamID(qint32 ID);
		void 			setProtocolVersion(QString Version);
		void 			setClientName(QString Name);
		void 			setClientVersion(QString Version);
		void 			setTextColor(QColor textColor);
		void 			setTextFont(QFont textFont);
		void 			setInvisible(bool b);
		void 			setMaxProtocolVersionFiletransfer(QString Version){mMaxProtocolVersionFiletransfer=Version;};
		void 			setMinProtocolVersionFiletransfer(QString Version){mMinProtocolVersionFiletransfer=Version;};
		void			setRecivedUserInfos(RECIVEDINFOS Tag,QString value);
		void			setRecivedNicknameToUserNickname();
		void			setReplaceB32WithB64(QString b64Dest);
		void			setAvatarImage(QByteArray& avatarImage);
	

	
	public slots:
		void  			slotSendChatMessage(QString Message);
		void 			slotIncomingNewChatMessage(QString newMessage);
// 		void			slotIncomingNewChatMessageForACK(QByteArray newMessage);
// 		void			slotIncomingChatMessageACK(QByteArray ChatmessageACK);
		void 			slotIncomingMessageFromSystem(QString newMessage,bool indicateWithSoundAndIcon=false);

	signals:
		void 			signOnlineStateChanged();
		void 			signNewMessageRecived();
		void 			signNewMessageSound();
		void 			signConnectionOnline();
		void 			signConnectionOffline();
		void			signUserDeleted();
		void			signNewAvatarImage();
	private:
		CCore&			mCore;
		CProtocol& 		mProtocol;
		//CCMessageAckManager*	mChatMessageAckManager;
		QString 		mName;
	const 	QString 		mI2PDestination;
		qint32 			mI2PStream_ID;	
		
		bool			mInvisible;
		bool			mRecivedNicknameToUserNickname;
		bool			mHaveNewUnreadMessages;
		bool			mHaveNewUnreadChatmessage;
		bool			mLogOnlineStateOfUsers;
		CONNECTIONTOUSER 	mConnectionStatus;
		ONLINESTATE	 	mCurrentOnlineState;
		QString 		mProtocolVersion;
		QString			mMaxProtocolVersionFiletransfer;
		QString			mMinProtocolVersionFiletransfer;
		QString 		mClientName;
		QString 		mClientVersion;
		QStringList 		mAllMessages;
		QStringList		mNewMessages;
		QStringList 		mUnsendedMessages;
		
		CRecivedInfos		mRecivedUserInfos;
		bool			mUseB32Dest;

	//<Settings for the chatwindow>
		QColor 			mTextColor;
		QFont  			mTextFont;
	  	CChatMessageChanger&	mChatMessageChanger;
	//</Settings for the chatwindow>
		void 			SendAllunsendedMessages();
};
#endif 
