/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef CCHATMESSAGEACKENTRY_H
#define CCHATMESSAGEACKENTRY_H

#include <QString>
#include <QObject>
#include <QTimer>
#include <QCryptographicHash>
#include <QDebug>
#include <QTime>

class CChatMessageAckEntry :public QObject
{
Q_OBJECT
public:
  CChatMessageAckEntry(QString ChatMessage,qint32 timeOutInSec=2);
  ~CChatMessageAckEntry();
  QByteArray getHash();
  QString getChatMessage();
  
  bool operator ==(QByteArray& In );
  CChatMessageAckEntry& operator =(const CChatMessageAckEntry& con);
  
signals: 
  void signAckTimeOut(QString ChatMessage,QByteArray ChatMessageHash);
  
private slots:
  void slotTimeOut();

private:
  CChatMessageAckEntry(const CChatMessageAckEntry&);
  CChatMessageAckEntry& operator <(const CChatMessageAckEntry&);
  CChatMessageAckEntry& operator >(const CChatMessageAckEntry&);
  CChatMessageAckEntry& operator >=(const CChatMessageAckEntry&);
  CChatMessageAckEntry& operator <=(const CChatMessageAckEntry&);
  
  QTimer mTimer;
  QTime mTimeDebug;
  const QString mChatMessage;
  const qint32 mTimeOutInSec;
  QByteArray mChatMessageHash; //MD5
};

#endif // CCHATMESSAGEACKENTRY_H
