/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "ChatMessageAckEntry.h"


CChatMessageAckEntry::CChatMessageAckEntry(QString ChatMessage,qint32 timeOutInSec)
:mChatMessage(ChatMessage),mTimeOutInSec(timeOutInSec)
{
  QByteArray byteTmp;
  byteTmp.insert(0,ChatMessage);


  mChatMessageHash=QCryptographicHash::hash(byteTmp,QCryptographicHash::Md5).toHex();
  
  //qDebug()<<"File\t"<<__FILE__<<"\n"<<"Line:\t"<<__LINE__<<"\n"<<"calced hash:\t"<<mChatMessageHash<<"\n"
  //  <<"Data length:\t"<<byteTmp.length()<<"\n";
  
  connect(&mTimer,SIGNAL(timeout()),
	  this,SLOT(slotTimeOut()));
  
  mTimer.start(timeOutInSec*1000);
  mTimeDebug.start();
}

CChatMessageAckEntry::~CChatMessageAckEntry()
{
  mTimer.stop();
  qDebug()<<"ACK-Time:\t"<<mTimeDebug.elapsed()<<"\tmsec\n";
  disconnect(&mTimer,SIGNAL(timeout()),
	  this,SLOT(slotTimeOut()));
}

void CChatMessageAckEntry::slotTimeOut()
{
  emit signAckTimeOut(mChatMessage,mChatMessageHash);
}

QByteArray CChatMessageAckEntry::getHash()
{
  return mChatMessageHash;
}

bool CChatMessageAckEntry::operator== ( QByteArray& In )
{
  return (mChatMessageHash==In);
}

CChatMessageAckEntry& CChatMessageAckEntry::operator=(const CChatMessageAckEntry& con)
{
  
  QString& ChatMessage=const_cast<QString&>(mChatMessage);
  qint32& TimeOutInSec=const_cast<qint32&>(mTimeOutInSec);
  
  ChatMessage=con.mChatMessage;
  this->mChatMessageHash=con.mChatMessageHash;
  TimeOutInSec=con.mTimeOutInSec;
  
  connect(&mTimer,SIGNAL(timeout()),
	  this,SLOT(slotTimeOut()));
  
  mTimer.start(mTimeOutInSec*1000);
  mTimeDebug.start();
  return *this;
}

QString CChatMessageAckEntry::getChatMessage()
{
  return mChatMessage;
}
