/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "CMessageAckManager.h"

CCMessageAckManager::CCMessageAckManager(quint32 timeOutInSec)
:mTimeOutInSec(timeOutInSec)
{
  mLastNumber=0;
}

CCMessageAckManager::~CCMessageAckManager()
{
  CChatMessageAckEntry* tmp;
  QHashIterator<QByteArray,CChatMessageAckEntry*> it(mHashForAck);
  while(it.hasNext()){
    it.next();
    tmp=it.value();
        disconnect(tmp,SIGNAL(signAckTimeOut(QString,QByteArray)),
	    this,SLOT(signAckTimeOut(QString,QByteArray)));
    tmp->deleteLater();
  }
  
}

void CCMessageAckManager::doReset()
{
  mLastNumber=0;
   CChatMessageAckEntry* tmp;
  QHashIterator<QByteArray,CChatMessageAckEntry*> it(mHashForAck);
  while(it.hasNext()){
    it.next();
    tmp=it.value();   
        disconnect(tmp,SIGNAL(signAckTimeOut(QString,QByteArray)),
	    this,SLOT(slotChatMessageTimeOutEntry(QString,QByteArray)));
	
	  QString Message=tr("Not possible to acknowledging this message (reason user disconnected):");
	  Message+=tmp->getChatMessage();
	  emit signChatMessageTimeOut(Message, true);
    tmp->deleteLater();
  }
}

QByteArray CCMessageAckManager::doCalcHash(QByteArray Data)
{
  QByteArray tmp=QCryptographicHash::hash(Data,QCryptographicHash::Md5).toHex();
  
  //qDebug()<<"File\t"<<__FILE__<<"\n"<<"Line:\t"<<__LINE__<<"\n"<<"calced hash:\t"<<tmp<<"\n"
  //<<"Data length:\t"<<Data.length()<<"\n";
  return tmp;
}


QByteArray CCMessageAckManager::inputNewChatMessage(QByteArray ChatMessage)
{
    quint32 id=getNextNumber();
    QString temp;	
    temp.setNum(id,16);//hex
    QString PaketID=QString("%1").arg(temp,4,'0');
    ChatMessage.insert(0,PaketID+"\t");
    
    CChatMessageAckEntry* tmp= new CChatMessageAckEntry(ChatMessage,mTimeOutInSec);
    connect(tmp,SIGNAL(signAckTimeOut(QString,QByteArray)),
	    this,SLOT(slotChatMessageTimeOutEntry(QString,QByteArray)));
    
    //qDebug()<<"File\t"<<__FILE__<<"\n"<<"Line:\t"<<__LINE__<<"\ninputHash:\t"<<tmp->getHash();
    mHashForAck.insert(tmp->getHash(),tmp); 
    return ChatMessage;
}

void CCMessageAckManager::inputNewAckMessage(QByteArray Data)
{
  CChatMessageAckEntry* tmp=mHashForAck.take(Data);
  if(tmp!=NULL){
    disconnect(tmp,SIGNAL(signAckTimeOut(QString,QByteArray)),
	    this,SLOT(slotChatMessageTimeOutEntry(QString,QByteArray)));
    tmp->deleteLater();
  }else{
//     qDebug()<<"File\t"<<__FILE__<<"\n"<<"Line:\t"<<__LINE__<<"\n"<<"no message with this hash found \?\n"
//     <<"hash recived:\t"<<Data;
  }
}

quint32 CCMessageAckManager::getNextNumber()
{
  if(mLastNumber< 65535){
    mLastNumber++;
  }
  else{mLastNumber=1;}
  
  return mLastNumber;
}


void CCMessageAckManager::slotChatMessageTimeOutEntry(QString ChatMessage, QByteArray ChatMessageHash)
{
  CChatMessageAckEntry* tmp=mHashForAck.take(ChatMessageHash);
  if(tmp!=NULL){
      tmp->deleteLater();
  }else{
     qDebug()<<"File\t"<<__FILE__<<"\n"<<"Line:\t"<<__LINE__<<"\n"<<"ACK - Object not found";
  }
  ChatMessage.remove(0,5);
  
  QString Message=tr("Message not acknowled (timeout):");
	  Message+=ChatMessage;
	  
  emit signChatMessageTimeOut(Message, true);
}
