/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef STREAMCONTROLLER_H
#define STREAMCONTROLLER_H

#include <QtGui>
#include <QTcpSocket>
#include <QSocketNotifier>

#include "I2PSamMessageAnalyser.h"



class CStreamController:public QObject
{
	Q_OBJECT
	public:
				CStreamController( 
					QString SamHost,
					QString SamPort,
					QString BridgeName,
					QString SamPrivKey,
					QString SessionOptions= "");
				~CStreamController();
		
				QString getBridgeName();
				QString getSamPrivKey();
		
				void doConnect();
				void doDisconnect();
				void doNamingLookUP(QString Name);
				void doDestGenerate();
				
		
	signals:
				void signDebugMessages(const QString Message);
				void signSessionStatusRecived(const SAM_Message_Types::RESULT result,const QString Destination,const QString Message);
				void signNamingReplyRecived(const SAM_Message_Types::RESULT result,QString Name,QString Value="",QString Message="");
				void signSessionStreamStatusOK(bool Status);
				void signNewSamPrivKeyGenerated(const QString SamPrivKey);


	private slots:
				void slotConnected();
				void slotDisconnected();
				void slotReadFromSocket();

	private:
				void doSessionCreate();
	
		const 	QString 	mSamHost;
		const 	QString 	mSamPort;
		const 	QString 	mBridgeName;
			QString 	mSamPrivKey;
		const 	QString 	mSessionOptions;	
			QTcpSocket 	mTcpSocket;
			CI2PSamMessageAnalyser* mAnalyser;
			QByteArray* 	mIncomingPackets;
	
			bool mHandShakeWasSuccesfullDone;
			bool mSessionWasSuccesfullCreated;
			bool mDoneDisconnect;
		
			inline void ConnectionReadyCheck()
			{
				if(	mHandShakeWasSuccesfullDone==false ||
					mSessionWasSuccesfullCreated==false||
					mTcpSocket.state()!=QAbstractSocket::ConnectedState)
				return;
			}
};
#endif
