/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "User.h"
#include "Protocol.h"
#include "ChatmessageChanger.h"
#include "FileTransferSend.h"
#include "Core.h"

CUser::CUser(	CCore&	Core,
		CProtocol& Protocol,
		QString Name,
		QString I2PDestination,
		qint32 I2PStream_ID
		):mCore(Core),mProtocol(Protocol),mI2PDestination(I2PDestination),mChatMessageChanger(*(CChatMessageChanger::exemplar(Core)))		
{
	QSettings settings(mCore.getConfigPath()+"/application.ini",QSettings::IniFormat);

	this->mName=Name;
	this->mI2PStream_ID=I2PStream_ID;
	this->mConnectionStatus=OFFLINE;
	this->mClientName="";
	this->mClientVersion="";
	this->mCurrentOnlineState=USEROFFLINE;
	this->mHaveNewUnreadMessages=false;	

	settings.beginGroup("Chat");
		this->mTextFont.fromString(settings.value("DefaultFont","Comic Sans MS,10").toString());
		this->mTextColor.setNamedColor(settings.value("DefaultColor","#000000").toString());
	settings.endGroup();
	this->mInvisible=false;
	this->mRecivedNicknameToUserNickname=false;
	this->mProtocolVersion="0.2";
	this->mMaxProtocolVersionFiletransfer="0.1";
	this->mMinProtocolVersionFiletransfer="0.1";
	this->mRecivedUserInfos.Age=0;
	
	if(mI2PDestination.length()==60){
	    mUseB32Dest=true;
	}else{
	    mUseB32Dest=false;
	}
}
CUser::~CUser()
{
    emit signUserDeleted();
}

const QString CUser::getName()const{
	return this->mName;
}
const QString CUser::getI2PDestination()const{
	return this->mI2PDestination;
}
qint32 CUser::getI2PStreamID()const{
	return this->mI2PStream_ID;
}

CONNECTIONTOUSER CUser::getConnectionStatus()const{
	return this->mConnectionStatus;
}

void CUser::setName(QString newName){
	this->mName=newName;
}
void CUser::setConnectionStatus(CONNECTIONTOUSER Status){
	
	mConnectionStatus=Status;
	
	if(Status==ONLINE){
		if(getUsedB32Dest()==true){
		    mCore.doNamingLookUP(mI2PDestination);
		}
		//get some Infos from the CHATSYSTEM - client
		mProtocol.send(GET_CLIENTNAME		,mI2PStream_ID);
		mProtocol.send(GET_CLIENTVERSION	,mI2PStream_ID);
		mProtocol.send(GET_USER_ONLINESTATUS	,mI2PStream_ID);
		

		if(getProtocolVersion_D()>=0.3){
			mProtocol.send(GET_MAX_PROTOCOLVERSION_FILETRANSFER,mI2PStream_ID);
			mProtocol.send(GET_USER_INFOS,mI2PStream_ID);
		}
		if(getProtocolVersion_D()>=0.4){
			mProtocol.send(GET_MIN_PROTOCOLVERSION_FILETRANSFER,mI2PStream_ID);
		}
	}

	if(Status==OFFLINE ||Status==ERROR){
		mI2PStream_ID=0;
		
		if(mCurrentOnlineState!=USERBLOCKEDYOU){
		    setOnlineState(USEROFFLINE);
		}
	}
}

void CUser::setI2PStreamID(qint32 ID){
	this->mI2PStream_ID=ID;
}

void CUser::setProtocolVersion(QString Version){
	this->mProtocolVersion=Version;
}
const QString CUser::getProtocolVersion()const{
	return this->mProtocolVersion;
}

void CUser::IncomingNewChatMessage(QString newMessage){

	newMessage=mChatMessageChanger.changeChatMessage(newMessage);

	this->mAllMessages.push_back(mName+" ("+ QTime::currentTime().toString("hh:mm:ss") +"): "+newMessage+"<br>");
	this->mNewMessages.push_back(mName+" ("+ QTime::currentTime().toString("hh:mm:ss") +"): "+newMessage+"<br>");
	this->mHaveNewUnreadMessages=true;

	emit signNewMessageRecived();
	emit signNewIncomingMessageRecived();
}
void CUser::slotSendChatMessage(QString Message){
	using namespace PROTOCOL_TAGS;

	if(mConnectionStatus==ONLINE && 
		mCurrentOnlineState != USEROFFLINE &&
		mCurrentOnlineState != USERINVISIBLE
	){
		QByteArray ByteMessage=Message.toUtf8();
		mProtocol.send(CHATMESSAGE,mI2PStream_ID,ByteMessage);

		this->mAllMessages.push_back("Me ("+QTime::currentTime().toString("hh:mm:ss")  +"): "+Message+"<br>");
		this->mNewMessages.push_back("Me ("+QTime::currentTime().toString("hh:mm:ss")  +"): "+Message+"<br>");
		mHaveNewUnreadMessages=true;

		emit signNewMessageRecived();	
	}
	else{
		this->mAllMessages.push_back("[SYSTEM] ("+QTime::currentTime().toString("hh:mm:ss") +"): "+
			"Sending the message when the user comes online.<br>If you close the client, the message will be lost.<br><br>");

		this->mNewMessages.push_back("[SYSTEM] ("+QTime::currentTime().toString("hh:mm:ss") +"): "+
			"Sending the message when the user comes online.<br>If you close the client, the message will be lost.<br><br>");
		
		mHaveNewUnreadMessages=true;
		
		mUnsendedMessages.push_back(Message);
		emit signNewMessageRecived();
	}
}


const QStringList& CUser::getAllChatMessages(){
	mNewMessages.clear();
	mHaveNewUnreadMessages=false;

	emit signOnlineStateChanged();
	return mAllMessages;
}
void CUser::SendAllunsendedMessages(){ 
	using namespace PROTOCOL_TAGS;
	if(mUnsendedMessages.empty())return;


	for(int i=0;i<mUnsendedMessages.count();i++)
		mProtocol.send(CHATMESSAGE,mI2PStream_ID,mUnsendedMessages.at(i));

	this->mAllMessages.push_back("[SYSTEM] ("+QTime::currentTime().toString("hh:mm:ss")+"): All unsent messages were sent<br><br>");
	this->mNewMessages.push_back("[SYSTEM] ("+QTime::currentTime().toString("hh:mm:ss")+"): All unsent messages were sent<br><br>");
	mHaveNewUnreadMessages=true;
	mUnsendedMessages.clear();
	
	emit signNewMessageRecived();
}

bool CUser::getHaveNewUnreadMessages(){
	return mHaveNewUnreadMessages;
}

const QString CUser::getClientName() const
{
	return mClientName;
}

void CUser::setClientName(QString Name)
{
	mClientName=Name;
}


const QString CUser::getClientVersion() const
{
	return mClientVersion;
}

void CUser::setClientVersion(QString Version)
{
	this->mClientVersion=Version;
	if(mClientName=="I2P-Messenger (QT)" && mClientVersion=="0.2.15 Beta"){
	    setMaxProtocolVersionFiletransfer("0.2");
	}
}

ONLINESTATE CUser::getOnlineState() const
{
	return mCurrentOnlineState;
}

void CUser::setOnlineState(const ONLINESTATE newState)
{
	if(mCurrentOnlineState==newState)return;
  
	if(newState!=USEROFFLINE && 
	   newState!=USERINVISIBLE &&
	   newState!=USERBLOCKEDYOU){		
		if(mCurrentOnlineState==USEROFFLINE || mCurrentOnlineState==USERINVISIBLE ||  mCurrentOnlineState==USERBLOCKEDYOU){
			emit signConnectionOnline();
		}
		this->SendAllunsendedMessages();
	}
	else if(newState==USEROFFLINE || newState==USERINVISIBLE || newState==USERBLOCKEDYOU){
		if(newState!=mCurrentOnlineState)
			emit signConnectionOffline();

	}

	this->mCurrentOnlineState=newState;
	emit signOnlineStateChanged();
}

QColor CUser::getTextColor()
{
	return mTextColor;
}

void CUser::setTextColor(QColor textColor)
{
	this->mTextColor=textColor;
}

void CUser::setTextFont(QFont textFont)
{
	this->mTextFont=textFont;
}

QFont CUser::getTextFont()
{
	return mTextFont;
}

void CUser::IncomingMessageFromSystem(QString newMessage)
{
	this->mAllMessages.push_back("[System] ("+ QTime::currentTime().toString("hh:mm:ss") +"): "+newMessage+"<br><br>");	
	this->mNewMessages.push_back("[System] ("+ QTime::currentTime().toString("hh:mm:ss") +"): "+newMessage+"<br><br>");	
	mHaveNewUnreadMessages=true;	

	emit signNewMessageRecived();
	emit signNewIncomingMessageRecived();
}

void CUser::setInvisible(bool b)
{
	mInvisible=b;
	if(mConnectionStatus==ONLINE){
		QByteArray Data("1003");//GET_USER_ONLINESTATUS = send the new OnlineStatus
		mProtocol.slotInputKnown(mI2PStream_ID,Data);
	}
	emit signOnlineStateChanged();
}


const QStringList CUser::getNewMessages(bool haveFocus)
{
	QStringList tmp(mNewMessages);
	mNewMessages.clear();
	
	if(haveFocus==true){
		mHaveNewUnreadMessages=false;
		emit signOnlineStateChanged();
	}

	return tmp;
}



const CRecivedInfos CUser::getRecivedUserInfos() const
{
	return mRecivedUserInfos;
}

const QString CUser::getRecivedUserNickname() const
{
	return mRecivedUserInfos.Nickname;
}

double CUser::getProtocolVersion_D() const
{
	double tmp=0.0;
	bool OK=false;
	tmp=mProtocolVersion.toDouble(&OK);

	if(OK==false){
		qCritical()<<"CUser::getProtocolVersion_D()"<<"Cant convert QString to double: ";
	}
	return tmp;
}

double CUser::getMaxProtocolVersionFiletransfer_D()
{
	double tmp=0.0;
	bool OK=false;
	tmp=mMaxProtocolVersionFiletransfer.toDouble(&OK);

	if(OK==false){
		qCritical()<<"CUser::getMaxProtocolVersionFiletransfer_D()"<<"Cant convert QString to double: ";
	}
	return tmp;
}

double CUser::getMinProtocolVersionFiletransfer_D()
{
	double tmp=0.0;
	bool OK=false;
	tmp=mMinProtocolVersionFiletransfer.toDouble(&OK);

	if(OK==false){
		qCritical()<<"CUser::getMinProtocolVersionFiletransfer_D()"<<"Cant convert QString to double: ";
	}
	return tmp;
}

void CUser::setRecivedUserInfos(RECIVEDINFOS Tag, QString value)
{
	switch (Tag){
		case NICKNAME:
		{
			mRecivedUserInfos.Nickname=value;
			if(mRecivedNicknameToUserNickname==true){
				if(value.isEmpty()==true){
					setName("No Nickname");	
				}
				else{
					setName(value);
				}
				mRecivedNicknameToUserNickname=false;
				emit signOnlineStateChanged();
			}
			break;
		}
		case GENDER:
		{
			mRecivedUserInfos.Gender=value;
			break;
		}
		case AGE:
		{
			bool OK=false;
			mRecivedUserInfos.Age=value.toInt(&OK);
			if(OK==false){
				qCritical()<<"CUser::setRecivedUserInfos()"<<"Can't convert QString to qint32"<<"QString: "<<value;
			}
			break;
		}
		case INTERESTS:
		{
			mRecivedUserInfos.Interests=value;
			break;
		}
		default:
		{
			qDebug()<<"CUser::setRecivedUserInfos()"<<"unknown Tag";
			break;
		}
	}
}

void CUser::setRecivedNicknameToUserNickname()
{
	if(getProtocolVersion_D()>=0.3){
		mRecivedNicknameToUserNickname=true;
	}
	else{
		qDebug()<<"CUser::setRecivedNicknameToUserNickname()"<<"Protocolversion <0.3, action ignored";
	}
}

const QString CUser::getHighestUsableProtocolVersionFiletransfer()
{
      return QString::number(getHighestUsableProtocolVersionFiletransfer_D(),'g',2);
}

double CUser::getHighestUsableProtocolVersionFiletransfer_D()
{
      double maxVersion=getMaxProtocolVersionFiletransfer_D();
      
      while(maxVersion> FileTransferProtocol::MAXPROTOCOLVERSION_D){
	maxVersion-=0.1;
      }
      return maxVersion;
}
void CUser::setReplaceB32WithB64(QString b64Dest)
{
    if(mUseB32Dest==true){
	QString& dest = const_cast< QString & >(mI2PDestination);
	dest=b64Dest;
    }else{
	qCritical()<<"void CUser::setReplaceB32WithB64\n"<<"Current Destination is not a b32 dest...\n" <<endl;
    }
}
