/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CORE_H
#define CORE_H

#include <QtGui>
#include <QSettings>
#include <QTextStream>
#include <QList>

#include "User.h"
#include "I2PSamMessageAnalyser.h"
#include "DebugMessageManager.h"
#include "SoundManager.h"
#include "Protocol.h"
#include "UserBlockManager.h"
#include "FileTransferManager.h"



#define CLIENTVERSION "0.2.17 Beta"
#define CLIENTNAME "I2P-Messenger (QT)"

using namespace SAM_Message_Types;
using namespace User;

class CUserManager;
class CConnectionManager;
class CFileTransferManager;
class CPacketManager;
class CSeedlessManager;
class CCore :public QObject
{

		Q_OBJECT
	public:
		CCore();
		~CCore();

		QString 		getDestinationByID(qint32 ID);
	const 	QString 		getMyDestination() 		const;
		ONLINESTATE 		getOnlineStatus()		const;
		QString 		getClientName()			const 	{return CLIENTNAME;};
		QString 		getClientVersion()		const	{return CLIENTVERSION;};
		QString 		getProtocolVersion()		const	{return mProtocol->getProtocolVersion();};
	const 	CI2PStream* 		getI2PStreamObjectByID(qint32 ID)const;
	const	CRecivedInfos		getUserInfos()const;
		QString 		getConnectionDump();
		
	//<SUBSYSTEMS>
		CDebugMessageManager* 	getDebugMessageHandler()	const	{return mDebugMessageHandler;};
		CDebugMessageManager*	getDebugSeedlessHandler()	const	{return mDebugSeedlessHandler;};
		CConnectionManager*	getConnectionManager()		const	{return mConnectionManager;};
		CUserBlockManager*	getUserBlockManager()		const	{return mUserBlockManager;};
		CProtocol*		getProtocol()			const	{return mProtocol;};
		CSeedlessManager*	getSeedlessManager()		const	{return mSeedlessManager;};
		CSoundManager*		getSoundManager()			{return &mSoundManager;};
		CUserManager*		getUserManager()		const	{return mUserManager;};
		CFileTransferManager*	getFileTransferManager()	const	{return mFileTransferManager;};
	//</SUBSYSTEMS>
		
		void			setUserProtocolVersionByStreamID ( qint32 ID,QString Version );
		void 			setOnlineStatus(const ONLINESTATE newStatus);
		void 			setStreamTypeToKnown(qint32 ID,const QByteArray Data,bool isFileTransfer_Recive=false);
	
		bool 			useThisChatConnection(const QString Destination,const qint32 ID);
	
		void 			doNamingLookUP ( QString Name )const;
		void			doConvertNumberToTransferSize(quint64 inNumber,QString& outNumber,QString& outType,bool addStoOutType=true)const;
		
		void 			deletePacketManagerByID ( qint32 ID );
		void 			createStreamObjectsForAllUsers();
		void 			createStreamObjectForUser(CUser& User);

	private slots:
	// <SIGNALS FROM CONNECTIONMANAGER>
		void slotStreamStatusRecived ( const SAM_Message_Types::RESULT result,const qint32 ID,QString Message );
		void slotNamingReplyRecived ( const SAM_Message_Types::RESULT result,QString Name,QString Value="",QString Message="" );
		void slotStreamControllerStatusOK(bool Status);
		void slotIncomingStream(CI2PStream* stream);
		void slotNewSamPrivKeyGenerated(const QString SamPrivKey);
	// </SIGNALS FROM CONNECTIONMANAGER>
	signals:
		void signUserStatusChanged();
		void signOnlineStatusChanged();

	private:
		CConnectionManager*	mConnectionManager;
		CDebugMessageManager* 	mDebugMessageHandler;
		CDebugMessageManager*	mDebugSeedlessHandler;
		CSoundManager 		mSoundManager;
		CProtocol* 		mProtocol;
		CSeedlessManager*	mSeedlessManager;	
		CUserBlockManager*	mUserBlockManager;
		CUserManager*		mUserManager;
		CFileTransferManager*	mFileTransferManager;

		CRecivedInfos		mUserInfos;
		QString 		mMyDestination;
		QList<CPacketManager*> 	mDataPacketsManagers;
		ONLINESTATE 		mCurrentOnlineStatus;
		ONLINESTATE 		mNextOnlineStatus;

		
		void init();
		void stopCore();
		void restartCore();
		void closeAllActiveConnections();
		void loadUserInfos();
};
#endif
