#include "gui/form_chatwidget.h"
#include "src/User.h"

bool ChatEventEater::eventFilter(QObject *obj, QEvent *event)
{
	if ( event->type() == QEvent::KeyPress )
	{
        QKeyEvent *keyEvent = static_cast<QKeyEvent *>(event);
        if ( obj->objectName() == "message")
        {
        	if ( keyEvent->key() == Qt::Key_Return && keyEvent->modifiers() == Qt::NoModifier)
        	{
        		emit sendMessage();
        		return true;
        	}
        	else if (keyEvent->key() == Qt::Key_Return 
        			&& keyEvent->modifiers() == Qt::ControlModifier)
        	{
        		emit sendMessage();
        		return true;
        	}
	}
	return QObject::eventFilter(obj, event);
	}

	if(event->type()==QEvent::FocusIn){
		emit haveFocus(true);
		return true;
	}
	else if(event->type()==QEvent::FocusOut){
		emit haveFocus(false);
		return true;
	}
	
	
	return false;
}


form_ChatWidget::form_ChatWidget(CUser& user,CCore& Core,QDialog* parent /* = 0 */)
:QDialog(parent), user(user),Core(Core)
{
	setupUi(this);

	QTextEdit *message=this->message;
	QTextBrowser *chat=this->chat;
	QToolButton *txtBold=this->txtBold;
	QToolButton *txtItalic=this->txtItalic;
	QToolButton *txtUnder=this->txtUnder;


	m_event_eater = new ChatEventEater(this);
    	connect(m_event_eater, SIGNAL(sendMessage()),
    		send, SLOT(click()));

	connect(m_event_eater,SIGNAL(haveFocus(bool)),
		this,SLOT(focusEvent(bool)));

	message->installEventFilter(m_event_eater);

	connect(&user,SIGNAL(signNewMessageRecived()),this,
		SLOT(newMessageRecived()));

	connect(&user,SIGNAL(signOnlineStateChanged()),this,
		SLOT(changeWindowsTitle()));
		
	connect(&user,SIGNAL(signUserDeleted()),this,
		SLOT(close()));

	connect(this,SIGNAL(sendChatMessage(QString)),&user,
		SLOT(slotSendChatMessage(QString)));


	connect(cmd_SendFile,SIGNAL(clicked()),this,
		SLOT(newFileTransfer()));

	connect(chat, SIGNAL(anchorClicked(const QUrl &)), SLOT(anchorClicked(const QUrl &)));
	
	
	chat->setOpenLinks(false);
	
			
  	mCurrentFont = user.getTextFont();
	textColor = user.getTextColor();
	mHaveFocus=false;

	QPixmap pxm(22,22);
	pxm.fill(textColor);
	//txtColor->setIcon(pxm);
	
	connect(send, SIGNAL(clicked()), SLOT(sendMessageSignal()));
	connect(txtColor, SIGNAL(clicked()), SLOT(setTextColor()));
	connect(txtBold, SIGNAL(clicked(bool)),SLOT(setBold(bool)));
	connect(txtFont, SIGNAL(clicked()), SLOT(setFont()));
	connect(txtUnder,SIGNAL(clicked( bool )),SLOT(setUnderline(bool)));
	connect(txtItalic,SIGNAL(clicked( bool )),SLOT(setItalic(bool)));

	
	QPalette pal = message->palette(); 
	pal.setBrush(QPalette::Text,QBrush(textColor));
	message->setPalette(pal);

	message->setCurrentFont(mCurrentFont);
	message->setFont(mCurrentFont);

	txtBold->setChecked(mCurrentFont.bold());
	txtItalic->setChecked(mCurrentFont.italic());
	txtUnder->setChecked(mCurrentFont.underline());

	resize(450,400);
	changeWindowsTitle();
	addAllMessages();
	QScrollBar *sb=chat->verticalScrollBar();

	sb->setValue(sb->maximum());

}

void form_ChatWidget::newMessageRecived(){
	QTextEdit *chat=this->chat;
	QScrollBar *sb=chat->verticalScrollBar();

	
	int oldVerticalScrollBarValue=sb->value();
	int VerticalScrollBarMax=sb->maximum();
	bool restoreOldVerticalScrollBarValue=false;

	if(VerticalScrollBarMax-oldVerticalScrollBarValue >2){
		restoreOldVerticalScrollBarValue=true;
	}

	QStringList Messages=user.getNewMessages(mHaveFocus);
	int i=0;
	QString temp;	
	while(i<Messages.count()){
		 temp=Messages.at(i);
		this->addMessage(temp);
		i++;
	}
	
	if(restoreOldVerticalScrollBarValue==true){
		sb->setValue(oldVerticalScrollBarValue);
	}
	else{
		sb->setValue(sb->maximum());
	}
}

void form_ChatWidget::addAllMessages(){
	QTextEdit *chat=this->chat;
	QScrollBar *sb=chat->verticalScrollBar();
	chat->clear();

	QStringList Messages=user.getAllChatMessages();
	int i=0;	
	while(i<Messages.count()){
		QString test =Messages.at(i);
		this->addMessage(test);
		i++;
	}
	
	sb->setValue(sb->maximum());
}


void form_ChatWidget::addMessage(QString text){
	QTextEdit *chat=this->chat;
	QTextCursor cursor = chat->textCursor();
	
	//replace http://, https:// and www. with <a href> links
	QRegExp rx("(https?://[^ <>]*)|(www\\.[^ <>]*)");
	int count = 0;
  	int pos = 100; //ignore the first 100 char because of the standard DTD ref
	while ( (pos = rx.indexIn(text, pos)) != -1 ) {
		//we need to look ahead to see if it's already a well formed link
		if (text.mid(pos - 6, 6) != "href=\"" && 
		    text.mid(pos - 6, 6) != "href='" && 
		    text.mid(pos - 6, 6) != "ttp://" &&
		    text.mid(pos - 6, 6) != "tps://"
		    ) 
		{
			QString tempMessg = text.left(pos) + "<a href=\"" + rx.cap(count) + "\">" + rx.cap(count) + "</a>" + text.mid(pos + rx.matchedLength(), -1);
			text = tempMessg;
		}
		pos += rx.matchedLength() + 15;
		count ++;
  	}
	
	cursor.movePosition(QTextCursor::End);
	chat->setTextCursor(cursor);

	chat->insertHtml(text);	
}	

void form_ChatWidget::setTextColor(){
	QTextEdit *message=this->message;
	textColor = QColorDialog::getColor(user.getTextColor(), this);
	
	//textColor = QColorDialog::getColor(message->textColor(), this);
	QPixmap pxm(22,22);
	pxm.fill(textColor);
	//txtColor->setIcon(pxm);
	user.setTextColor(textColor);
	

	QPalette pal = message->palette(); 
	pal.setBrush(QPalette::Text,QBrush(textColor));
	message->setPalette(pal);

}

void form_ChatWidget::setFont()
{
	QTextEdit *message=this->message;
    	bool ok;
    	mCurrentFont = QFontDialog::getFont(&ok, mCurrentFont, this);
    	
	user.setTextFont(mCurrentFont);
	message->setCurrentFont(mCurrentFont);
	message->setFont(mCurrentFont);
	message->setFocus();
}


void form_ChatWidget::setBold(bool t){

	QTextEdit *message=this->message;

	mCurrentFont.setBold(t);
	user.setTextFont(mCurrentFont);

	message->setCurrentFont(mCurrentFont);
	message->setFont(mCurrentFont);
}

void form_ChatWidget::closeEvent(QCloseEvent *e){
	disconnect(&user,SIGNAL(signNewMessageRecived()),this,
		SLOT(newMessageRecived()));
		
	emit closingChatWindow(user.getI2PDestination());
	e->ignore();
}

void form_ChatWidget::sendMessageSignal(){
	QTextEdit *message=this->message;
	if(message->toPlainText().length()==0)return;

	mControllForChange.setHtml(message->toHtml());
	mControllForChange.selectAll();
	mControllForChange.setCurrentFont(mCurrentFont);
	mControllForChange.setFont(mCurrentFont);
	mControllForChange.setTextColor(user.getTextColor());

	mControllForChange.setFontUnderline(mCurrentFont.underline());
	mControllForChange.setFontItalic(mCurrentFont.italic());

	
	QString NewMessage=mControllForChange.toHtml();

	user.slotSendChatMessage(NewMessage);

	message->clear();
}


void form_ChatWidget::changeWindowsTitle()
{
	QString OnlineStatus;
	QString OnlineStatusIcon;
	switch(user.getOnlineState())
		{
			
			case USERTRYTOCONNECT:
			case USERINVISIBLE:
			case USEROFFLINE:{
						OnlineStatus="Offline";
						this->setWindowIcon(QIcon(ICON_USER_OFFLINE));
						break;
					}
			case USERONLINE:	
					{
						OnlineStatus="Online";
						this->setWindowIcon(QIcon(ICON_USER_ONLINE));
						break;
					}
			case USERWANTTOCHAT:
					{
						OnlineStatus="Want to chat";
						this->setWindowIcon(QIcon(ICON_USER_WANTTOCHAT));
						break;
					}
			case USERAWAY:
					{
						OnlineStatus="Away";
						this->setWindowIcon(QIcon(ICON_USER_AWAY));	
						break;
					}
			case USERDONT_DISTURB:
					{
						OnlineStatus="Don't disturb";
						this->setWindowIcon(QIcon(ICON_USER_DONT_DUSTURB));
						break;
					}
			case USERBLOCKEDYOU:
					{
						OnlineStatus="You where blocked";
						this->setWindowIcon(QIcon(ICON_USER_BLOCKED_YOU));
						break;
			    
					}
		}
	this->setWindowTitle(tr("Chat with: ") + user.getName() +"       ("+ OnlineStatus +")");
}

void form_ChatWidget::newFileTransfer()
{
	if(user.getConnectionStatus()==ONLINE){
		QString FilePath=QFileDialog::getOpenFileName(this,"Open File", ".", "all Files (*)");
		QString Destination= user.getI2PDestination();
		
		if(FilePath.endsWith("/")==true){
		  //only a directory ,- dont send it
		  return;
	      }
		
		if(!FilePath.isEmpty())
			Core.getFileTransferManager()->addNewFileTransfer(FilePath,Destination);
			
	}
	else{
		QMessageBox* msgBox= new QMessageBox(this);
		msgBox->setIcon(QMessageBox::Information);
		msgBox->setText(tr("Sendfile"));
		msgBox->setInformativeText(tr("The other user must be online, filesend abborted"));
		msgBox->setStandardButtons(QMessageBox::Ok);
		msgBox->setDefaultButton(QMessageBox::Ok);
		msgBox->setWindowModality(Qt::NonModal);
		msgBox->show();
	}
}


void form_ChatWidget::anchorClicked (const QUrl& link ) 
{

	if (link.scheme() == "http" || link.scheme() == "https")
		QDesktopServices::openUrl(link);
	else if (link.scheme() == "") 
	{
		//it's probably a web adress, let's add http:// at the beginning of the link
		QString newAddress = link.toString();
		newAddress.prepend("http://");
		QDesktopServices::openUrl(QUrl(newAddress));
	}
}


void form_ChatWidget::focusEvent(bool b)
{
	mHaveFocus=b;

	if(b==true){
		if(user.getHaveNewUnreadMessages()==true){
			newMessageRecived();
		}
	}

}

void form_ChatWidget::getFocus()
{
  this->activateWindow();
  this->setWindowState((windowState() & (~Qt::WindowMinimized)) | Qt::WindowActive);
  this->raise();

}

void form_ChatWidget::setUnderline(bool t)
{
	mCurrentFont.setUnderline(t);
	user.setTextFont(mCurrentFont);

	message->setCurrentFont(mCurrentFont);
	message->setFont(mCurrentFont);
	message->setFocus();
}

void form_ChatWidget::setItalic(bool t)
{
	mCurrentFont.setItalic(t);
	user.setTextFont(mCurrentFont);

	message->setCurrentFont(mCurrentFont);
	message->setFont(mCurrentFont);
	message->setFocus();
}

form_ChatWidget::~form_ChatWidget()
{
}

void form_ChatWidget::keyPressEvent(QKeyEvent* event)
{	
    if (event->key() != Qt::Key_Escape){ 
        QDialog::keyPressEvent(event); 
    }
    else {
        event->accept();
        close();
    } 
}
