/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <iostream>
#include "PacketManager.h"
#include "ConnectionManager.h"
#include "I2PStream.h"


using namespace std;

CPacketManager::CPacketManager (CConnectionManager& ConnectionManager,qint32 ID )
:mConnectionManager(ConnectionManager),mID ( ID ) 
{
	mData= new QByteArray();
}

CPacketManager::~CPacketManager() 
{
	delete mData;
	mData=NULL;
	
}

void CPacketManager::operator << ( QByteArray t )
{
	if(mData!=NULL){
	    mData->append ( t );
	    checkifOnePacketIsCompleate();
	}
}
qint32 CPacketManager::getID()
{
	return mID;
}

void  CPacketManager::checkifOnePacketIsCompleate()
{	
	
	    if(mData==NULL){
	      return;
	    }
  
	    if (mData!=NULL & mData->length() >=8 )
	    {
		    QString sPacketLength=mData->mid ( 0,4 );
		    

		    bool OK=false;
		    int iPacketLength =sPacketLength.toInt ( &OK,16 );
		    if(OK==false)
		    {
			    qCritical()<<"CPacketManager::checkifOnePacketIsCompleate()\n"
				      <<"StreamID: "<<mID<<"\n"
				      <<"cant parse PacketLength\n"
				      <<"sPacketLength: "<<sPacketLength<<"\n"
				      <<"closing Stream\n";

			    CI2PStream* stream=(CI2PStream*)mConnectionManager.getStreamObjectByID(mID);
			    if(stream!=NULL){
				    stream->doDisconnect();
			    }


		    }

		    if (mData!=NULL && mData->length() >=iPacketLength+4 )
		    {
			    QByteArray CurrentPacket (mData->mid ( 4 ),iPacketLength );
			    mData->remove ( 0,iPacketLength+4 );
			    
			    emit signAPacketIsCompleate ( mID,CurrentPacket );
			    checkifOnePacketIsCompleate();
		    }
	    }
	return;
}

void CPacketManager::slotDataInput(qint32 ID,QByteArray t)
{ 
	if(ID==this->mID)
	{
		*(this)<<t;
	}
}

