/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CORE_H
#define CORE_H

#include <QtGui>
#include <QSettings>
#include <QTextStream>
#include <QList>

#include "User.h"
#include "I2PSamMessageAnalyser.h"
#include "DebugMessageManager.h"
#include "SoundManager.h"
#include "Protocol.h"
#include "UserBlockManager.h"


#define CLIENTVERSION "0.2.16 Beta"
#define CLIENTNAME "I2P-Messenger (QT)"

using namespace SAM_Message_Types;
using namespace User;

class CConnectionManager;
class CFileTransferSend;
class CFileTransferRecive;
class CPacketManager;
class CSeedlessManager;
class CCore :public QObject
{

		Q_OBJECT
	public:
		CCore();
		~CCore();

		CUser* 			getUserByI2P_ID ( qint32 ID );
		CUser* 			getUserByI2P_Destination ( QString Destination );
		QString 		getDestinationByID(qint32 ID);
	const 	QString 		getMyDestination() const;
		ONLINESTATE 		getOnlineStatus()const;
		QString 		getClientName() {return CLIENTNAME;};
		QString 		getClientVersion(){return CLIENTVERSION;};
		QString 		getProtocolVersion(){return mProtocol->getProtocolVersion();};
		CFileTransferRecive*	getFileTransferReciveByID(qint32 ID);
		CFileTransferSend*	getFileSendsByID(qint32 ID);
		QString			getUserInfosByI2P_Destination(QString Destination);
	const 	CI2PStream* 		getI2PStreamObjectByID(qint32 ID);
	const 	QList<CUser*> 		getUserList();
	const 	QList<CFileTransferRecive*> getFileTransferReciveList();
	const 	QList<CFileTransferSend*>getFileSendsList();
	const	CRecivedInfos		getUserInfos()const;

		QString 		getConnectionDump();
		CDebugMessageManager* 	getDebugMessageHandler();
		CDebugMessageManager*	getDebugSeedlessHandler();
		CConnectionManager*	getConnectionManager(){return mConnectionManager;};
		CUserBlockManager*	getUserBlockManager(){return mUserBlockManager;};
		CProtocol*		getProtocol(){return mProtocol;};
		CSeedlessManager*	getSeedlessManager(){return mSeedlessManager;};

		void			setUserProtocolVersionByStreamID ( qint32 ID,QString Version );
		void 			setOnlineStatus(const ONLINESTATE newStatus);
		void 			setStreamTypeToKnown(qint32 ID,const QByteArray Data,bool isFileTransfer_Recive=false);
		
		bool 			addNewUser (QString Name,QString I2PDestination,qint32 I2PStream_ID=0,bool SaveUserList=true);
		void 			addNewFileTransfer(QString FilePath,QString Destination);
		void 			addNewFileRecive(qint32 ID,QString FileName,QString FileSize,QString Destination,QString ProtocolVersion);
	
		void 			removeFileTransfer(const qint32 ID);
		void 			removeFileRecive  (const qint32 ID);
		
		void 			changeUserPositionInUserList(int oldPos,int newPos);
		void 			DestroyStreamObjectByID(qint32 ID);
		
		bool 			UseThisChatConnection(const QString Destination,const qint32 ID);
	
		bool 			deleteUserByI2PDestination (const QString I2PDestination );
		bool 			renameUserByI2PDestination (const QString Destination, const QString newNickname);
		void 			doNamingLookUP ( QString Name );
		void			doConvertNumberToTransferSize(quint64 inNumber,QString& outNumber,QString& outType);

		void 			MuteSound(bool t);
		
		bool 			checkIfAFileTransferOrReciveisActive();
		bool 			doesUserAllReadyExitsByI2PDestination ( QString I2PDestination );
		
		void 			deletePacketManagerByID ( qint32 ID );

	private slots:
		// <SIGNALS FROM CONNECTIONMANAGER>
		void slotStreamStatusRecived ( const SAM_Message_Types::RESULT result,const qint32 ID,QString Message );
		void slotNamingReplyRecived ( const SAM_Message_Types::RESULT result,QString Name,QString Value="",QString Message="" );
		void slotStreamControllerStatusOK(bool Status);
		void slotIncomingStream(CI2PStream* stream);
		void slotNewSamPrivKeyGenerated(const QString SamPrivKey);
	signals:
		void signUserStatusChanged();
		void signOnlineStatusChanged();

	private:
		CConnectionManager*	mConnectionManager;
		CDebugMessageManager* 	mDebugMessageHandler;
		CDebugMessageManager*	mDebugSeedlessHandler;
		CSoundManager 		mSoundManager;
		CProtocol* 		mProtocol;
		CRecivedInfos		mUserInfos;
		

		CSeedlessManager*	mSeedlessManager;

		
		CUserBlockManager*	mUserBlockManager;

		QList<CUser*> 		mUsers;
		QString 		mMyDestination;
		QList<CPacketManager*> 	mDataPacketsManagers;
		ONLINESTATE 		mCurrentOnlineStatus;
		ONLINESTATE 		mNextOnlineStatus;

		QList<CFileTransferSend*> 	mFileSends;
		QList<CFileTransferRecive*> 	mFileRecives;
		
		void init();
		void saveUserList();
		void loadUserList();
		void stopCore();
		void restartCore();
		void closeAllActiveConnections();
		void createOpenStreamObjectsForUsers();
		void createStreamObjectForUser(CUser& User);
		void loadUserInfos();

		bool isThisID_a_FileSendID(qint32 ID);
		bool isThisID_a_FileReciveID(qint32 ID);
		

};
#endif