#ifndef FORM_CHATWIDGET_h
#define FORM_CHATWIDGET_h


#include "ui_form_chatwidget.h"
#include "gui_icons.h"
#include "src/Core.h"

#include <QtGui>
#include <Qt>
#include <QClipboard>
#include <QKeyEvent>
#include <QFocusEvent>
#include <QTextBrowser>
#include <QPalette>

class ChatEventEater : public QObject
{
	Q_OBJECT

public:
	ChatEventEater(QWidget *parent = 0) : QObject(parent){ }
	bool m_send_on_enter;
	
signals:
	void sendMessage();
	void haveFocus(bool b);
protected:
	bool eventFilter(QObject *obj, QEvent *event);

};

class CUser;
class form_ChatWidget : public QDialog, public Ui::form_chatwidget
{
Q_OBJECT
public:
	form_ChatWidget(CUser& user,CCore& Core,QDialog* parent = 0);
	~form_ChatWidget();
	void getFocus();
	

private slots:
	void sendMessageSignal();
	void addAllMessages();
	void addMessage(QString text);
	void setTextColor();
	void newMessageRecived();
	void setBold(bool t);
	void setFont();
	void setUnderline(bool t);
	void setItalic(bool t);

	void changeWindowsTitle();
	void newFileTransfer();
	
	void anchorClicked (const QUrl &);
	void focusEvent(bool b);

signals:
	void sendChatMessage(QString chatMessage);
	void closingChatWindow(QString);

private:
	void closeEvent(QCloseEvent *e);
	
	QColor textColor;
	CUser& user;
	QFont  mCurrentFont;
	ChatEventEater *m_event_eater;
	CCore& Core;
	bool mHaveFocus;	
	QTextEdit mControllForChange;
};
#endif
