/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "form_about.h"

form_About::form_About(QString ApplicationVersion, 
		       QString Protoclversion,
		       QString FiletransferversionMin,
		       QString FiletransferversionMax,
		       QWidget *parent)
:QDialog(parent)
{
	ui.setupUi(this);

	mBoteDestination="OU5h3nzo19yo-Q2Oqd7k9d0XgfVcNjSzoZeI~pjyeN-i71UO1-b~g~~y0xw-0w8sPyFHRE~fLuUzem8RhdBak4tYIsCkg-CzLtQ071Kn3-T9j18ts5SxEN1zqTZZVmh58X29nN5xH33OhqlVe0CV3Y8-VFqTA34t-yXRNbebRZPjL6~qxm~oXlw-VCYbNk3fNRsmPlvKUzJysvjZ71UuSfA0qRIkAhYnRn88~ygWFZB~sGgQjbqifGbvpqkXbb~SipsL0hj7Ic2CrSAtGX~dYbNoQSsqRWO8~YrXirWDaMZrfyheAsp4J8Ufd4g~AsUDHVGwxmGWga2mI-WiNF4rLnzTU4WzBURavNbdnTn1euuc1aXzW0-uXgv3-k4mWHvDqrq0B8rpMwzf4vwCMNlLOe3GwVF2mCw-kv2FfYhafTro8twHqGqFwuRCS7nB67S0QBmB4fEO~S4ZnH5nTerlTiSHDhFrDZ132i~54KfzcKeQ4tpsLcDXk92HTz-t8vlO";

	connect(ui.cmd_destCopy,SIGNAL(clicked()),this,
		SLOT(copyDestToClipboard()));

	ui.label_9->setText(ApplicationVersion);
	ui.label_10->setText(Protoclversion);
	//ui.label_11->setText(Filetransferversion);
	ui.label_supportedVersion->setText(FiletransferversionMin+" - "+FiletransferversionMax);
}

form_About::~form_About()
{
}


void form_About::closeEvent(QCloseEvent * e)
{
	e->ignore();
	//this->deleteLater();
	emit closingAboutWindow();
}

void form_About::copyDestToClipboard()
{
	QClipboard *clipboard = QApplication::clipboard();

	clipboard->setText(mBoteDestination);
	QMessageBox::information(this, "",
		"The Destination is in the clipboard",QMessageBox::Close);
}

void form_About::getFocus()
{
	this->activateWindow();
	this->setWindowState((windowState() & (~Qt::WindowMinimized)) | Qt::WindowActive);
	this->raise();
}


