#ifndef FORM_USERSEARCH_H
#define FORM_USERSEARCH_H

#include <QtGui>
#include <QtGlobal> 
#include <QMap>

#include "ui_form_userSearch.h"

#include "src/SeedlessManager.h"
#include "gui/gui_icons.h"

class CCore;
class form_userSearch : public QDialog,private Ui::form_userSearch
{

  Q_OBJECT

  public:
      form_userSearch(CCore&Core,CSeedlessManager& SeedlessManage);
     ~form_userSearch();
      void getFocus();
     
  signals:
      void signClosingUserSearchWindow();
      
  private slots:
      void slot_cmdSearch();
      void slot_SeedlessSearchFinished(QMap<QString,CSeedlessManager::SeedlessSearchStruct> SearchResults);
      void slot_showContextMenu(const QPoint &);
      void slot_addUser();  
      void slot_onlineStateChanged();
      void slot_genderMale();
      void slot_genderFemale();
      
  private:
      CSeedlessManager& mSeedlessManager;  
      CCore&		mCore;
      void init();
      void closeEvent(QCloseEvent *e);
      QMap< QString, CSeedlessManager::SeedlessSearchStruct > mSearchResults;
};
#endif
