#include "form_UserSearch.h"
#include "src/Core.h"



form_userSearch::form_userSearch(CCore&Core,CSeedlessManager& SeedlessManage)
  :mCore(Core),mSeedlessManager(SeedlessManage)
{
    setupUi(this);
    
    treeWidget_SearchResults->setColumnCount(2);
    treeWidget_SearchResults->setHeaderLabels(QStringList()<<"Nicknames"<<"values");
    treeWidget_SearchResults->sortByColumn(0);
    treeWidget_SearchResults->setContextMenuPolicy(Qt::CustomContextMenu);
    
    slot_onlineStateChanged();
    
    connect(cmd_search,SIGNAL(pressed()),this,
	    SLOT(slot_cmdSearch()));
    
    connect(cmd_close,SIGNAL(clicked()),this,
	    SLOT(close()));
    
    connect(checkGender_Female,SIGNAL(clicked()),this,
	    SLOT(slot_genderFemale()));
    
    connect(checkGender_Male,SIGNAL(clicked()),this,
	    SLOT(slot_genderMale()));
	    
    connect(&mSeedlessManager,SIGNAL(signSeedlessSearchResults(QMap<QString,CSeedlessManager::SeedlessSearchStruct>)),this,
	    SLOT(slot_SeedlessSearchFinished(QMap<QString,CSeedlessManager::SeedlessSearchStruct>)));
	    
    connect(treeWidget_SearchResults,SIGNAL(customContextMenuRequested(QPoint)),this,
	    SLOT(slot_showContextMenu(QPoint)));
	    
    connect(&mSeedlessManager,SIGNAL(signSearchState(QString)),label_SearchState,
	    SLOT(setText(QString)));
	    
    connect(&mCore,SIGNAL(signOnlineStatusChanged()),this,
	    SLOT(slot_onlineStateChanged()));
}

form_userSearch::~form_userSearch()
{
}

void form_userSearch::slot_cmdSearch()
{
   CSeedlessManager::SeedlessSearchStruct searchStruct;
   treeWidget_SearchResults->clear();
   label_ResultCount->setText("0");
   label_SearchState->setText("Starting");
    
   searchStruct.NickName=txt_Nickname->text();
   searchStruct.Age=spinBox_Age->value();
   if(checkGender_Female->isChecked()){
      searchStruct.Gender="W";
   }
   else if(checkGender_Male->isChecked()){
      searchStruct.Gender="M";
   }
   else{
      searchStruct.Gender=" ";
   }
   
   searchStruct.Interests=txt_interests->text();
   
   cmd_search->setEnabled(false);
   mSeedlessManager.doSeedlessMessangerSearch(searchStruct);
}

void form_userSearch::init()
{
    spinBox_Age->setMinimum(0);
    spinBox_Age->setMaximum(100);
}
void form_userSearch::closeEvent(QCloseEvent* e)
{
   e->ignore();
   emit signClosingUserSearchWindow(); 
}
void form_userSearch::slot_SeedlessSearchFinished(QMap< QString, CSeedlessManager::SeedlessSearchStruct > SearchResults)
{
    QList<CSeedlessManager::SeedlessSearchStruct> ListResults=SearchResults.values();
    CSeedlessManager::SeedlessSearchStruct currentResult;
    mSearchResults=SearchResults;
    treeWidget_SearchResults->clear();
    
    QTreeWidgetItem *itemTopLevel;
    QTreeWidgetItem *itemNickname;
    QTreeWidgetItem *itemAge;
    QTreeWidgetItem *itemGender;
    QTreeWidgetItem *itemInterests;
    QTreeWidgetItem *itemB32Dest;
    
    
    label_ResultCount->setText(QString::number(SearchResults.count()));


    for(int i=0;i<ListResults.count();i++){
	currentResult=ListResults.at(i);
	itemTopLevel= new QTreeWidgetItem;
	itemNickname= new QTreeWidgetItem;
	itemAge	    = new QTreeWidgetItem;
	itemGender  = new QTreeWidgetItem;
	itemInterests= new QTreeWidgetItem;
	itemB32Dest = new QTreeWidgetItem;
	
	itemTopLevel->setText(0,currentResult.NickName);
	
        itemNickname->setText(0,"Nickname");
	itemNickname->setText(1,currentResult.NickName);
      
	itemAge->setText(0,"Age");
	itemAge->setText(1,QString::number(currentResult.Age));
	
	itemGender->setText(0,"Gender");
	itemGender->setText(1,currentResult.Gender);
	
	itemInterests->setText(0,"Interests");
	itemInterests->setText(1,currentResult.Interests);
	
	itemB32Dest->setText(0,"b32");
	itemB32Dest->setText(1,currentResult.b32Dest);
	//itemB32Dest->setHidden(true);
	
	itemTopLevel->addChild(itemNickname);
	itemTopLevel->addChild(itemAge);
	itemTopLevel->addChild(itemGender);
	itemTopLevel->addChild(itemInterests);
	itemTopLevel->addChild(itemB32Dest);
	
	treeWidget_SearchResults->addTopLevelItem(itemTopLevel);
    }
    if(cmd_search->isEnabled()==false){
	cmd_search->setEnabled(true);
    }
      
}

void form_userSearch::slot_showContextMenu(const QPoint& pos)
{
      QTreeWidgetItem *parent;
      QTreeWidgetItem *item = treeWidget_SearchResults->itemAt(pos);
      if (!item)
         return;
      
      QAction* UserAdd = new QAction(QIcon(ICON_NEWUSER),tr("Add User"),this);
      connect(UserAdd,SIGNAL(triggered()),this,
	      SLOT(slot_addUser()));
      
      QMenu menu(tr("Context menu"), this);
      menu.addAction(UserAdd);
      menu.exec(treeWidget_SearchResults->viewport()->mapToGlobal(pos));
}

void form_userSearch::slot_addUser()
{
    QTreeWidgetItem *item;
    QTreeWidgetItem *parent;
    QString Nickname;
    QString Destination;
    
    item=treeWidget_SearchResults->currentItem();
    if(item!=NULL){
      parent=item->parent();
      if(parent==NULL){
	   parent=item;
      }
    
      Destination=parent->child(4)->text(1);
      CSeedlessManager::SeedlessSearchStruct tmp=mSearchResults.take(Destination);
      
      mSeedlessManager.addNewUser(tmp);
      slot_SeedlessSearchFinished(mSearchResults);
      
     } 
}
void form_userSearch::slot_onlineStateChanged()
{
    ONLINESTATE status=mCore.getOnlineStatus();
    
    if(status!=USEROFFLINE && status!=USERTRYTOCONNECT){
	label_SearchState->setText("Ready");
	cmd_search->setEnabled(true);
    }else{
	label_SearchState->setText("Offline");
	cmd_search->setEnabled(false);
    }
}
void form_userSearch::getFocus()
{
    this->activateWindow();
    this->setWindowState((windowState() & (~Qt::WindowMinimized)) | Qt::WindowActive);
    this->raise();
}
void form_userSearch::slot_genderMale()
{
    if(checkGender_Male->isChecked() && checkGender_Female->isChecked()){
	checkGender_Male->setChecked(false);
    }

}
void form_userSearch::slot_genderFemale()
{
    if(checkGender_Male->isChecked() && checkGender_Female->isChecked()){
      checkGender_Female->setChecked(false);
    }
}


