/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "Core.h"
#include "I2PStream.h"

CCore::CCore()
{
	//mConnectionManager->=NULL;
	
	QSettings settings(QApplication::applicationDirPath()+"/application.ini",QSettings::IniFormat);

	settings.beginGroup("Network");
		mConnectionManager=new CConnectionManager(
				settings.value("SamHost","127.0.0.1").toString(),
				settings.value("SamPort","7656").toString()
				);

		connect (mConnectionManager,SIGNAL(signNamingReplyRecived(const SAM_Message_Types::RESULT, QString, QString, QString)),this,
			SLOT(slotNamingReplyRecived(const SAM_Message_Types::RESULT, QString, QString, QString)),Qt::DirectConnection);
	
		connect (mConnectionManager,SIGNAL(signStreamControllerStatusOK(bool)),this,
			SLOT(slotStreamControllerStatusOK(bool)));
	
		connect (mConnectionManager,SIGNAL(signNewSamPrivKeyGenerated(const QString)),this,
			SLOT(slotNewSamPrivKeyGenerated(const QString)));
	
		connect (mConnectionManager,SIGNAL(signStreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)),this,
			SLOT(slotStreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, QString)));
		
		connect (mConnectionManager,SIGNAL(signIncomingStream(CI2PStream*)),this,
			SLOT(slotIncomingStream(CI2PStream*)));

		connect (mConnectionManager,SIGNAL(signDebugMessages(const QString)),&mDebugMessageHandler,
			SLOT(slotNewIncomingDebugMessage(const QString)));
		
		if(settings.contains("Destination")){
			settings.remove("Destination");
		}
		
	settings.endGroup();
	
	mProtocol= new CProtocol(*this);
	this->mCurrentOnlineStatus=User::USEROFFLINE;

	//if(mUsers.count()==0){
	this->loadUserList();
	//}
	loadUserInfos();
}

CCore::~CCore(){
	this->saveUserList();
	this->closeAllActiveConnections();
	for(int i=0;i<this->mUsers.count();i++)
		delete mUsers.at(i);

		
	QList<CPacketManager*>::Iterator it;
	for(it=mDataPacketsManagers.begin(); it<mDataPacketsManagers.end() ;++it){
		mDataPacketsManagers.erase(it);
	}
	/*
	if(mDebugMessageHandler!=NULL){	
		delete this->mDebugMessageHandler;
	}
	*/
	if(mProtocol!=NULL){
		delete this->mProtocol;
	}
/*
	if(mConnectionManager->!=NULL) {
		delete this->CmConnectionManager->;
	}
*/
	delete mConnectionManager;

}

CDebugMessageManager* CCore::getDebugMessageHandler(){
	return &mDebugMessageHandler;
}

bool CCore::addNewUser(QString Name,QString I2PDestination,qint32 I2PStream_ID,bool SaveUserList){
	//check if user already exist
	if(I2PDestination.length()!=516){
		//Destination must be 516 length
		qCritical()<<"CCore::addNewUser"
			   <<"\n\tDestination must be 516 length"
			   <<"\n\tlength : "<<I2PDestination.length()
			   <<"\n\taction add new User ignored";
		return false;
	}
	
	
	if(!I2PDestination.right(4).contains("AAAA",Qt::CaseInsensitive)){
		//the last 4 char must be "AAAA"
		qCritical()<<"\nCCore::addNewUser"
			   <<"\n\tthe last 4 char must be AAAA"
			   <<"\n\tDestination:\n"<<I2PDestination
			   <<"\n\taction add new User ignored";
		return false;
	}


	
	if(this->doesUserAllReadyExitsByI2PDestination(I2PDestination)==true){
			qCritical()<<"\nCCore::addNewUser"
			   <<"\n\tthere is allready a user with this destination"
			   <<"\n\taction add new User ignored";

			return false;
	}

	if(I2PDestination==mMyDestination){
		qCritical()<<"\nCCore::addNewUser"
		<<"\n\tIt's not allowed to add your self"
		<<"\n\taction add new User ignored";

		return false;
	}
	

	//add newuser
	CUser* newuser=new CUser(*mProtocol,Name,I2PDestination,I2PStream_ID);
	connect(newuser,SIGNAL(signNewIncomingMessageRecived()),&mSoundManager,
		SLOT(slotNewChatMessage()));

	connect(newuser,SIGNAL(signConnectionOnline()),&mSoundManager,
		SLOT(slotUserGoOnline()));

	connect(newuser,SIGNAL(signConnectionOffline()),&mSoundManager,
		SLOT(slotUserGoOffline()));

	connect(newuser,SIGNAL(signOnlineStateChanged()),this,
		SIGNAL(signUserStatusChanged()));


	this->mUsers.append(newuser);
	if(SaveUserList==true){
		saveUserList();
	}

	if(mCurrentOnlineStatus!=USEROFFLINE && mCurrentOnlineStatus!=USERTRYTOCONNECT){
		if(I2PStream_ID==0){
			createStreamObjectForUser(*newuser);
		}
	}
	emit signUserStatusChanged();
	return true;
}

bool CCore::deleteUserByI2PDestination(QString I2PDestination){
	for(int i=0;i<mUsers.count();i++){
		if(mUsers.at(i)->getI2PDestination()==I2PDestination){
			if(mUsers.at(i)->getConnectionStatus()==ONLINE ||mUsers.at(i)->getConnectionStatus()==TRYTOCONNECT){
				deletePacketManagerByID(mUsers.at(i)->getI2PStreamID());
				mConnectionManager->doDestroyStreamObjectByID(mUsers.at(i)->getI2PStreamID());
			}
			
			if(mConnectionManager->isComponentStopped()==false){
				mConnectionManager->doDestroyStreamObjectByID(mUsers.at(i)->getI2PStreamID());
			}

			mUsers.removeAt(i);
			saveUserList();
			emit signUserStatusChanged();
			return true;
		}
	}
	return false;
}


bool CCore::doesUserAllReadyExitsByI2PDestination(const QString I2PDestination){
	if(I2PDestination==mMyDestination) return true;

	for(int i=0;i<mUsers.count();i++){
		if(mUsers.at(i)->getI2PDestination()==I2PDestination){
			
			return true;
		}
	}
	
	return false;
}
void CCore::doNamingLookUP(QString Name){
	mConnectionManager->doNamingLookUP(Name);
}

void CCore::init(){
	using namespace SESSION_ENUMS;

	this->mMyDestination="";
	

	QSettings settings(QApplication::applicationDirPath()+"/application.ini",QSettings::IniFormat);
	settings.beginGroup("Network");

	QString SamPrivKey=settings.value("SamPrivKey","").toString();

	//if(mConnectionManager->==NULL){
		//QString SamPrivKey;
		//SamPrivKey=settings->value("SamPrivKey","").toString();
		/*
		this->mConnectionManager->= new mConnectionManager->(
						settings->value("SamHost","127.0.0.1").toString(),
						settings->value("SamPort","7656").toString());
		*/
		/*
		if(mDebugMessageHandler==NULL){
			this->mDebugMessageHandler= new cDebugMessageManager(mConnectionManager);
		}
		else{
			this->mDebugMessageHandler->reInit(mConnectionManager);
		}
		*/
		if(mConnectionManager->isComponentStopped()==true){
			mConnectionManager->doReStart();
		}

		mConnectionManager->doCreateSession(
			STREAM,
			SamPrivKey,
			settings.value("SessionOptionString","inbound.nickname=I2P-Messenger inbound.quantity=1 inbound.backupQuantity=1 inbound.length=1 outbound.quantity=1 outbound.backupQuantity=1 outbound.length=1").toString());

	//}
	settings.endGroup();
}
void CCore::saveUserList(){
     QFile file(QApplication::applicationDirPath()+"/users.config");
     file.open(QIODevice::WriteOnly | QIODevice::Text);
     QTextStream out(&file);
     QString InvisibleText;

	for(int i=0;i<this->mUsers.count();i++){
		if(mUsers.at(i)->getIsInvisible()==true){
			InvisibleText="true";
		}
		else{
			InvisibleText="false";
		}

		
		out<<"Nick:\t"<<(mUsers.at(i)->getName())<<endl
		   <<"I2PDest:\t"<<(mUsers.at(i)->getI2PDestination())<<endl
		   <<"Invisible:\t"<<InvisibleText<<endl;
	}
	out.flush();
	file.close();
}
void CCore::loadUserList(){
	QFile file(QApplication::applicationDirPath()+"/users.config");
     	if (!file.open(QIODevice::ReadOnly|QIODevice::Text))
		return;

 	QTextStream in(&file);
	in.skipWhiteSpace();
	QString NickName;QString I2PDest;
     	while (!in.atEnd()) {
		QString line = in.readLine();
		QStringList temp=line.split("\t");
	
		if(temp[0]=="Nick:")NickName=temp[1];	
		if(temp[0]=="I2PDest:"){
			I2PDest=temp[1];
			this->addNewUser(NickName,I2PDest,false);
		}
		if(temp[0]=="Invisible:"){
			if(temp[1]=="true"){
				getUserByI2P_Destination(I2PDest)->setInvisible(true);
			}
		}
		else if(temp[0]=="TorDest:"){
			//ignore it
		}
	file.close();	
	}
}

void CCore::slotStreamStatusRecived(const SAM_Message_Types::RESULT result,const qint32 ID,QString Message){

	CI2PStream* stream=(CI2PStream*)mConnectionManager->getStreamObjectByID(ID);
	CUser* user=NULL;
	QString Destination;

	if(stream==NULL){
		//Stream where delete,- asyn SIGNAL/SLOT
		return;
	}

	if(stream!=NULL){
		Destination=stream->getDestination();
		user=this->getUserByI2P_ID(ID);
	}

	if(result==SAM_Message_Types::OK && ID>0){
		if(isThisID_a_FileSendID(ID)==false){
			mProtocol->newConnectionChat(ID);
		}
	}
	else if( result==SAM_Message_Types::CANT_REACH_PEER || 
			result==SAM_Message_Types::TIMEOUT
		){
		if(user==NULL){
			DestroyStreamObjectByID(ID);
			return;
		}
		else{
			if(user->getOnlineState()!=USEROFFLINE && user->getOnlineState()!=USERTRYTOCONNECT){
				user->IncomingMessageFromSystem("The Connection is broken: "+Message+"\nConnection closed");
			}
			deletePacketManagerByID(ID);
			user->setConnectionStatus(TRYTOCONNECT);
			user->setOnlineState(USEROFFLINE);
			//reconnect stream
		}
	}
	else if( result==SAM_Message_Types::CLOSED){
		if(ID<0){
			//incoming stream
			QString Destination=stream->getDestination();

			//remove old stream
				deletePacketManagerByID(ID);
				DestroyStreamObjectByID(ID);
			//---------------------------

			if(user!=NULL && user->getI2PStreamID()==ID){
				user->setConnectionStatus(OFFLINE);
				user->setOnlineState(USEROFFLINE);
				//create a new outgoing stream for this user
				createStreamObjectForUser(*user);
			}
		}
		else{//ID>0
			//outgoing stream
			if(user!=NULL){
				user->setConnectionStatus(TRYTOCONNECT);
				user->setOnlineState(USEROFFLINE);
			}
			stream->setConnectionType(UNKNOWN);

			deletePacketManagerByID(ID);
			
			connect(stream,SIGNAL(signDataRecived(const qint32, const QByteArray)),mProtocol,
				SLOT(slotInputUnknown(const qint32, const QByteArray)));

			
		}
	}


	else if(result==SAM_Message_Types::INVALID_KEY){
		if(user==NULL){
			DestroyStreamObjectByID(ID);
			return;
		}	
		user->IncomingMessageFromSystem("Invalid User - Destination: please delete the user\n");
		deletePacketManagerByID(ID);
		DestroyStreamObjectByID(ID);
		user->setConnectionStatus(ERROR);

	}
	else if(result==SAM_Message_Types::I2P_ERROR){
		if(user==NULL){
			DestroyStreamObjectByID(ID);
			return;
		}
		user->IncomingMessageFromSystem("I2P_Error: "+Message);
		deletePacketManagerByID(ID);
		DestroyStreamObjectByID(ID);
		user->setConnectionStatus(ERROR);
	}

	emit signUserStatusChanged();
}

void CCore::setUserProtocolVersionByStreamID(qint32 ID,QString Version){

	for(int i=0;i< mUsers.size();i++)
		if(mUsers.at(i)->getI2PStreamID()==ID){
			mUsers.at(i)->setProtocolVersion(Version);
			
			return;
		}
	
}

const QList<CUser*> CCore::getUserList(){
	return mUsers;
}

void CCore::closeAllActiveConnections(){
	//close all known Online||TrytoConnect Connections

	for(int i=0;i<mUsers.size();i++){
		if(mUsers.at(i)->getConnectionStatus()==ONLINE ||
			mUsers.at(i)->getConnectionStatus()==TRYTOCONNECT)
		{
			deletePacketManagerByID(mUsers.at(i)->getI2PStreamID());
			DestroyStreamObjectByID(mUsers.at(i)->getI2PStreamID());
			mUsers.at(i)->setConnectionStatus(User::OFFLINE);
			mUsers.at(i)->setOnlineState(USEROFFLINE);
				
		}
	}

	emit signUserStatusChanged();
}


CUser* CCore::getUserByI2P_ID(qint32 ID){

	for(int i=0;i<mUsers.size();i++){
		if(mUsers.at(i)->getI2PStreamID()==ID){
			
			return mUsers.at(i);
		}
	}
	
	return NULL;
}
CUser* CCore::getUserByI2P_Destination(QString Destination){

	for(int i=0;i<mUsers.size();i++){
		if(mUsers.at(i)->getI2PDestination()==Destination){
			
			return mUsers.at(i);
		}
	}
	
	return NULL;
}
void CCore::slotNamingReplyRecived(const SAM_Message_Types::RESULT result,QString Name,QString Value,QString Message){
	if(result==SAM_Message_Types::OK && Name=="ME")
		this->mMyDestination=Value;
}
const QString CCore::getMyDestination()const{
	return this->mMyDestination;
}
	
void CCore::deletePacketManagerByID(qint32 ID){

	const CI2PStream* Stream=NULL;
	if(mConnectionManager->isComponentStopped()==false){
		Stream=mConnectionManager->getStreamObjectByID(ID);
	}
	
	QList<CPacketManager*>::Iterator it;
	for(it=mDataPacketsManagers.begin(); it!=mDataPacketsManagers.end() ;++it){
		if((*(it))->getID()==ID){
			//delete (*(it));
			if(Stream!=NULL){
				disconnect(Stream,SIGNAL(signDataRecived(const qint32, const QByteArray)),(*(it)),
				SLOT(slotDataInput(qint32, QByteArray)));
			}

			mDataPacketsManagers.erase(it);
			break;
			
		}
	}

}

QString CCore::getConnectionDump(){
	QString Message;
	QString StreamControllerBridgeName;

	if(mConnectionManager->isComponentStopped()==true){
		Message="The Core is stopped !";
		return Message;
	}
	StreamControllerBridgeName=mConnectionManager->getStreamControllerBridgeName();

	Message="< Stream Controller >\n";
	Message+="\tNetwork:\tI2P\n";
	Message+="\tStreamControllerBridgeName:\t"+StreamControllerBridgeName+"\n";
	Message+="-----------------------------------------------\n\n";


	Message+="< Streams >\n";
	const QMap<qint32,CI2PStream*>* allStreams=mConnectionManager->getAllStreamObjects();
	const QList<CI2PStream*> allStreamsList=allStreams->values();
	


	for(int n=0;n<allStreamsList.size();n++){
		
		CI2PStream* Stream=allStreamsList.value(n);
		QString StreamID;
		CUser* theUser=NULL;
		
		StreamID.setNum(Stream->getID(),10);

		Message+="\n\tStreamID:\t"+StreamID+"\n";

		//Print StreamMode
		if(Stream->getStreamMode()==STREAMS::CONNECT){
			Message+="\tStreamMode:\tCONNECT\n";
		}
		else if(Stream->getStreamMode()==STREAMS::ACCEPT){
			Message+="\tStreamMode:\tACCEPT\n";
		}
		else{
			Message+="\tStreamMode:\t???\n";
		}
		//-----------------------------------------
	
			//Print ConnectionType		
			if(Stream->getConnectionType()==UNKNOWN){
				Message+="\tConnectionTrust:\tUNKNOWN\n";
			}
			else if (Stream->getConnectionType()==KNOWN){
				Message+="\tConnectionTrust:\tKNOWN\n";
			}
			else{
				Message+="\tConnectionTrust:\t???\n";
			}
			//------------------------------------------
		
		
		theUser=getUserByI2P_ID(Stream->getID());
		if(theUser==NULL){
			Message+="\tUser: \n";
		}
		else{
			Message+="\tUser:\t\t"		+theUser->getName()+"\n";
			Message+="\tClientName:\t\t"	+theUser->getClientName()+"\n";
			Message+="\tClientVersion:\t\t"	+theUser->getClientVersion()+"\n";
			Message+="\tProtocolVersion:\t" +theUser->getProtocolVersion()+"\n";
		}

	}
	Message+="-----------------------------------------------\n\n";

	return Message;
}

bool CCore::renameUserByI2PDestination(const QString Destination, const QString newNickname){
	for(int i=0;i<mUsers.size();i++){
		if(mUsers.at(i)->getI2PDestination()==Destination){
			mUsers.at(i)->setName(newNickname);
			saveUserList();
			emit signUserStatusChanged();
			return true;
		}
	}
	return false;
}

ONLINESTATE CCore::getOnlineStatus() const
{
	return this->mCurrentOnlineStatus;
}

void CCore::setOnlineStatus(const ONLINESTATE newStatus)
{
	if(mCurrentOnlineStatus==newStatus) return;

	if(mCurrentOnlineStatus==USEROFFLINE){		
		mNextOnlineStatus=newStatus;
		mCurrentOnlineStatus=USERTRYTOCONNECT;
		init();
		emit signOnlineStatusChanged();
		return;
	}
	

	if(newStatus==User::USEROFFLINE){
		this->mCurrentOnlineStatus=newStatus;
		stopCore();
	}
	else if(newStatus==USERTRYTOCONNECT){
		if(mCurrentOnlineStatus==USEROFFLINE)
		{
			this->mCurrentOnlineStatus=newStatus;
			restartCore();	
		}
	}
	else
	{
		//send new Status to every connected User
		this->mCurrentOnlineStatus=newStatus;

		for(int i=0;i<mUsers.size();i++){
			if(mUsers.at(i)->getIsInvisible()==true){
				mProtocol->send(USER_ONLINESTATUS_OFFLINE,mUsers.at(i)->getI2PStreamID(),QString(""));
			}else{
				if(mUsers.at(i)->getConnectionStatus()==ONLINE)
				{
					switch(this->mCurrentOnlineStatus)
					{
						case USERONLINE:
						{
							mProtocol->send(USER_ONLINESTATUS_ONLINE,mUsers.at(i)->getI2PStreamID(),QString(""));
							break;
						}
						case USEROFFLINE:
						{
							break;
						}
						case USERINVISIBLE:
						{
							mProtocol->send(USER_ONLINESTATUS_OFFLINE,mUsers.at(i)->getI2PStreamID(),QString(""));
							break;
						}
						case USERAWAY:
						{
							mProtocol->send(USER_ONLINESTATUS_AWAY,mUsers.at(i)->getI2PStreamID(),QString(""));
							break;
							
						}
						case USERWANTTOCHAT:
						{
							mProtocol->send(USER_ONLINESTATUS_WANTTOCHAT,mUsers.at(i)->getI2PStreamID(),QString(""));
							break;
						}
						case USERDONT_DISTURB:
						{
							mProtocol->send(USER_ONLINESTATUS_DONT_DISTURB,mUsers.at(i)->getI2PStreamID(),QString(""));
							break;
						}
						case USERTRYTOCONNECT:
						{
							break;
						}
						default:
						{
							QMessageBox* msgBox= new QMessageBox(NULL);
							msgBox->setIcon(QMessageBox::Warning);
							msgBox->setText("CCore(setOnlineStatus)");
							msgBox->setInformativeText("Unknown USERSTATE");
							msgBox->setStandardButtons(QMessageBox::Ok);
							msgBox->setDefaultButton(QMessageBox::Ok);
							msgBox->setWindowModality(Qt::NonModal);
							msgBox->show();
		
						}
					}	
				}//if
			}//else
		}//for
	}
	emit signOnlineStatusChanged();
}

void CCore::stopCore()
{
	closeAllActiveConnections();

	//delete mConnectionManager->;
	//mConnectionManager->=NULL;
	mConnectionManager->doStopp();
}

void CCore::restartCore()
{
	this->init();
}

void CCore::addNewFileTransfer(QString FilePath, QString Destination)
{

	bool ok=false;
	QString Protocolversion;
	double  ProtoVersionD;

	CUser* User=getUserByI2P_Destination(Destination);
	if(User!=NULL){
		Protocolversion=User->getProtocolVersionFiletransfer();
		ProtoVersionD  =User->getProtocolVersionFiletransfer_D();
	}

	CFileTransferSend * t= new CFileTransferSend(*this,*mConnectionManager,FilePath,Destination,Protocolversion,ProtoVersionD);
	connect (t,SIGNAL(signFileTransferFinishedOK()),&mSoundManager,
		SLOT(slotFileSendFinished()));

	mFileSends.append(t);
	emit signUserStatusChanged();
}

bool CCore::isThisID_a_FileSendID(qint32 ID)
{
	for(int i=0;i<mFileSends.size();i++){
		if(mFileSends.at(i)->getStreamID()==ID){
			return true;
		}
	}
	return false;
}

bool CCore::isThisID_a_FileReciveID(qint32 ID)
{
	for(int i=0;i<mFileRecives.size();i++){
		if(mFileRecives.at(i)->getStreamID()==ID){
			return true;
		}
	}
	return false;
}

void CCore::addNewFileRecive(qint32 ID, QString FileName, QString FileSize,QString Destination,QString ProtocolVersion)
{	
	CI2PStream* Stream=(CI2PStream*)mConnectionManager->getStreamObjectByID(ID);

	double ProtocolVersionD;
	quint64 Size;
	bool OK;
	Size=FileSize.toULongLong(&OK,10);
	if(OK==false)
	{
		QMessageBox* msgBox= new QMessageBox(NULL);
		msgBox->setIcon(QMessageBox::Critical);
		msgBox->setText("CCore(addNewFileRecive)");
		msgBox->setInformativeText("Error convert QString to Quint64\nValue: "+FileSize +"\nFilerecive aborted");
		msgBox->setStandardButtons(QMessageBox::Ok);
		msgBox->setDefaultButton(QMessageBox::Ok);
		msgBox->setWindowModality(Qt::NonModal);
		msgBox->show();

		//abort the Filerecive
		Stream->operator <<(QString("1"));//false
		mConnectionManager->doDestroyStreamObjectByID(ID);
		removeFileRecive(ID);

		return;
	}
	ProtocolVersionD=ProtocolVersion.toDouble(&OK);
	if(OK==false){
		qDebug()<<"CCore::addNewFileRecive()"<<"Can't convert QSting to double"<<"QString: ProtocolVersion";
		
		//abort the Filerecive
		Stream->operator <<(QString("1"));//false
		mConnectionManager->doDestroyStreamObjectByID(ID);
		removeFileRecive(ID);
		return;
	}

	if(ProtocolVersionD > FileTransferProtocol::PROTOCOLVERSION_D){
		//Show Info Message 
		CUser* User=getUserByI2P_Destination(Destination);
		if(User!=NULL){
			User->IncomingMessageFromSystem("Ignore Incoming Filetransfer, " \
				"not supported Filetransferprotocolversion\n" \
				"Incoming Protocolversion: "+ProtocolVersion+"\n" \
				"Highest supported Protocolversion: "+FileTransferProtocol::PROTOCOLVERSION+"\n" \
				"Filename: "+FileName);
		}

		//abort the Filerecive
		Stream->operator <<(QString("1"));//false
		mConnectionManager->doDestroyStreamObjectByID(ID);
		removeFileRecive(ID);
		return;
	}


	mSoundManager.slotFileReciveIncoming();
	
	disconnect(Stream,SIGNAL(signStreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)),this,
		SLOT(slotStreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, QString)));
	
	CFileTransferRecive* t= new CFileTransferRecive(*this,*Stream,ID,FileName,Size,Destination,ProtocolVersion,ProtocolVersionD);
	connect(t,SIGNAL(signFileRecivedFinishedOK()),&mSoundManager,
		SLOT(slotFileReciveFinished()));

	connect(t,SIGNAL(signFileNameChanged()),this,
		SIGNAL(signUserStatusChanged()));

	mFileRecives.append(t);
	emit signUserStatusChanged();

}

bool CCore::checkIfAFileTransferOrReciveisActive()
{
	if(mFileSends.count()>0) return true;
	if(mFileRecives.count()>0) return true;

	return false;
}

void CCore::MuteSound(bool t)
{
	mSoundManager.doMute(t);
}

QString CCore::getDestinationByID(qint32 ID)
{
	for(int i=0;i<mUsers.size();i++){
		if(mUsers.at(i)->getI2PStreamID()==ID){
			return mUsers.at(i)->getI2PDestination();
		}
	}

	for(int i=0;i<mFileSends.size();i++){
		if(mFileSends.at(i)->getStreamID()==ID){
			return mFileSends.at(i)->getDestination();
		}
	}
	
	for(int i=0;i<mFileRecives.size();i++){
		if(mFileRecives.at(i)->getStreamID()==ID){
			return mFileRecives.at(i)->getDestination();
		}
	}

	return "";
}



const QList< CFileTransferRecive * > CCore::getFileTransferReciveList()
{
	return mFileRecives;
}

CFileTransferRecive * CCore::getFileTransferReciveByID(qint32 ID)
{
	for(int i=0;i<mFileRecives.size();i++){
		if(mFileRecives.at(i)->getStreamID()==ID){
			return mFileRecives.at(i);
		}
	}
	return NULL;
}

const QList< CFileTransferSend * > CCore::getFileSendsList()
{
	return mFileSends;
}

CFileTransferSend * CCore::getFileSendsByID(qint32 ID)
{
	for(int i=0;i<mFileSends.size();i++){
		if(mFileSends.at(i)->getStreamID()==ID){
			return mFileSends.at(i);
		}
	}
	return NULL;
}

QString CCore::getUserInfosByI2P_Destination(QString Destination)
{
	QString Infos="No Informations recived";

	for(int i=0;i<mUsers.size();i++){
		if(mUsers.at(i)->getI2PDestination()==Destination){
			CUser* theUser=mUsers.at(i);

			Infos= "Nickname:\t\t"  		+theUser->getName()+"\n";
			Infos+="Clientname:\t\t"		+theUser->getClientName()+"\n";
			Infos+="Clientversion:\t\t"		+theUser->getClientVersion()+"\n";
			Infos+="Protocolversion:\t"		+theUser->getProtocolVersion()+"\n";
			Infos+="Protocolversion (Filetransfer):"+theUser->getProtocolVersionFiletransfer()+"\n";

			if(theUser->getProtocolVersion_D()>=0.3){
				CRecivedInfos recivedInfos=theUser->getRecivedUserInfos();
				QString sAge;
				sAge.setNum(recivedInfos.Age,10);

				Infos+="\nRecived Userinfos:\n";
				Infos+="Nickname:\t\t"		+recivedInfos.Nickname+"\n";
				Infos+="Gender:\t\t"		+recivedInfos.Gender+"\n";
				Infos+="Age:\t\t"		+sAge+"\n";
				Infos+="Interests:\t\t"		+recivedInfos.Interests;
			}
		}
	}
	return Infos;
}

void CCore::changeUserPositionInUserList(int oldPos, int newPos)
{
	mUsers.swap(oldPos,newPos);
	saveUserList();
	emit signUserStatusChanged();
}

void CCore::slotStreamControllerStatusOK(bool Status)
{
	if(Status==true){
		mCurrentOnlineStatus=mNextOnlineStatus;
		emit signOnlineStatusChanged();
		mConnectionManager->doNamingLookUP("ME");//get the current Destination from this client
		createOpenStreamObjectsForUsers();
	}

}


void CCore::createOpenStreamObjectsForUsers()
{
	for(int i=0;i<mUsers.size();i++){
		if(mConnectionManager->isComponentStopped()==false){
			this->createStreamObjectForUser(*(mUsers.at(i)));
		}
	}

}

void CCore::setStreamTypeToKnown(qint32 ID,const QByteArray Data,bool isFileTransfer_Recive)
{
	CI2PStream* t=(CI2PStream*)mConnectionManager->getStreamObjectByID(ID);
	t->setConnectionType(KNOWN);
	disconnect(t,SIGNAL(signDataRecived(const qint32, const QByteArray)),mProtocol,
		SLOT(slotInputUnknown(const qint32, const QByteArray)));
	
	if(isFileTransfer_Recive==false){
		CPacketManager* packetManager= new CPacketManager(*mConnectionManager,ID);
		connect(t,SIGNAL(signDataRecived(const qint32, const QByteArray)),packetManager,
			SLOT(slotDataInput(qint32, QByteArray)));
		
		connect(packetManager,SIGNAL(signAPacketIsCompleate(const qint32, const QByteArray)),mProtocol,
			SLOT(slotInputKnown(const qint32, const QByteArray)));

		if(Data.isEmpty()==false){
			packetManager->slotDataInput(ID,Data);
		}
		mDataPacketsManagers.push_back(packetManager);
		
		
	}
	if(isFileTransfer_Recive==true){

	}

}

void CCore::DestroyStreamObjectByID(qint32 ID)
{
	mConnectionManager->doDestroyStreamObjectByID(ID);
}

const CI2PStream * CCore::getI2PStreamObjectByID(qint32 ID)
{
	return mConnectionManager->getStreamObjectByID(ID);
}

void CCore::slotIncomingStream(CI2PStream * stream)
{
	//all incoming stream are first Unknown
	connect(stream,SIGNAL(signDataRecived(const qint32, const QByteArray)),mProtocol,
			SLOT(slotInputUnknown(const qint32, const QByteArray)));
}

void CCore::createStreamObjectForUser(CUser& User)
{
	qint32 msec=0;
	qint32 ID=User.getI2PStreamID();

	if(mConnectionManager->isComponentStopped()==true) return;

	if(mConnectionManager->getStreamObjectByID(ID)!=NULL){
		return;
	}

	QSettings* settings= new QSettings(QApplication::applicationDirPath()+"/application.ini",QSettings::IniFormat);
	settings->beginGroup("General");
		msec=settings->value("Waittime_between_rechecking_offline_mUsers","30000").toInt();
	settings->endGroup();

	CI2PStream* t =(CI2PStream*)mConnectionManager->doCreateNewStreamObject(CONNECT);
	connect(t,SIGNAL(signStreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)),this,
		SLOT(slotStreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, QString)));

	User.setI2PStreamID(t->getID());
			
	if(t!=NULL){
		connect(t,SIGNAL(signDataRecived(const qint32, const QByteArray)),mProtocol,
			SLOT(slotInputUnknown(const qint32, const QByteArray)));
		t->doConnect(User.getI2PDestination());
		t->startUnlimintedReconnect(msec);
	}
	delete settings;
}

void CCore::removeFileTransfer(const qint32 ID)
{
	if(mFileSends.count()>0){
		for(int i=0;i<mFileSends.count();i++){
			if(mFileSends.at(i)->getStreamID()==ID){
				mFileSends.removeAt(i);
				emit signUserStatusChanged();
				break;
			}
		}	
	}
	
}

void CCore::removeFileRecive(const qint32 ID)
{	
	if(mFileRecives.count()>0){
		for(int i=0;i<mFileRecives.count();i++){
			if(mFileRecives.at(i)->getStreamID()==ID){
				mFileRecives.removeAt(i);
				emit signUserStatusChanged();
				break;
			}
		}
	}

}

void CCore::slotNewSamPrivKeyGenerated(const QString SamPrivKey)
{
	QSettings* settings= new QSettings(QApplication::applicationDirPath()+"/application.ini",QSettings::IniFormat);
	settings->beginGroup("Network");
		settings->setValue("SamPrivKey",SamPrivKey);
	settings->endGroup();
	delete settings;
}

bool CCore::UseThisChatConnection(const QString Destination, const qint32 ID)
{
	CUser* theUser=NULL;

	theUser=getUserByI2P_Destination(Destination);
	if(theUser!=NULL){
	//check if connection to user allready exist
		if(theUser->getI2PStreamID()!=ID){
			if(theUser->getConnectionStatus()==ONLINE){
				//close the new connection,- we have allready a connection to this user
				DestroyStreamObjectByID(ID);
				return false;
			}
			else if(theUser->getConnectionStatus()==TRYTOCONNECT){
				//use the new connection
				//close the TRYTOCONNECT connection
				deletePacketManagerByID(theUser->getI2PStreamID());
				DestroyStreamObjectByID(theUser->getI2PStreamID());
				theUser->setI2PStreamID(ID);
				return true;
			}
		}
	}	
	return true;
}

void CCore::loadUserInfos()
{
	QSettings settings(QApplication::applicationDirPath()+"/application.ini",QSettings::IniFormat);
	settings.beginGroup("User-Infos");
		mUserInfos.Nickname=	settings.value("Nickname","").toString();
		mUserInfos.Age=		settings.value("Age","0").toInt();
		mUserInfos.Interests=	settings.value("Interests","").toString();

		if(settings.value("Gender","").toString()=="Male"){
			mUserInfos.Gender="Male";
		}
		else if(settings.value("Gender","").toString()=="Female"){
			mUserInfos.Gender="Female";
		}		
	settings.endGroup();
}

const CRecivedInfos CCore::getUserInfos() const
{
	return mUserInfos;
}




