#ifndef FORM_CHATWIDGET_h
#define FORM_CHATWIDGET_h


#include "ui_form_chatwidget.h"
#include "gui_icons.h"
#include "src/Core.h"

#include <QtGui>
#include <Qt>
#include <QClipboard>
#include <QKeyEvent>
class ChatEventEater : public QObject
{
	Q_OBJECT

public:
	ChatEventEater(QWidget *parent = 0) : QObject(parent){ }
	bool m_send_on_enter;
	
signals:
	void sendMessage();
protected:
	bool eventFilter(QObject *obj, QEvent *event);

};

class CUser;
class form_ChatWidget : public QMainWindow, public Ui::form_chatwidget
{
Q_OBJECT
public:
	form_ChatWidget(CUser& user,CCore& Core,QWidget* parent = 0);
	

private slots:
	void sendMessageSignal();
	void addAllMessages();
	void addMessage(QString text);
	void setTextColor();
	void newMessageRecived();
	void setBold(bool t);
	void setFont();
	void WorkAround();
	void changeWindowsTitle();
	void newFileTransfer();
	
	void anchorClicked (const QUrl &);

signals:
	void sendChatMessage(QString chatMessage);

private:
	void closeEvent(QCloseEvent *e);
	QColor textColor;
	CUser& user;
	QFont  mCurrentFont;
	ChatEventEater *m_event_eater;
	CCore& Core;
};
#endif
