#include "gui/form_chatwidget.h"
#include "src/User.h"

bool ChatEventEater::eventFilter(QObject *obj, QEvent *event)
{
	if ( event->type() == QEvent::KeyPress )
	{
        QKeyEvent *keyEvent = static_cast<QKeyEvent *>(event);
        if ( obj->objectName() == "message")
        {
        	if ( keyEvent->key() == Qt::Key_Return && keyEvent->modifiers() == Qt::NoModifier)
        	{
        		emit sendMessage();
        		return true;
        	}
        	else if (keyEvent->key() == Qt::Key_Return 
        			&& keyEvent->modifiers() == Qt::ControlModifier)
        	{
        		emit sendMessage();
        		return true;
        	}
	}
	return QObject::eventFilter(obj, event);
	}

	return false;
}


form_ChatWidget::form_ChatWidget(CUser& user,CCore& Core,QWidget* parent /* = 0 */)
: user(user),Core(Core),QMainWindow(parent)
{

	setupUi(this);
	//this->setAttribute(Qt::WA_DeleteOnClose,true);


	user.setHaveAllreadyOneChatWindow(true);

	QTextEdit *message=this->message;

	m_event_eater = new ChatEventEater(this);
    	connect(m_event_eater, SIGNAL(sendMessage()),
    		send, SLOT(click()));

	message->installEventFilter(m_event_eater);

	connect(&user,SIGNAL(signNewMessageRecived()),this,
		SLOT(newMessageRecived()));

	connect(&user,SIGNAL(signOnlineStateChanged()),this,
		SLOT(changeWindowsTitle()));

	connect(this,SIGNAL(sendChatMessage(QString)),&user,
		SLOT(slotSendChatMessage(QString)));

	connect(message,SIGNAL(cursorPositionChanged()),this,
		SLOT(WorkAround()));	

	connect(cmd_SendFile,SIGNAL(clicked()),this,
		SLOT(newFileTransfer()));

	connect(chat, SIGNAL(anchorClicked(const QUrl &)), SLOT(anchorClicked(const QUrl &)));
		
  	mCurrentFont = user.getTextFont();
	textColor = user.getTextColor();


	QPixmap pxm(22,22);
	pxm.fill(textColor);
	//txtColor->setIcon(pxm);
	
	
	connect(send, SIGNAL(clicked()), SLOT(sendMessageSignal()));
	connect(txtColor, SIGNAL(clicked()), SLOT(setTextColor()));
	connect(txtBold, SIGNAL(clicked(bool)),SLOT(setBold(bool)));
	connect(txtFont, SIGNAL(clicked()), SLOT(setFont()));
	
	message->setTextColor(textColor);
	//message->setCurrentFont(mCurrentFont);
	message->setFont(mCurrentFont);
	//message->setFontItalic(true);
	//message->setFontUnderline(true);


	resize(450,400);
	changeWindowsTitle();
	addAllMessages();
	QScrollBar *sb=chat->verticalScrollBar();

	sb->setValue(sb->maximum());

}

void form_ChatWidget::newMessageRecived(){
	QTextEdit *chat=this->chat;
	QScrollBar *sb=chat->verticalScrollBar();

	
	int oldVerticalScrollBarValue=sb->value();
	int VerticalScrollBarMax=sb->maximum();
	bool restoreOldVerticalScrollBarValue=false;

	if(oldVerticalScrollBarValue != VerticalScrollBarMax){
		restoreOldVerticalScrollBarValue=true;
	}

	QStringList Messages=user.getNewMessages();
	int i=0;
	QString test;	
	while(i<Messages.count()){
		 test=Messages.at(i);
		this->addMessage(test);
		i++;
	}
	
	if(restoreOldVerticalScrollBarValue==true){
		sb->setValue(oldVerticalScrollBarValue);
	}
	else{
		sb->setValue(sb->maximum());
	}
}

void form_ChatWidget::addAllMessages(){
	QTextEdit *chat=this->chat;
	QScrollBar *sb=chat->verticalScrollBar();
	chat->clear();

	QStringList Messages=user.getAllChatMessages();
	int i=0;	
	while(i<Messages.count()){
		QString test =Messages.at(i);
		this->addMessage(test);
		i++;
	}
	
	sb->setValue(sb->maximum());
}


void form_ChatWidget::addMessage(QString text){
	QTextEdit *chat=this->chat;
	QTextCursor cursor = chat->textCursor();

	//replace http://, https:// and www. with <a href> links
	QRegExp rx("(https?://[^ <>]*)|(www\\.[^ <>]*)");
	int count = 0;
  	int pos = 100; //ignore the first 100 char because of the standard DTD ref
	while ( (pos = rx.indexIn(text, pos)) != -1 ) {
		//we need to look ahead to see if it's already a well formed link
		if (text.mid(pos - 6, 6) != "href=\"" && text.mid(pos - 6, 6) != "href='" && text.mid(pos - 6, 6) != "ttp://" ) 
		{
			QString tempMessg = text.left(pos) + "<a href=\"" + rx.cap(count) + "\">" + rx.cap(count) + "</a>" + text.mid(pos + rx.matchedLength(), -1);
			text = tempMessg;
		}
		pos += rx.matchedLength() + 15;
		count ++;
  	}
	
	cursor.movePosition(QTextCursor::End);
	chat->setTextCursor(cursor);

	chat->insertHtml(text);	
}	

void form_ChatWidget::setTextColor(){
	QTextEdit *message=this->message;
	textColor = QColorDialog::getColor(Qt::black, this);
	
	//textColor = QColorDialog::getColor(message->textColor(), this);
	QPixmap pxm(22,22);
	pxm.fill(textColor);
	//txtColor->setIcon(pxm);
	user.setTextColor(textColor);
	
	message->setTextColor(textColor);
	

}

void form_ChatWidget::setFont()
{
	QTextEdit *message=this->message;
    	bool ok;
    	mCurrentFont = QFontDialog::getFont(&ok, mCurrentFont, this);
    	
	user.setTextFont(mCurrentFont);
	//message->setCurrentFont(mCurrentFont);
	message->setFont(mCurrentFont);
	message->setFocus();
}


void form_ChatWidget::setBold(bool t){

	QTextEdit *message=this->message;
	QFont font = message->currentFont();
	font.setBold(t);
	user.setTextFont(mCurrentFont);
	//message->setCurrentFont(font);
	message->setFont(font);

}

void form_ChatWidget::closeEvent(QCloseEvent *e){
	user.setHaveAllreadyOneChatWindow(false);
	disconnect(&user,SIGNAL(signNewMessageRecived()),this,
		SLOT(newMessageRecived()));

	e->ignore();
	this->deleteLater();
}

void form_ChatWidget::sendMessageSignal(){
	QTextEdit *message=this->message;
	if(message->toPlainText().length()==0)return;

	QString NewMessage=message->toHtml();

	user.slotSendChatMessage(NewMessage);

	//emit sendChatMessage(message->toHtml());
	
	message->clear();

	//message->document()->clear();

}

void form_ChatWidget::WorkAround()
{

	QTextEdit *message=this->message;
	if(message->textCursor().position()>1)return;
	else if(message->textCursor().position()==1 && message->toPlainText().length()==1)
	{
		message->selectAll();
		message->setTextColor(textColor);
		//message->setCurrentFont(mCurrentFont);
		message->setFont(mCurrentFont);
		message->moveCursor(QTextCursor::End,QTextCursor::MoveAnchor);
		message->textCursor().clearSelection();
	}

}


void form_ChatWidget::changeWindowsTitle()
{
	QString OnlineStatus;
	QString OnlineStatusIcon;
	switch(user.getOnlineState())
		{
			
			case USERTRYTOCONNECT:
			case USERINVISIBLE:
			case USEROFFLINE:{
						OnlineStatus="Offline";
						this->setWindowIcon(QIcon(ICON_USER_OFFLINE));
						break;
					}
			case USERONLINE:	
					{
						OnlineStatus="Online";
						this->setWindowIcon(QIcon(ICON_USER_ONLINE));
						break;
					}
			case USERWANTTOCHAT:
					{
						OnlineStatus="Want to chat";
						this->setWindowIcon(QIcon(ICON_USER_WANTTOCHAT));
						break;
					}
			case USERAWAY:
					{
						OnlineStatus="Away";
						this->setWindowIcon(QIcon(ICON_USER_AWAY));	
						break;
					}
			case USERDONT_DISTURB:
					{
						OnlineStatus="Don't disturb";
						this->setWindowIcon(QIcon(ICON_USER_DONT_DUSTURB));
						break;
					}


		}



	this->setWindowTitle(tr("Chat with: ") + user.getName() +"       ("+ OnlineStatus +")");
}

void form_ChatWidget::newFileTransfer()
{
	if(user.getConnectionStatus()==ONLINE){
		QString FilePath=QFileDialog::getOpenFileName(this,"Open File", ".", "all Files (*)");
		QString Destination= user.getI2PDestination();
		
		if(!FilePath.isEmpty())
			Core.addNewFileTransfer(FilePath,Destination);
			
	}
	else{
		QMessageBox* msgBox= new QMessageBox(this);
		msgBox->setIcon(QMessageBox::Information);
		msgBox->setText(tr("Sendfile"));
		msgBox->setInformativeText(tr("The other user must be online, filesend abborted"));
		msgBox->setStandardButtons(QMessageBox::Ok);
		msgBox->setDefaultButton(QMessageBox::Ok);
		msgBox->setWindowModality(Qt::NonModal);
		msgBox->show();
	}
}


void form_ChatWidget::anchorClicked (const QUrl& link ) 
{

	if (link.scheme() == "http") 
		QDesktopServices::openUrl(link);
	else if (link.scheme() == "") 
	{
		//it's probably a web adress, let's add http:// at the beginning of the link
		QString newAddress = link.toString();
		newAddress.prepend("http://");
		QDesktopServices::openUrl(QUrl(newAddress));
	}
}