/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef USER_H
#define USER_H

#include <QtGui>
#include <QStringList>
#include <QTime>
#include "I2PStream.h"

namespace User
{
	enum CONNECTIONTOUSER{
		OFFLINE,
		ONLINE,
		TRYTOCONNECT,
		ERROR
	};

	enum ONLINESTATE{
		USERONLINE,
		USEROFFLINE,
		USERINVISIBLE,
		USERWANTTOCHAT,
		USERAWAY,
		USERDONT_DISTURB,
		USERTRYTOCONNECT
	};

}//namespace user

using namespace User;
class CProtocol;
class CUser: public QObject
{
	Q_OBJECT
	public:
					CUser(	CProtocol& Protocol,
						QString Name,
						QString I2PDestination,
						qint32 I2PStream_ID
					);
	
	const 	QString 		getName()const;
	const 	QString 		getI2PDestination()const;
	      	qint32  		getI2PStreamID()const;
	const 	QString 		getProtocolVersion()const;
	const 	QString 		getClientName()const;
	const	QString 		getClientVersion()const;
	      	QColor  		getTextColor();
	      	QFont   		getTextFont();
		CONNECTIONTOUSER 	getConnectionStatus()const;
		ONLINESTATE 	 	getOnlineState()const;
	const 	QStringList&		getChatMessages();
		bool 			getHaveAllreadyOneChatWindow()const;	
		bool 			getHaveNewUnreadMessages();
		bool			getIsInvisible(){return mInvisible;};

		void 			setConnectionStatus(CONNECTIONTOUSER Status);
		void 			setOnlineState(const ONLINESTATE newState);
		void			setName(QString newName);
		void 			setI2PStreamID(qint32 ID);
		void 			setProtocolVersion(QString Version);
		void 			setHaveAllreadyOneChatWindow(bool t);
		void 			setClientName(QString Name);
		void 			setClientVersion(QString Version);
		void 			setTextColor(QColor textColor);
		void 			setTextFont(QFont textFont);
		void 			setInvisible(bool b);

		void 			IncomingNewChatMessage(QString newMessage);
		void 			IncomingMessageFromSystem(QString newMessage);


	
	public slots:
		void  			slotSendChatMessage(QString Message);

	signals:
		void 			signOnlineStateChanged();
		void 			signNewMessageRecived();
		void 			signNewIncomingMessageRecived();
		void 			signConnectionOnline();
		void 			signConnectionOffline();
	private:
		void 			SendAllunsendedMessages();


		bool 			mHaveAllreadyOneChatWindow;
		bool 			mNewUnreadMessages;
		bool			mInvisible;
	const 	QString 		mI2PDestination;
		QString 		mName;
		qint32 			mI2PStream_ID;	
		
		CONNECTIONTOUSER 	mConnectionStatus;
		ONLINESTATE	 	mCurrentOnlineState;
		QString 		mProtocolVersion;
		QString 		mClientName;
		QString 		mClientVersion;
		QStringList 		mMessages;
		QStringList 		mUnsendedMessages;
		CProtocol& 		mProtocol;

	//Settings for the chatwindow
		QColor 			mTextColor;
		QFont  			mTextFont;
};

#endif 
