/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "User.h"
#include "Protocol.h"

CUser::CUser(	CProtocol& Protocol,
		QString Name,
		QString I2PDestination,
		qint32 I2PStream_ID
		):mProtocol(Protocol),mI2PDestination(I2PDestination)
{

	this->mName=Name;
	this->mI2PStream_ID=I2PStream_ID;
	this->mConnectionStatus=OFFLINE;
	this->mHaveAllreadyOneChatWindow=false;
	this->mNewUnreadMessages=false;
	this->mClientName="";
	this->mClientVersion="";
	this->mCurrentOnlineState=USEROFFLINE;

	this->mTextColor=Qt::black;
	this->mTextFont=QFont("Comic Sans MS", 10);
	this->mInvisible=false;
}

const QString CUser::getName()const{
	return this->mName;
}
const QString CUser::getI2PDestination()const{
	return this->mI2PDestination;
}
qint32 CUser::getI2PStreamID()const{
	return this->mI2PStream_ID;
}

CONNECTIONTOUSER CUser::getConnectionStatus()const{
	return this->mConnectionStatus;
}

void CUser::setName(QString newName){
	this->mName=newName;
}
void CUser::setConnectionStatus(CONNECTIONTOUSER Status){
	
	mConnectionStatus=Status;
	
	if(Status==ONLINE){
		//get some Infos from the CHATSYSTEM - client
		mProtocol.send(GET_CLIENTNAME		,mI2PStream_ID);
		mProtocol.send(GET_CLIENTVERSION	,mI2PStream_ID);
		mProtocol.send(GET_USER_ONLINESTATUS	,mI2PStream_ID);
	}

	
	if(Status==OFFLINE ||Status==ERROR){
		mI2PStream_ID=0;
		setOnlineState(USEROFFLINE);
	}
}
void CUser::setI2PStreamID(qint32 ID){
	this->mI2PStream_ID=ID;
}

void CUser::setProtocolVersion(QString Version){
	this->mProtocolVersion=Version;
}
const QString CUser::getProtocolVersion()const{
	return this->mProtocolVersion;
}

void CUser::IncomingNewChatMessage(QString newMessage){
	this->mMessages.push_back(mName+" ("+ QTime::currentTime().toString("hh:mm:ss") +"): "+newMessage+"<br>");	
	this->mNewUnreadMessages=true;

	emit signNewMessageRecived();
	emit signNewIncomingMessageRecived();
}
void CUser::slotSendChatMessage(QString Message){
	using namespace PROTOCOL_TAGS;

	if(mConnectionStatus==ONLINE && 
		mCurrentOnlineState != USEROFFLINE &&
		mCurrentOnlineState != USERINVISIBLE
	){
		//mProtocol.send(CHATMESSAGE,mI2PStream_ID,Message);
		QByteArray ByteMessage=Message.toUtf8();
		mProtocol.send(CHATMESSAGE,mI2PStream_ID,ByteMessage);

		this->mMessages.push_back("Me ("+QTime::currentTime().toString("hh:mm:ss")  +"): "+Message+"<br>");
		emit signNewMessageRecived();	
	}
	else{
		this->mMessages.push_back("[SYSTEM] ("+QTime::currentTime().toString("hh:mm:ss") +"): "+
			"Sending the message when the user comes online.<br>If you close the client, the message will be lost.<br><br>");
		
		mUnsendedMessages.push_back(Message);
		emit signNewMessageRecived();
	}
}
void CUser::setHaveAllreadyOneChatWindow(bool t){
	mHaveAllreadyOneChatWindow=t;
}
bool CUser::getHaveAllreadyOneChatWindow() const{
	return mHaveAllreadyOneChatWindow;
}
const QStringList& CUser::getChatMessages(){
	mNewUnreadMessages=false;
	return mMessages;
}
void CUser::SendAllunsendedMessages(){ 
	using namespace PROTOCOL_TAGS;
	if(mUnsendedMessages.empty())return;


	for(int i=0;i<mUnsendedMessages.count();i++)
		mProtocol.send(CHATMESSAGE,mI2PStream_ID,mUnsendedMessages.at(i));

	this->mMessages.push_back("[SYSTEM] ("+QTime::currentTime().toString("hh:mm:ss")+"): All unsent messages were sent<br><br>");
	mUnsendedMessages.clear();
	this->mNewUnreadMessages=true;
	emit signNewMessageRecived();
}

bool CUser::getHaveNewUnreadMessages(){
	return mNewUnreadMessages;
}

const QString CUser::getClientName() const
{
	return mClientName;
}

void CUser::setClientName(QString Name)
{
	mClientName=Name;
}


const QString CUser::getClientVersion() const
{
	return mClientVersion;
}

void CUser::setClientVersion(QString Version)
{
	this->mClientVersion=Version;
}

ONLINESTATE CUser::getOnlineState() const
{
	return mCurrentOnlineState;
}

void CUser::setOnlineState(const ONLINESTATE newState)
{
	
	if(newState!=USEROFFLINE && 
	   newState!=USERINVISIBLE){		
		if(mCurrentOnlineState==USEROFFLINE || mCurrentOnlineState==USERINVISIBLE)
			emit signConnectionOnline();
		this->SendAllunsendedMessages();
	}
	else if(newState==USEROFFLINE || newState==USERINVISIBLE){
		if(newState!=mCurrentOnlineState)
			emit signConnectionOffline();

	}

	this->mCurrentOnlineState=newState;
	emit signOnlineStateChanged();
}

QColor CUser::getTextColor()
{
	return mTextColor;
}

void CUser::setTextColor(QColor textColor)
{
	this->mTextColor=textColor;
}

void CUser::setTextFont(QFont textFont)
{
	this->mTextFont=textFont;
}

QFont CUser::getTextFont()
{
	return mTextFont;
}

void CUser::IncomingMessageFromSystem(QString newMessage)
{
	this->mMessages.push_back("[System] ("+ QTime::currentTime().toString("hh:mm:ss") +"): "+newMessage+"<br><br>");	
	this->mNewUnreadMessages=true;
	emit signNewMessageRecived();
	emit signNewIncomingMessageRecived();
}

void CUser::setInvisible(bool b)
{
	mInvisible=b;
	if(mConnectionStatus==ONLINE){
		QByteArray Data("1003");//GET_USER_ONLINESTATUS = send the new OnlineStatus
		mProtocol.slotInputKnown(mI2PStream_ID,Data);
	}
	emit signOnlineStateChanged();
}