/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "PacketManager.h"
#include <iostream>
using namespace std;


CPacketManager::CPacketManager ( qint32 ID )
:mID ( ID ) 
{
	mData.clear();
}

CPacketManager::~CPacketManager() 
{
}

void CPacketManager::operator << ( QByteArray t )
{
	mData.append ( t );
	checkifOnePacketIsComplead();
}
qint32 CPacketManager::getID()
{
	return mID;
}

void  CPacketManager::checkifOnePacketIsComplead()
{
	if ( mData.length() >=8 )
	{
		QString sPacketLength=mData.mid ( 0,4 );
		

		bool OK=false;
		int iPacketLength =sPacketLength.toInt ( &OK,16 );
		if(OK==false)
		{
			QString sID=QString::number(mID,10);
			QMessageBox msgBox;
			msgBox.setIcon(QMessageBox::Warning);
			msgBox.setText("cPacketManager ("+sID+")");
			msgBox.setInformativeText("cant parse PacketLength\nHexValue: "+sPacketLength );
			msgBox.setStandardButtons(QMessageBox::Ok);
			msgBox.setDefaultButton(QMessageBox::Ok);
			msgBox.exec();
		}

		if ( mData.length() >=iPacketLength+4 )
		{
			QByteArray CurrentPacket (mData.mid ( 4 ),iPacketLength );
			//QByteArray CurrentPacket ( mData.mid (4,iPacketLength));
			mData.remove ( 0,iPacketLength+4 );
			emit signAPacketIsComplead ( mID,CurrentPacket );
			checkifOnePacketIsComplead();
		}
	}
	return;
}

void CPacketManager::slotDataInput(qint32 ID,QByteArray t)
{
	if(ID==this->mID)
	{
		*(this)<<t;
	}
}

