/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef I2PSTREAM_H
#define I2PSTREAM_H

#include <QTcpSocket>
#include <QSocketNotifier>
#include <QTimer>

#include "I2PSamMessageAnalyser.h"

namespace STREAMS
{
	enum StreamMode{
		ACCEPT,
		CONNECT
	};
}

namespace CONNECTIONTYPE
{
	enum Type{
		UNKNOWN,
		KNOWN	
	};
}

using namespace STREAMS;
using namespace CONNECTIONTYPE;
class CI2PStream:public QObject
{
	Q_OBJECT
	

	public:
				CI2PStream(
					QString SamHost,
					QString SamPort,
					qint32 ID,
					QString StreamBridgeName,
					StreamMode Mode,
					bool Silence=false
				);	
				~CI2PStream();

		bool 		doConnect(QString Destination);
		bool 		doAccept();
		void 		doDisconnect();

		QString 	getDestination();
		qint32 		getID();
		StreamMode 	getStreamMode();
		Type 		getConnectionType() const;
		bool 		getFIRSTPAKETCHAT_allreadySended() const;
		void 		setConnectionType ( const Type newTyp );
		void 		setFIRSTPAKETCHAT_allreadySended ( bool theValue );

		void operator <<(const QByteArray Data);
		void operator <<(const QString Data);



		void startUnlimintedReconnect(qint32 msec);
		void stopUnlimintedReconnect();

		
	

	private slots:
		void slotConnected();
		void slotDisconnected();
		void slotReadFromSocket();
		void slotCheckForReconnect();
		void slotInitConnectionTimeout();
	
	signals:
		void signDebugMessages(const QString Message);
		void signStreamStatusRecived(const SAM_Message_Types::RESULT result,const qint32 ID,const QString Message);
		void signDataRecived(const qint32 ID,const QByteArray Data);
		void signModeAcceptIncomingStream(qint32 ID);//emit if Destination recived (SILENCE=false)
	
	private:
			Type 		mConnectionType;
		const 	StreamMode 	mMode;
		const 	qint32 		mID;
		const 	QString 	mStreamBridgeName;
			QString 	mDestination;
			bool 		mDoneDisconnect;
			bool 		mModeStreamConnect;
			bool 		mModeStreamAccept;
		const 	bool 		mSilence;
			bool 		mStatusRecived;
		const 	QString 	mSamHost;
		const 	QString 	mSamPort;
			bool 		mHandShakeWasSuccesfullDone;
			bool 		mDestinationRecived;
			bool 		mFIRSTPAKETCHAT_allreadySended;

			QByteArray* 	mIncomingPackets;
			QTcpSocket 	mTcpSocket;
			QTimer* 	mTimer;
			QTimer 		mUnKnownConnectionTimeout;
			CI2PSamMessageAnalyser* mAnalyser;
			
};
#endif