/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FILETRANSFERSEND_H
#define FILETRANSFERSEND_H
#include <QtGui>
#include "I2PStream.h"
#include "ConnectionManager.h"

namespace FileTransferProtocol
{
	const QString PROTOCOLVERSION= "0.1";
	const QString FIRSTPAKET ="CHATSYSTEMFILETRANSFER\t"+PROTOCOLVERSION+"\n";
	//+sizeinbit\nFileName
};

//limited to 30Kb
//#define MAXPAKETSIZE 30720
#define MAXPAKETSIZE 1024
class CCore;
class CFileTransferSend:public QObject
{
	Q_OBJECT

	public:
		CFileTransferSend(
				CCore* Core,
				CConnectionManager* ConnectionManager,
				QString FilePath,
				QString Destination
		);
		~CFileTransferSend();
	
		quint64 getFileSize()	{return mFileSize;};
		qint32  getStreamID()	{return mStreamID;};
		QString getDestination(){return mDestination;};
		QString getFileName()	{return mFileName;};
		quint64 getAllreadySendedSize() {return mAllreadySendedSize;};
		
		void 	set_haveAllreadyAWindow(bool b);
		
		bool 	CheckIfAllreadyHaveAWindow(){return mHaveAllreadyAWindow; };
	
	public slots:
		void slotAbbortFileSend();

	private slots:
		void slotStreamStatus(const SAM_Message_Types::RESULT result,const qint32 ID,QString Message);
		void slotDataRecived  (const qint32 ID,QByteArray t );

	signals:
		void signAllreadySendedSizeChanged(quint64 Size);
		void signFileTransferAccepted(bool t);
		void signFileTransferFinishedOK();
		void signFileTransferError();
		void signFileTransferAborted();//the otherSide abort it
	
	private:
		void StartFileTransfer();
		void SendFile();
	
			CCore*			mCore;
			CI2PStream* 		mStream;
			CConnectionManager* 	mConnectionManager;
		const 	QString 		mFilePath;
		const 	QString 		mDestination;
			qint64 			mFileSize;
			qint64 			mAllreadySendedSize;
			qint32 			mStreamID;
			QFile* 			mFileForSend;
			bool 			mSendFirstPaket;
			bool 			mFileTransferAccepted;
			QString 		mFileName;
			bool 			mHaveAllreadyAWindow;
}; 
#endif
