/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "FileTransferSend.h"
#include "gui/form_fileSend.h"
#include "Core.h"

CFileTransferSend::CFileTransferSend(CCore * Core,CConnectionManager* ConnectionManager, QString FilePath,QString Destination)
:mFilePath(FilePath),mDestination(Destination)
{
	mCore=Core;
	mConnectionManager=ConnectionManager;
	mStream=(CI2PStream*)ConnectionManager->doCreateNewStreamObject(CONNECT,false);

	connect(mStream,SIGNAL(signStreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)),this,
		SLOT(slotStreamStatus(const SAM_Message_Types::RESULT, const qint32, QString)));
	
	connect(mStream,SIGNAL(signDataRecived(const qint32, const QByteArray)),this,
		SLOT(slotDataRecived(const qint32, QByteArray)));

	mStreamID=mStream->getID();
	mCore->setStreamTypeToKnown(mStreamID,NULL,true);
	mStream->doConnect(Destination);
	
	
	mHaveAllreadyAWindow=false;
	mSendFirstPaket=true;
	mFileName=FilePath.mid(FilePath.lastIndexOf("/")+1);
	mFileTransferAccepted=false;
	mFileForSend  = new QFile(FilePath);
	mFileSize=mFileForSend->size();
	mAllreadySendedSize=0;
}

void CFileTransferSend::slotAbbortFileSend()
{
	mFileForSend->close();
	mCore->removeFileTransfer(mStreamID);
	mConnectionManager->doDestroyStreamObjectByID(mStream->getID());

}

void CFileTransferSend::slotStreamStatus(const SAM_Message_Types::RESULT result, const qint32 ID, QString Message)
{
	quint32 t=ID;
	
	using namespace FileTransferProtocol;	

	switch(result){
		case (SAM_Message_Types::OK):{
			if(mSendFirstPaket==true){
				QString StringFileSize;
				StringFileSize.setNum(mFileSize);
	
				mStream->operator <<(FIRSTPAKET+StringFileSize+"\n"+mFileName);
				mSendFirstPaket=false;
			}
			break;
		}
		
		case (SAM_Message_Types::CANT_REACH_PEER):
		case (SAM_Message_Types::TIMEOUT):
		case (SAM_Message_Types::CLOSED):{
			if(mAllreadySendedSize==mFileSize){
			emit signFileTransferFinishedOK();	
			mCore->getUserByI2P_Destination(mDestination)->
				IncomingMessageFromSystem("Filetransfer finished (OK)<br>FileName: "+mFileName+"<br>");
			}
			else{
				emit signFileTransferAborted();
				if(mAllreadySendedSize==0){
					mCore->getUserByI2P_Destination(mDestination)->
					IncomingMessageFromSystem("Can't connect the User for Filetransfer<br>Filename: "+mFileName);
				}
				else
				{
					mCore->getUserByI2P_Destination(mDestination)->
						IncomingMessageFromSystem("The Reciver abort the Filerecive<br>Filename: "+mFileName);
				}
			}
			mFileForSend->close();
			mConnectionManager->doDestroyStreamObjectByID(mStreamID);
			mCore->removeFileTransfer(mStreamID);

			break;
		}
		case (SAM_Message_Types::I2P_ERROR):{
			emit signFileTransferAborted();
			mCore->getUserByI2P_Destination(mDestination)->
				IncomingMessageFromSystem("Filetransfer: "+mFileName+"Stream get a I2P_ERROR:<br>"+Message);

			mFileForSend->close();
			mConnectionManager->doDestroyStreamObjectByID(mStreamID);
			mCore->removeFileTransfer(mStreamID);
			break;
		}
		case (SAM_Message_Types::INVALID_KEY):{
			emit signFileTransferAborted();
			mCore->getUserByI2P_Destination(mDestination)->
				IncomingMessageFromSystem("Filetransfer: "+mFileName+"Stream get a INVALID_KEY ERROR:<br>"+Message);

			mFileForSend->close();
			mConnectionManager->doDestroyStreamObjectByID(mStreamID);
			mCore->removeFileTransfer(mStreamID);
			break;
		}
		case (SAM_Message_Types::INVALID_ID):{
			emit signFileTransferAborted();
			mCore->getUserByI2P_Destination(mDestination)->
				IncomingMessageFromSystem("Filetransfer: "+mFileName+"Stream get a INVALID_ID ERROR:<br>"+Message);
			
			mFileForSend->close();
			mConnectionManager->doDestroyStreamObjectByID(mStreamID);
			mCore->removeFileTransfer(mStreamID);
			break;
		}
		default:{
			break;
		}
	}
}
CFileTransferSend::~ CFileTransferSend()
{
	delete mFileForSend;
}

void CFileTransferSend::slotDataRecived(const qint32 ID,QByteArray t)
{
	if(t.length()==1){

		if(t.contains("0")){//true
			emit signFileTransferAccepted(true);
			mFileTransferAccepted=true;
			StartFileTransfer();
			
		}
		else{
			emit signFileTransferAccepted(false);
			mCore->getUserByI2P_Destination(mDestination)->
				IncomingMessageFromSystem("Filetransfer don't accepted,filesending abborted<br>Filename: "+mFileName);
			mConnectionManager->doDestroyStreamObjectByID(ID);
			mCore->removeFileTransfer(mStreamID);
			
		}
	}
	else{
		emit signFileTransferAccepted(false);
		mCore->getUserByI2P_Destination(mDestination)->
				IncomingMessageFromSystem("Filetransfer don't accepted,filesending abborted<br>Filename: "+mFileName);
		mConnectionManager->doDestroyStreamObjectByID(ID);
		mCore->removeFileTransfer(mStreamID);
	}

}

void CFileTransferSend::StartFileTransfer()
{
	mAllreadySendedSize=0;
	mFileForSend->open(QIODevice::ReadOnly);
	SendFile();

}

void CFileTransferSend::set_haveAllreadyAWindow(bool b)
{
	mHaveAllreadyAWindow=b;
	if(b==true && mFileTransferAccepted==true)
		emit signFileTransferAccepted(mFileTransferAccepted);
}

void CFileTransferSend::SendFile()
{
	while(mAllreadySendedSize<mFileSize){
		QByteArray Buffer;

		Buffer=mFileForSend->read(MAXPAKETSIZE);
		mAllreadySendedSize+=Buffer.length();

		mStream->operator <<(Buffer);
		emit signAllreadySendedSizeChanged(mAllreadySendedSize);	
	}

	emit signFileTransferFinishedOK();
	mCore->getUserByI2P_Destination(mDestination)->
			IncomingMessageFromSystem("Filetransfer Finished (OK)<br>FileName: "+mFileName+"<br>");

	return;
}
