/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "form_fileRecive.h"
#include "src/FileTransferRecive.h"

form_fileRecive::form_fileRecive(CFileTransferRecive * FileRecive)
{
	setupUi(this);
	this->setAttribute(Qt::WA_DeleteOnClose,true);

	this->FileRecive=FileRecive;
	init();

	connect(FileRecive,SIGNAL(signFileRecivedFinishedOK()),this,
		SLOT(slot_FileRecivedFinishedOK()));

	connect(FileRecive,SIGNAL(signAllreadyRecivedSizeChanged(quint64)),this,
		SLOT(slot_allreadyRecivedSizeChanged(quint64)));

	connect(FileRecive,SIGNAL(signFileReciveError()),this,
		SLOT(slot_FileReciveError()));

	connect(FileRecive,SIGNAL(signFileReciveAborted()),this,
		SLOT(slot_FileReciveAborted()));

	connect(pushButton,SIGNAL(pressed()),this,
		SLOT(slot_Button()));	

	FileRecive->setHaveAllreadyAWindow(true);
	if(FileRecive->checkIfAllreadyAcceptTheRequest()==false){
		askTheUser();
	}
}

void form_fileRecive::init()
{
	QString SSize;	
	QLabel *label_4=this->label_4;
	QLabel *label_6=this->label_6;
	QLabel *label_7=this->label_7;
	QProgressBar * progressBar= this->progressBar;
	

	label_4->setText(FileRecive->getFileName());
	
	quint64 FileSize=FileRecive->getFileSize();
	if(FileSize>=(1024*1024))
	{//MB
		QString MB;
		QString KB;

		qint32 tmp= FileSize/(1024*1024);
		qint32 tmp2=FileSize-(tmp*(1024*1024));
		tmp2 =qRound(tmp2/1024);
		
		MB.setNum(tmp,10);
		KB.setNum(tmp2,10);
		
		SSize=MB+"."+KB;
		label_6->setText(SSize);
		label_7->setText("MB");
	}
	else if(FileSize>=1024){
	//KB
		QString KB;
		QString Bytes;

		qint32 tmp= FileSize/(1024);
		qint32 tmp2=FileSize-(tmp*(1024));
		tmp2 =qRound(tmp2/1024);

		KB.setNum(tmp,10);
		Bytes.setNum(tmp2,10);

		SSize=KB+"."+Bytes;

		label_6->setText(SSize);
		label_7->setText("KB");
	}
	else{
	//Byte
		SSize.setNum(FileRecive->getFileSize(),10);
		label_6->setText(SSize);
		label_7->setText("Bytes");
	}


		
	//SSize.setNum(FileRecive->get_FileSize(),10);	
	//label_6->setText(SSize);
	//label_7->setText("Bytes");
	checkBox_3->setChecked(true);
	progressBar->setMinimum(0);
	progressBar->setMaximum(FileRecive->getFileSize());
	progressBar->setValue(0);
}

void form_fileRecive::slot_Button()
{
	FileRecive->slotAbbortFileRecive();
	this->close();
}

void form_fileRecive::slot_allreadyRecivedSizeChanged(quint64 value)
{
	progressBar->setValue(value);
}

void form_fileRecive::slot_FileRecivedFinishedOK()
{
	QCheckBox* checkBox_4= this->checkBox_4;
	checkBox_4->setChecked(true);
	
	this->close();
}

void form_fileRecive::slot_FileReciveError()
{


	this->close();
}

void form_fileRecive::slot_FileReciveAborted()
{	

	this->close();
}

form_fileRecive::~ form_fileRecive()
{
	FileRecive->setHaveAllreadyAWindow(false);
}

void form_fileRecive::askTheUser()
{
	quint64 FileSize= FileRecive->getFileSize();
	QString FileName= FileRecive->getFileName();
	QString SizeName;
	QString SSize;

	if(FileSize>=(1024*1024)){
	//MB
		QString MB;
		QString KB;

		qint32 tmp= FileSize/(1024*1024);
		qint32 tmp2=FileSize-(tmp*(1024*1024));
		tmp2 =qRound(tmp2/1024);
		
		MB.setNum(tmp,10);
		KB.setNum(tmp2,10);
		
		SSize=MB+"."+KB;
		SizeName="MB";
	}
	else if(FileSize>=1024){
	//KB
		QString KB;
		QString Bytes;

		qint32 tmp= FileSize/(1024);
		qint32 tmp2=FileSize-(tmp*(1024));
		tmp2 =qRound(tmp2/1024);

		KB.setNum(tmp,10);
		Bytes.setNum(tmp2,10);

		SSize=KB+"."+Bytes;
		SizeName="KB";
	}
	else{
	//Byte
		SSize.setNum(FileSize,10);
		SizeName="Bytes";

	}

	QMessageBox* msgBox= new QMessageBox(NULL);
 	msgBox->setText("Incoming FileTransfer");
	msgBox->setInformativeText("Do you want to accept it ?\nFileName: "+FileName+"\nFileSize: " +SSize+" "+SizeName);
 	msgBox->setStandardButtons(QMessageBox::Yes | QMessageBox::No);
 	msgBox->setDefaultButton(QMessageBox::Yes);
	msgBox->setWindowModality(Qt::WindowModal);
 	int ret = msgBox->exec();
	
	if(ret==QMessageBox::Yes){
		QString FilePath=QFileDialog::getSaveFileName(NULL,"File Save","./"+FileName);
		


		if(!FilePath.isEmpty()){
			FileRecive->start(FilePath,true);
		}
		else{
			FileRecive->start("",false);
			this->close();
		}
	}
	else{
			FileRecive->start("",false);
			this->close();
	}
}
