/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#include <QSystemTrayIcon>

#include "form_Main.h"



form_MainWindow::form_MainWindow(QWidget* parent)
    : QMainWindow(parent){
	setupUi(this); // this sets up GUI
	
	initStyle();
	
	initTryIconMenu();
	initTryIcon();
    	init();
}
void form_MainWindow::init()
{
	//using namespace SESSION_Types;

	Core= new CCore();
	fillComboBox();
	initToolBars();
	applicationIsClosing=false;
	
	Mute=false;
	

	QListWidget* listWidget=this->listWidget;

	connect (Core,SIGNAL(signUserStatusChanged()),this,
		SLOT(eventUserChanged()));

	connect(Core,SIGNAL(signOnlineStatusChanged()),this,
		SLOT(OnlineStateChanged()));

	connect(listWidget,SIGNAL(itemDoubleClicked( QListWidgetItem* )),this,
		SLOT(openChat_or_FileRecive_Dialog ()));

	connect(listWidget, SIGNAL( customContextMenuRequested(QPoint)), this,
		SLOT( connecttreeWidgetCostumPopupMenu(QPoint)));

	connect(comboBox,SIGNAL(currentIndexChanged( int)),this,
		SLOT(onlineComboBoxChanged()));

	this->eventUserChanged();
	//Core->set_OnlineStatus(USERTRYTOCONNECT);
	Core->setOnlineStatus(USEROFFLINE);
}

form_MainWindow::~form_MainWindow(){
	
	delete Core;
	delete trayIcon;
	applicationIsClosing=true;
	this->close();
}


void form_MainWindow::fillComboBox()
{
	QComboBox* comboBox = this->comboBox;

	comboBox->addItem(QIcon(ICON_USER_ONLINE)	, "Online");		//index 0
	comboBox->addItem(QIcon(ICON_USER_WANTTOCHAT)	, "WantToChat");	//1
	comboBox->addItem(QIcon(ICON_USER_AWAY)		, "Away");		//2
	comboBox->addItem(QIcon(ICON_USER_DONT_DUSTURB)	, "don't disturb");	//3
	comboBox->addItem(QIcon(ICON_USER_INVISIBLE)	, "Invisible");		//4
	comboBox->addItem(QIcon(ICON_USER_OFFLINE)	, "Offline");		//5

	comboBox->setCurrentIndex(5);

}

void form_MainWindow::onlineComboBoxChanged()
{
	QComboBox* comboBox= this->comboBox;
	QString text=comboBox->currentText();

	if(text.contains("Online",Qt::CaseInsensitive)==true){
		if(Core->getOnlineStatus()!=User::USERONLINE) 
			Core->setOnlineStatus(User::USERONLINE);
	}
	else if(text.contains("WantToChat",Qt::CaseInsensitive)==true){
		if(Core->getOnlineStatus()!=User::USERWANTTOCHAT) 
			Core->setOnlineStatus(User::USERWANTTOCHAT);
	}
	else if(text.contains("Away",Qt::CaseInsensitive)==true){
		if(Core->getOnlineStatus()!=User::USERAWAY) 
			Core->setOnlineStatus(User::USERAWAY);
	}
	else if(text.contains("don't disturb",Qt::CaseInsensitive)==true){
		if(Core->getOnlineStatus()!=User::USERDONT_DISTURB) 
			Core->setOnlineStatus(User::USERDONT_DISTURB);
	}
	else if(text.contains("Invisible",Qt::CaseInsensitive)==true){
		if(Core->getOnlineStatus()!=User::USERINVISIBLE) 
			Core->setOnlineStatus(User::USERINVISIBLE);
	}
	else if(text.contains("Offline",Qt::CaseInsensitive)==true){
		if(Core->checkIfAFileTransferOrReciveisActive()==false){
			if(Core->getOnlineStatus()!=User::USEROFFLINE) 
				Core->setOnlineStatus(User::USEROFFLINE);
		}
		else{
			QMessageBox* msgBox= new QMessageBox(NULL);
			msgBox->setIcon(QMessageBox::Information);
			msgBox->setText("");
			msgBox->setInformativeText("Sorry a Filetransfer or Filerecive ist active,\nclosing aborted");
			msgBox->setStandardButtons(QMessageBox::Ok);
			msgBox->setDefaultButton(QMessageBox::Ok);
			msgBox->setWindowModality(Qt::NonModal);
			msgBox->show();
			OnlineStateChanged();

		}
	}
	else if(text.contains("TryToConnect",Qt::CaseInsensitive)==true){
	}

}

void form_MainWindow::initToolBars()
{
	//toolBar->setIconSize(QSize(24, 24));
	QToolBar* toolBar=this->toolBar;
	
	
	toolBar->setMovable(false);
	toolBar->addAction(QIcon(ICON_NEWUSER)		,"Add User"		,this,SLOT(openAdduserWindow() ) );
	toolBar->addAction(QIcon(ICON_SETTINGS)		,"Settings"		,this,SLOT(openConfigWindow() ) );
	toolBar->addAction(QIcon(ICON_DEBUGMESSAGES)	,"DebugMessages"	,this,SLOT(openDebugMessagesWindow() ) );
	toolBar->addAction(QIcon(ICON_MYDESTINATION)	,"Your Destination"	,this,SLOT(namingMe()));
	toolBar->addAction(QIcon(ICON_CLOSE)		,"Close"		,this,SLOT(closeApplication()));
	toolBar->addAction(QIcon(ICON_ABOUT)		,"About"		,this,SLOT(openAboutDialog()));
}


void form_MainWindow::openConfigWindow(){
	
	form_settingsgui* dialog= new form_settingsgui();
	connect(this,SIGNAL(closeAllWindows()),dialog,
		SLOT(close()));	

	dialog->show();
	
}
void form_MainWindow::openAdduserWindow(){
	form_newUserWindow* dialog= new form_newUserWindow(Core);

	connect(this,SIGNAL(closeAllWindows()),dialog,
		SLOT(close()));	
	
	dialog->show();
}

void form_MainWindow::openDebugMessagesWindow(){
	form_DebugMessages* dialog= new form_DebugMessages(this->Core);

	connect(this,SIGNAL(closeAllWindows()),dialog,
		SLOT(close()));	

	dialog->show();
}

void form_MainWindow::namingMe(){
	QClipboard *clipboard = QApplication::clipboard();
	QString Destination=Core->getMyDestination();
	if(Destination!=""){
		clipboard->setText(Destination);
		QMessageBox::information(this, "",
                        "Your Destination is in the clipboard",QMessageBox::Close);
	}
	else
		QMessageBox::information(this, "",
                	"Your Client must be Online for that",QMessageBox::Close);
}
void form_MainWindow::closeApplication(){

	if(Core->checkIfAFileTransferOrReciveisActive()==false){

		applicationIsClosing=true;
		emit closeAllWindows();
			
		delete Core;
		delete trayIcon;
		
		this->close();
	}
	else{

		QMessageBox* msgBox= new QMessageBox(NULL);
		msgBox->setIcon(QMessageBox::Information);
		msgBox->setText("");
		msgBox->setInformativeText("Sorry a Filetransfer or Filerecive ist active,\nClosing aborted");
		msgBox->setStandardButtons(QMessageBox::Ok);
		msgBox->setDefaultButton(QMessageBox::Ok);
		msgBox->setWindowModality(Qt::NonModal);
		msgBox->show();

	}
	
}

void form_MainWindow::eventUserChanged(){

	bool showUnreadMessageAtTray=false;
	QList<CUser*> users=Core->getUserList();
	QList<CFileTransferRecive*> FileRecives=Core->getFileTransferReciveList();
	QList<CFileTransferSend*> FileSends=Core->getFileSendsList();

	listWidget->clear();

	
	for(int i=0;i<users.count();i++){
		//USERS
		QListWidgetItem* newItem= new QListWidgetItem(listWidget);
		QListWidgetItem* ChildWidthI2PDestinationAsText= new QListWidgetItem(listWidget);
		QListWidgetItem* ChildWidthTyp= new QListWidgetItem(listWidget);
		
		if(users.at(i)->getHaveNewUnreadMessages()==true){
			newItem->setIcon(QIcon(ICON_NEWUNREADMESSAGE));
			showUnreadMessageAtTray=true;
			
		}
		else
		switch(users.at(i)->getOnlineState())
		{
			
			case USERTRYTOCONNECT:
					{
						newItem->setIcon(QIcon(ICON_USER_OFFLINE));
						break;
					}
			case USERINVISIBLE:
			case USEROFFLINE:
					{
						newItem->setIcon(QIcon(ICON_USER_OFFLINE));
						break;
					}
			case USERONLINE:	
					{
						newItem->setIcon(QIcon(ICON_USER_ONLINE));	
						break;
					}
			case USERWANTTOCHAT:
					{
						newItem->setIcon(QIcon(ICON_USER_WANTTOCHAT));	
						break;
					}
			case USERAWAY:
					{
						newItem->setIcon(QIcon(ICON_USER_AWAY));	
						break;
					}
			case USERDONT_DISTURB:
					{
						newItem->setIcon(QIcon(ICON_USER_DONT_DUSTURB));	
						break;
					}


		}
		
		newItem->setTextAlignment(Qt::AlignLeft);
		QFont currentFont=newItem->font();
		newItem->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
		
		if(users.at(i)->getIsInvisible()==true)	{	
			currentFont.setItalic(true);		
			newItem->setFont(currentFont);
		}
		else{
			currentFont.setItalic(false);	
			newItem->setFont(currentFont);
		}

		newItem->setText(users.at(i)->getName());
		
     		
		ChildWidthI2PDestinationAsText->setText(users.at(i)->getI2PDestination());
		ChildWidthI2PDestinationAsText->setHidden(true);//DEBUG
		ChildWidthTyp->setText("U");
		ChildWidthTyp->setHidden(true);//DEBUG
	}

	for(int i=0;i<FileRecives.size();i++){
		//Filerecives
		QListWidgetItem* newItem= new QListWidgetItem(listWidget);
		QListWidgetItem* ChildWidthStreamIDAsText= new QListWidgetItem(listWidget);
		QListWidgetItem* ChildWidthTyp= new QListWidgetItem(listWidget);

		newItem->setIcon(QIcon(ICON_FILETRANSFER_RECIVE));
		newItem->setText(FileRecives.at(i)->getFileName());
		newItem->setTextAlignment(Qt::AlignLeft);
     		newItem->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
		
		QString t;
			t.setNum(FileRecives.at(i)->getStreamID(),10);
		
		ChildWidthStreamIDAsText->setText(t);
		ChildWidthStreamIDAsText->setHidden(true);//DEBUG
		ChildWidthTyp->setText("R");
		ChildWidthTyp->setHidden(true);//DEBUG
	}
	
	for(int i=0;i<FileSends.size();i++){
		//Filesends
		QListWidgetItem* newItem= new QListWidgetItem(listWidget);
		QListWidgetItem* ChildWidthStreamIDAsText= new QListWidgetItem(listWidget);
		QListWidgetItem* ChildWidthTyp= new QListWidgetItem(listWidget);

		newItem->setIcon(QIcon(ICON_FILETRANSFER_SEND));
		newItem->setText(FileSends.at(i)->getFileName());
		newItem->setTextAlignment(Qt::AlignLeft);
     		newItem->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
		
		QString t;
			t.setNum(FileSends.at(i)->getStreamID(),10);

		ChildWidthStreamIDAsText->setText(t);
		ChildWidthStreamIDAsText->setHidden(true);//DEBUG
		ChildWidthTyp->setText("S");
		ChildWidthTyp->setHidden(true);//DEBUG
	}



		if(showUnreadMessageAtTray==false)
			trayIcon->setIcon(QIcon(ICON_QTCHAT));
		else
			trayIcon->setIcon(QIcon(ICON_NEWUNREADMESSAGE));
}


void form_MainWindow::openChat_or_FileRecive_Dialog()
{	
	QListWidgetItem* t=listWidget->item(listWidget->currentRow()+2);

	if(t->text()=="U"){
		//open Chatwindow
		t= listWidget->item(listWidget->currentRow()+1);
		QString Destination =t->text();
			
		CUser* User;
		User=Core->getUserByI2P_Destination(Destination);
		if(User==NULL)return;
	
		if(User->getHaveAllreadyOneChatWindow()==false){
			form_ChatWidget* tmp= new form_ChatWidget(User,Core);
		
			connect(this,SIGNAL(closeAllWindows()),tmp,
				SLOT(close()));	
		
			eventUserChanged();
			
			tmp->show();
		}
		else{
			QMessageBox::information(this, "",
				"Only one Chatwindow for each User",QMessageBox::Close);
		}
	}
	else if(t->text()=="R"){
		//openFileReciveWindow
		t= listWidget->item(listWidget->currentRow()+1);

		bool OK=false;
		qint32 StreamID =t->text().toInt ( &OK,10 );
	
		if(OK==false){
			QMessageBox msgBox;
			msgBox.setIcon(QMessageBox::Critical);
			msgBox.setText("form_Main(openChat_or_FileRecive_Dialog)");
			msgBox.setInformativeText("cant parse value: "+t->text() );
			msgBox.setStandardButtons(QMessageBox::Ok);
			msgBox.setDefaultButton(QMessageBox::Ok);
			msgBox.exec();
		}	

		CFileTransferRecive* recive=Core->getFileTransferReciveByID(StreamID);
		if(recive!=NULL){
			if(recive->CheckIfAllreadyHaveAWindow()==false){
				//open new FileReciveWindow
				form_fileRecive* Dialog= new form_fileRecive(recive);
				Dialog->show();

			}
			else{
			QMessageBox::information(this, "",
				"Only one FileReciveWindow for each FileRecive",QMessageBox::Close);
			}
		}
	}
	else if(t->text()=="S"){
		//openFileSendWindow
		t= listWidget->item(listWidget->currentRow()+1);

		bool OK=false;
		qint32 StreamID =t->text().toInt ( &OK,10 );
	
		if(OK==false){
			QMessageBox msgBox;
			msgBox.setIcon(QMessageBox::Critical);
			msgBox.setText("form_Main(openChat_or_FileRecive_Dialog)");
			msgBox.setInformativeText("can't parse value: "+t->text() );
			msgBox.setStandardButtons(QMessageBox::Ok);
			msgBox.setDefaultButton(QMessageBox::Ok);
			msgBox.exec();
		}
		CFileTransferSend* sends=Core->getFileSendsByID(StreamID);
		if(sends!=NULL){
			if(sends->CheckIfAllreadyHaveAWindow()==false){
				//open new FileReciveWindow
				form_fileSend* Dialog= new form_fileSend(sends);
				Dialog->show();
				
			}
			else{
			QMessageBox::information(this, "",
				"Only one FileSendWindow for each Filesend",QMessageBox::Close);
			}
		}
	}	
}
void form_MainWindow::connecttreeWidgetCostumPopupMenu(QPoint point){
	QListWidget* listWidget=this->listWidget;

	if(listWidget->count()==0)return;

	QMenu contextMnu( this );
	QMenu contextMnuPos("Position",this);	

      	QMouseEvent *mevent = new QMouseEvent( QEvent::MouseButtonPress, point, Qt::RightButton, 
				Qt::RightButton, Qt::NoModifier );

	
	QAction* UserChat = new QAction("Chat",this);
		connect( UserChat , SIGNAL(triggered()),this, SLOT( openChat_or_FileRecive_Dialog()));

	QAction* UserDelete = new QAction("Delete",this);
		connect( UserDelete , SIGNAL(triggered()),this, SLOT( deleteUserClicked()));
	
	QAction* UserRename = new QAction("Rename",this);
		connect(UserRename,SIGNAL(triggered()),this, SLOT(userRenameCLicked()));
	
	QAction* CopyDestination = new QAction("Copy Destination",this);
		connect(CopyDestination,SIGNAL(triggered()),this, SLOT(copyDestination()));
	
	QAction* ShowUserInfos = new QAction("Userinfo",this);
		connect(ShowUserInfos,SIGNAL(triggered()),this, SLOT(showUserInfos()));

	QAction* UserInvisible = new QAction("Invisible",this);
		 UserInvisible->setCheckable(true);
		connect(UserInvisible,SIGNAL(triggered( bool )),this, SLOT(UserInvisible(bool)));


	//for contextMnuPos
	QAction* UP = new QAction("Up",this);
		connect(UP,SIGNAL(triggered()),this, SLOT(UserPositionUP()));
	QAction* DOWN = new QAction("Down",this);
		connect(DOWN,SIGNAL(triggered()),this, SLOT(UserPositionDOWN()));

	

	contextMnu.clear();
	contextMnu.addAction(UserChat);

	QListWidgetItem* t=listWidget->item(listWidget->currentRow()+2);

	if(t->text()=="U"){
		QListWidgetItem *t=listWidget->item(listWidget->currentRow()+1);
		QString Destination =t->text();
	
		CUser* User;
		User=Core->getUserByI2P_Destination(Destination);
	
		if(User->getConnectionStatus()==ONLINE)
		{
			QAction* UserSendFile = new QAction("SendFile",this);
			connect(UserSendFile,SIGNAL(triggered()),this, SLOT(SendFile()));
			contextMnu.addAction(UserSendFile);
		}
		
		if(User->getIsInvisible()==true){
			UserInvisible->setChecked(true);
		}
		else{
			UserInvisible->setChecked(false);
		}
		

		contextMnu.addSeparator();
		contextMnu.addAction(UserRename);
		contextMnu.addAction(UserDelete);
		contextMnu.addAction(CopyDestination);
		contextMnu.addAction(UserInvisible);
		contextMnu.addAction(ShowUserInfos);
		
		contextMnuPos.addAction(UP);
		contextMnuPos.addAction(DOWN);

		contextMnu.addMenu(&contextMnuPos);
		contextMnu.exec( mevent->globalPos());
	}
}

void form_MainWindow::deleteUserClicked(){
	QListWidgetItem *t=listWidget->item(listWidget->currentRow()+1);
	QString Destination =t->text();

	Core->deleteUserByI2PDestination(Destination);
}

void form_MainWindow::userRenameCLicked(){
	QListWidgetItem *t=listWidget->item(listWidget->currentRow());
	QString OldNickname=t->text();
	
	QListWidgetItem *t2= listWidget->item(listWidget->currentRow()+1);
	QString Destination =t2->text();

	form_RenameWindow* Dialog= new form_RenameWindow(Core,OldNickname,Destination);
	Dialog->show();
}

void form_MainWindow::closeEvent(QCloseEvent *e)
{
    static bool firstTime = true;
	if(applicationIsClosing==true) return;

    if (trayIcon->isVisible()) {
        if (firstTime)
        {
/*****
            QMessageBox::information(this, tr("I2PChat System tray"),
            tr("Application will continue running. Quit using context menu in the system tray"));
*****/
            firstTime = false;
        }
        hide();
        e->ignore();
    }

}

void form_MainWindow::updateMenu()
{
    toggleVisibilityAction->setText(isVisible() ? tr("Hide") : tr("Show"));
}

void form_MainWindow::toggleVisibility(QSystemTrayIcon::ActivationReason e)
{
    static QPoint MainFormPosition=this->pos();	

    if(e == QSystemTrayIcon::Trigger || e == QSystemTrayIcon::DoubleClick){
        if(isHidden()){
	    this->move(MainFormPosition);
            show();
 	    
	    //eventUserChanged();
	
            if(isMinimized()){
                if(isMaximized()){
                    showMaximized();
                }else{
                    showNormal();
                }
            }
            raise();
            activateWindow();
        }else{
	    MainFormPosition=this->pos();
            hide();
        }
    }
}

void form_MainWindow::toggleVisibilitycontextmenu()
{
    if (isVisible())
        hide();
    else
        show();
}

void form_MainWindow::OnlineStateChanged()
{
	disconnect(comboBox,SIGNAL(currentIndexChanged( int)),this,
		SLOT(onlineComboBoxChanged()));	

	QComboBox* comboBox = this->comboBox;
	ONLINESTATE onlinestatus= Core->getOnlineStatus();

	if(onlinestatus==User::USERTRYTOCONNECT){
		comboBox->clear();
		comboBox->addItem(QIcon(ICON_USER_TRYTOCONNECT)	, "TryToConnect");	//index 0
		comboBox->addItem(QIcon(ICON_USER_OFFLINE)	, "Offline");		//1
		comboBox->setCurrentIndex(0);
	}
	else{
		if(comboBox->count()<6){
			comboBox->clear();

			comboBox->addItem(QIcon(ICON_USER_ONLINE)	, "Online");		//index 0
			comboBox->addItem(QIcon(ICON_USER_WANTTOCHAT)	, "WantToChat");	//1
			comboBox->addItem(QIcon(ICON_USER_AWAY)		, "Away");		//2
			comboBox->addItem(QIcon(ICON_USER_DONT_DUSTURB)	, "don't disturb");	//3
			comboBox->addItem(QIcon(ICON_USER_INVISIBLE)	, "Invisible");		//4
			comboBox->addItem(QIcon(ICON_USER_OFFLINE)	, "Offline");		//5
		}

		if(onlinestatus==User::USERONLINE){
			comboBox->setCurrentIndex(0);
		}
		else if(onlinestatus==User::USERWANTTOCHAT){
			comboBox->setCurrentIndex(1);
		}
		else if(onlinestatus==User::USERAWAY){
			comboBox->setCurrentIndex(2);
		}
		else if(onlinestatus==User::USERDONT_DISTURB){
			comboBox->setCurrentIndex(3);
		}
		else if(onlinestatus==User::USERINVISIBLE){
			comboBox->setCurrentIndex(4);
		}
		else if(onlinestatus==User::USEROFFLINE){	
			comboBox->setCurrentIndex(5);
		}	
	}
	connect(comboBox,SIGNAL(currentIndexChanged( int)),this,
		SLOT(onlineComboBoxChanged()));	
}

void form_MainWindow::openAboutDialog()
{
	form_HelpDialog* dialog = new form_HelpDialog(Core->getClientVersion(),Core->getProtocolVersion());
	
	connect(this,SIGNAL(closeAllWindows()),dialog,
	SLOT(close()));	

	dialog->show();
}

void form_MainWindow::initStyle()
{
        QSettings * settings=new QSettings(QApplication::applicationDirPath()+"/application.ini",QSettings::IniFormat);
	settings->beginGroup("General");
	//Load Style
		QString Style=(settings->value("current_Style","")).toString();
		if(Style.isEmpty()==true)
		{
			//find default Style for this System
			QRegExp regExp("Q(.*)Style");
			Style = QApplication::style()->metaObject()->className();
			
			if (Style == QLatin1String("QMacStyle"))
				Style = QLatin1String("Macintosh (Aqua)");
			else if (regExp.exactMatch(Style))
				Style = regExp.cap(1);
			
			//styleCombo->addItems(QStyleFactory::keys());
		}
		
		qApp->setStyle(Style);
	//Load Style end

	//Load Stylesheet	
		QFile file(QApplication::applicationDirPath() + "/qss/" + 
			settings->value("current_Style_sheet","Default").toString() + ".qss");
		
		file.open(QFile::ReadOnly);
		QString styleSheet = QLatin1String(file.readAll());
		qApp->setStyleSheet(styleSheet);
	//load Stylesheet end
	settings->endGroup();

    delete settings;
}

void form_MainWindow::initTryIconMenu()
{
	// Tray icon Menu
	menu = new QMenu(this);
	QObject::connect(menu, SIGNAL(aboutToShow()), this, SLOT(updateMenu()));
	toggleVisibilityAction = 
		menu->addAction(QIcon(ICON_QTCHAT), tr("Show/Hide"), this, SLOT(toggleVisibilitycontextmenu()));	

	toggleMuteAction=
		menu->addAction(QIcon(ICON_SOUND_ON), tr("Sound on"),this,SLOT(muteSound()));
	menu->addSeparator();
	//menu->addAction(QIcon(ICON_MINIMIZE), tr("Minimize"), this, SLOT(showMinimized()));
	//menu->addAction(QIcon(ICON_MAXIMIZE), tr("Maximize"), this, SLOT(showMaximized()));
	menu->addSeparator();
	menu->addAction(QIcon(ICON_CLOSE), tr("&Quit"), this, SLOT(closeApplication()));

	

}

void form_MainWindow::initTryIcon()
{
	// Create the tray icon
	trayIcon = new QSystemTrayIcon(this);
	trayIcon->setToolTip(tr("I2P-Messenger"));
	trayIcon->setContextMenu(menu);
	trayIcon->setIcon(QIcon(ICON_QTCHAT));
    
   	 connect(trayIcon, SIGNAL(activated(QSystemTrayIcon::ActivationReason)), this, 
        	SLOT(toggleVisibility(QSystemTrayIcon::ActivationReason)));
    	trayIcon->show();
}

void form_MainWindow::SendFile()
{
	QString FilePath=QFileDialog::getOpenFileName(this,"Open File", ".", "all Files (*.*)");
	
	QListWidgetItem *t=listWidget->item(listWidget->currentRow()+1);
	QString Destination =t->text();
	
	if(!FilePath.isEmpty())
		Core->addNewFileTransfer(FilePath,Destination);
	
}

void form_MainWindow::copyDestination()
{
	QListWidgetItem *t=listWidget->item(listWidget->currentRow()+1);
	QString Destination =t->text();
	
	QClipboard *clipboard = QApplication::clipboard();
	
		clipboard->setText(Destination);
		QMessageBox::information(this, "",
                        "The Destination is in the clipboard",QMessageBox::Close);
	
}

void form_MainWindow::muteSound()
{
	if(this->Mute==false)
	{
		toggleMuteAction->setIcon(QIcon(ICON_SOUND_OFF));
		toggleMuteAction->setText("Sound off");
		Mute=true;
	}
	else
	{
		toggleMuteAction->setIcon(QIcon(ICON_SOUND_ON));
		toggleMuteAction->setText("Sound on");
		Mute=false;

	}
	Core->MuteSound(Mute);
}

void form_MainWindow::showUserInfos()
{
	QListWidgetItem* t=listWidget->item(listWidget->currentRow()+1);
	QString Destination =t->text();
	QString UserInfos="";

	UserInfos=Core->getUserInfosByI2P_Destination(Destination);

	QMessageBox msgBox;
	msgBox.setIcon(QMessageBox::Information);
	msgBox.setText("");
	msgBox.setInformativeText(UserInfos);
	msgBox.setStandardButtons(QMessageBox::Ok);
	msgBox.setDefaultButton(QMessageBox::Ok);
	msgBox.setWindowModality(Qt::NonModal);
	msgBox.exec();
}

void form_MainWindow::UserPositionUP()
{
	QListWidget* listWidget=this->listWidget;
	if(listWidget->currentRow() >= 1)
		Core->changeUserPositionInUserList(listWidget->currentRow()/3,listWidget->currentRow()/3 -1);
}

void form_MainWindow::UserPositionDOWN()
{
	QListWidget* listWidget=this->listWidget;
	if(listWidget->currentRow() < (listWidget->count()/3) -1)
		Core->changeUserPositionInUserList(listWidget->currentRow()/3,listWidget->currentRow()/3 +1);
	
}

void form_MainWindow::UserInvisible(bool b)
{
	QListWidgetItem* t=listWidget->item(listWidget->currentRow()+1);
	QString Destination =t->text();

	CUser* User;
	User=Core->getUserByI2P_Destination(Destination);
	if(User!=NULL){
		User->setInvisible(b);
	}
}
