/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef STREAMCONTROLLER_H
#define STREAMCONTROLLER_H

#include <QtGui>
#include <QTcpSocket>
#include <QSocketNotifier>

#include "I2PSamMessageAnalyser.h"



class cStreamController:public QObject
{
	Q_OBJECT
	public:
		cStreamController( 
			QString SamHost,
			QString SamPort,
			QString BridgeName,
			QString SamPrivKey,
			QString SessionOptions= "");
		~cStreamController();
		QString getBridgeName();
		QString getSamPrivKey();
		
		

	signals:
	void debugMessages(const QString Message);
	void SessionStatusRecived(const SAM_Message_Types::RESULT result,const QString Destination,const QString Message);
	void NamingReplyRecived(const SAM_Message_Types::RESULT result,QString Name,QString Value="",QString Message="");
	void SessionStreamStatusOK(bool Status);
	void NewSamPrivKeyGenerated(const QString SamPrivKey);


	public slots:	
	void doConnect();
	void doDisconnect();
	void doNamingLookUP(QString Name);
	void doDestGenerate();


	private slots:
	void connected();
	void disconnected();
	void readFromSocket();

	private:
	void doSessionCreate();

	const QString SamHost;
	const QString SamPort;
	QString SamPrivKey;
	const QString SessionOptions;
	const QString BridgeName;
	QTcpSocket* tcpSocket;
	I2PSamMessageAnalyser* Analyser;
	QByteArray* IncomingPackets;

	bool HandShakeWasSuccesfullDone;
	bool SessionWasSuccesfullCreated;
	bool doneDisconnect;

	inline void ConnectionReadyCheck()
	{
		if(	HandShakeWasSuccesfullDone==false ||
			SessionWasSuccesfullCreated==false||
			tcpSocket->state()!=QAbstractSocket::ConnectedState)
		return;
	}
};
#endif
