/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/



#include "StreamController.h"

#define SAM_HANDSHAKE_V3 "HELLO VERSION MIN=3.0 MAX=3.0\n"

cStreamController::cStreamController(QString SamHost, QString SamPort, QString BridgeName, QString SamPrivKey, QString SessionOptions)
:SamHost(SamHost),SamPort(SamPort),BridgeName(BridgeName),SessionOptions(SessionOptions)
{

	IncomingPackets= new QByteArray();
	tcpSocket= new QTcpSocket();
	doneDisconnect=false;

	Analyser= new I2PSamMessageAnalyser();
	this->HandShakeWasSuccesfullDone=false;
	this->SessionWasSuccesfullCreated=false;
	this->SamPrivKey=SamPrivKey;

	connect(tcpSocket,SIGNAL(connected() ),this,SLOT(connected() ),Qt::DirectConnection );
	connect(tcpSocket,SIGNAL(disconnected()),this,SLOT(disconnected()),Qt::DirectConnection );
	connect(tcpSocket,SIGNAL(readyRead() ),this, SLOT(readFromSocket()),Qt::DirectConnection);	
	
	emit debugMessages("<- StreamController (I2P) started ->");
}

cStreamController::~ cStreamController()
{
	doDisconnect();
	delete tcpSocket;
	emit debugMessages("<-- StreamController (I2P) stopped -->");
}

void cStreamController::connected()
{
	emit debugMessages("<-- StreamController (I2P) Connected -->\n");
	emit debugMessages(SAM_HANDSHAKE_V3);
	if(tcpSocket->state()==QAbstractSocket::ConnectedState){
		tcpSocket->write(SAM_HANDSHAKE_V3);
		tcpSocket->flush();
	}
}

void cStreamController::disconnected()
{
	if(doneDisconnect==false)
	{
		tcpSocket->close();
		emit debugMessages("<-- StreamController (I2P) can't connect I2P(sam) or I2P crashed -->\n");
		emit SessionStreamStatusOK(false);
		//emit SamConnectionClosed();
	}
}

void cStreamController::readFromSocket()
{
	using namespace SAM_Message_Types;

	QByteArray newData =tcpSocket->readAll();
	QByteArray CurrentPacket;
	IncomingPackets->append(newData);

		while(IncomingPackets->contains("\n")==true){
		
		if(IncomingPackets->indexOf("\n",0)==-1){
			//Not the complead Packet recived ??? maybe possible ???
			return;
		}
		CurrentPacket=IncomingPackets->left(IncomingPackets->indexOf("\n",0)+1);
		
		
		QString t(CurrentPacket.data());
				
		SAM_MESSAGE sam=Analyser->Analyse(t);
		switch(sam.type)
		{	//emit the signals
			case HELLO_REPLAY:{
				emit debugMessages(t);
				if(sam.result==OK){
					this->HandShakeWasSuccesfullDone=true;
					if(SamPrivKey==""){
						this->doDestGenerate();
					}
					else{
						doSessionCreate();
					}
				}
				else{
					emit SessionStreamStatusOK(false);
				}
				
				break;
			}
			case SESSION_STATUS:{
				emit debugMessages(t);
				if(sam.result==OK){
					this->SessionWasSuccesfullCreated=true;
					emit SessionStreamStatusOK(true);
				}
				else{
					if(sam.result==DUPLICATED_DEST){
						QMessageBox msgBox(NULL);
						msgBox.setIcon(QMessageBox::Critical);
						msgBox.setText("I2P-Messenger");
						msgBox.setInformativeText("Session: DUPLICATED_DEST\n\nOnly one Messenger per Destination,\nor SAMv3 crashed(Tunnel stay if Messenger were closed)\n ");
						msgBox.setStandardButtons(QMessageBox::Ok);
						msgBox.setDefaultButton(QMessageBox::Ok);
						msgBox.setWindowModality(Qt::NonModal);
						msgBox.exec();
					}
					

					emit SessionStreamStatusOK(false);
				}
				
				break;
			}
			case STREAM_STATUS:{
				emit debugMessages(t);
				//emit StreamStatusRecived(sam.result,sam.ID,sam.Message);
				break;
			}
			case NAMING_REPLY:{
				emit debugMessages(t);
				emit NamingReplyRecived(sam.result,sam.Name,sam.Value,sam.Message);
				break;
			}
			case DEST_REPLY:{
				emit debugMessages(t);
				SamPrivKey=sam.PRIV;
				emit NewSamPrivKeyGenerated(SamPrivKey);
				if(SessionWasSuccesfullCreated==false){
					doSessionCreate();
				}
				break;
			}
			case ERROR_IN_ANALYSE:{
				emit debugMessages("<ERROR_IN_ANALYSE>\n"+t);
				break;
			}
			default:
				{
					emit debugMessages("<Unknown Packet>\n"+t);
					break;
				}
		}
		IncomingPackets->remove(0,IncomingPackets->indexOf("\n",0)+1);
	}//while

}

void cStreamController::doConnect()
{
	doneDisconnect=false;

	if(tcpSocket->state()==QAbstractSocket::UnconnectedState) 
	{		
		tcpSocket->connectToHost(SamHost,SamPort.toInt( ));
	}
	if(!tcpSocket->waitForConnected(1000))
		disconnected();
}

void cStreamController::doDisconnect()
{
	doneDisconnect=true;
	
	if(tcpSocket->state()!=0){	
		tcpSocket->disconnectFromHost();
		emit debugMessages("<-- StreamController (I2P) Socket Disconnected -->\n");
	}
	else if(tcpSocket->state()==QAbstractSocket::UnconnectedState){
		emit debugMessages("<-- StreamController (I2P) Socket allready Disconnected -->\n");
	}

}

void cStreamController::doNamingLookUP(QString Name)
{	
	ConnectionReadyCheck();
	
	QByteArray Message="NAMING LOOKUP NAME=";
	Message+=Name+"\n";
	emit debugMessages(Message);
	tcpSocket->write(Message);
	tcpSocket->flush();

}

void cStreamController::doSessionCreate()
{
	ConnectionReadyCheck();
	//this->doDestGenerate();
	
	QByteArray Message="SESSION CREATE STYLE=STREAM ID=";
	Message+=BridgeName+" DESTINATION="+SamPrivKey;
	
	if(this->SessionOptions.isEmpty()==false)
		Message+=" "+SessionOptions;

	Message+="\n";
	emit debugMessages(Message);

	tcpSocket->write(Message);
	tcpSocket->flush();
}

void cStreamController::doDestGenerate()
{
	ConnectionReadyCheck();
	QByteArray Message="DEST GENERATE\n";
	emit debugMessages(Message);

	tcpSocket->write(Message);
	tcpSocket->flush();
}

QString cStreamController::getBridgeName()
{
	return BridgeName;
}

QString cStreamController::getSamPrivKey()
{
	return SamPrivKey;
}


#undef SAM_HANDSHAKE_V3


