/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef I2PSTREAM_H
#define I2PSTREAM_H

#include <QTcpSocket>
#include <QSocketNotifier>
#include <QTimer>

#include "I2PSamMessageAnalyser.h"

namespace STREAMS
{
	enum StreamMode{
		ACCEPT,
		CONNECT
	};
}

namespace CONNECTIONTYPE
{
	enum Type{
		UNKNOWN,
		KNOWN	
	};
}

using namespace STREAMS;
using namespace CONNECTIONTYPE;
class cI2PStream:public QObject
{
	Q_OBJECT
	

	public:
		cI2PStream(QString SamHost,QString SamPort,qint32 ID,QString StreamBridgeName,StreamMode Mode,bool Silence=false);
		~cI2PStream();
		bool doConnect(QString Destination);
		bool doAccept();
		void doDisconnect();
		QString getDestination();
		qint32 getID();
		StreamMode getStreamMode();
		void operator <<(const QByteArray Data);
		void operator <<(const QString Data);

		void setConnectionType ( const Type newTyp );
		Type getConnectionType() const;
		void startUnlimintedReconnect(qint32 msec);
		void stopUnlimintedReconnect();
		void setFIRSTPAKETCHAT_allreadySended ( bool theValue );
		bool getFIRSTPAKETCHAT_allreadySended() const;
	

	private slots:
		void connected();
		void disconnected();
		void readFromSocket();
		void checkForReconnect();
		void initConnectionTimeout();
	
	signals:
		void debugMessages(const QString Message);
		void StreamStatusRecived(const SAM_Message_Types::RESULT result,const qint32 ID,const QString Message);
		void DataRecived(const qint32 ID,const QByteArray Data);
		void ModeAcceptIncomingStream(qint32 ID);//emit if Destination recived (SILENCE=false)
	
	private:
		Type connectionType;
		const StreamMode Mode;
		const qint32 ID;
		const QString StreamBridgeName;
		QString Destination;
		bool doneDisconnect;
		bool ModeStreamConnect;
		bool ModeStreamAccept;
		const bool Silence;
		bool StatusRecived;
		const QString SamHost;
		const QString SamPort;
		bool HandShakeWasSuccesfullDone;
		bool DestinationRecived;
		bool FIRSTPAKETCHAT_allreadySended;

		QTcpSocket tcpSocket;
		QTimer* timer;
		QTimer unKnownConnectionTimeout;
		I2PSamMessageAnalyser* Analyser;
		QByteArray* IncomingPackets;
};
#endif