/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "I2PStream.h"

#define SAM_HANDSHAKE_V3 "HELLO VERSION MIN=3.0 MAX=3.0\n"
#define CONNECTIONTIMEOUT 60000

cI2PStream::cI2PStream(QString SamHost,QString SamPort,qint32 ID,QString StreamBridgeName,StreamMode Mode,bool Silence)
:SamHost(SamHost),SamPort(SamPort),ID(ID),StreamBridgeName(StreamBridgeName),Mode(Mode),Silence(Silence)
{
	Analyser=NULL;
	IncomingPackets=NULL;
	doneDisconnect=false;
	Silence=false;
	StatusRecived=false;
	HandShakeWasSuccesfullDone=false;
	connectionType=UNKNOWN;
	IncomingPackets= new QByteArray();
	DestinationRecived=false;
	FIRSTPAKETCHAT_allreadySended=false;
	timer=NULL;
	unKnownConnectionTimeout.setInterval(CONNECTIONTIMEOUT);

	connect(&tcpSocket,SIGNAL(connected() ),this,SLOT(connected() ) );
	connect(&tcpSocket,SIGNAL(disconnected()),this,SLOT(disconnected()) );
	connect(&tcpSocket,SIGNAL(readyRead() ),this, SLOT(readFromSocket()));

	connect(&unKnownConnectionTimeout,SIGNAL(timeout()),this,SLOT(initConnectionTimeout()));	
}

cI2PStream::~ cI2PStream()
{
	if(timer!=NULL){
		delete timer;
	}
	
	disconnect(&tcpSocket,SIGNAL(disconnected()),this,SLOT(disconnected()) );
	doDisconnect();


	if(Analyser!=NULL){
		delete Analyser;
	}
	
	delete IncomingPackets;	
}

bool cI2PStream::doConnect(QString Destination)
{
	if(Mode!=CONNECT){
		return false;
	}

	this->Destination=Destination;
	this->ModeStreamConnect=true;
	this->ModeStreamAccept=false;
	
	if(tcpSocket.state()!=QAbstractSocket::UnconnectedState) return false;

	tcpSocket.connectToHost(SamHost,SamPort.toInt( ));
	if(!tcpSocket.waitForConnected(1000))
		disconnected();

	return true;
}

bool cI2PStream::doAccept()
{
	if(Mode!=ACCEPT){ 
		return false;
	}
	
	this->Destination="";
	this->ModeStreamConnect=false;
	this->ModeStreamAccept=true;
	
	if(tcpSocket.state()!=QAbstractSocket::UnconnectedState) return false;

	tcpSocket.connectToHost(SamHost,SamPort.toInt( ));
	if(!tcpSocket.waitForConnected(1000))
		disconnected();
	
	return true;
}

void cI2PStream::connected()
{
	QString sID=QString::number(ID,10);

	emit debugMessages("<-- I2PStream connected to SAMV3 (ID="+sID+")-->\n");	
	doneDisconnect=false;
	emit debugMessages("<OUTGOING TO StreamID: "+sID+">\n"+SAM_HANDSHAKE_V3);
	tcpSocket.write(SAM_HANDSHAKE_V3);
	tcpSocket.flush();

}

void cI2PStream::disconnected()
{
	QString sID=QString::number(ID,10);

	StatusRecived=false;
	DestinationRecived=false;
	doneDisconnect=false;
	HandShakeWasSuccesfullDone=false;
	FIRSTPAKETCHAT_allreadySended=false;

	unKnownConnectionTimeout.stop();

	emit debugMessages("<-- I2PStream disconnected from SAMV3 (ID="+sID+")-->\n");
	emit StreamStatusRecived(SAM_Message_Types::CLOSED,ID,"");
	
}

void cI2PStream::readFromSocket()
{	
	using namespace SAM_Message_Types;
	QString sID=QString::number(ID,10);
	QByteArray newData;
	if(tcpSocket.state()==QTcpSocket::ConnectedState)
	{
		newData =tcpSocket.readAll();
	}
	else{
		return;
	}
	emit debugMessages("<INCOMING FROM StreamID: "+sID+">\n"+newData+"\n");
	
	if(HandShakeWasSuccesfullDone==false){
		
		IncomingPackets->append(newData);
		if(IncomingPackets->indexOf("\n",0)==-1){
			//Not the complead Packet recived ??? maybe possible ???
			return;
		}
		
		QByteArray CurrentPacket;
		CurrentPacket=IncomingPackets->left(IncomingPackets->indexOf("\n",0)+1);
		

		Analyser= new I2PSamMessageAnalyser();
				
		QString t(CurrentPacket.data());				
		SAM_MESSAGE sam=Analyser->Analyse(t);
		if(sam.type==HELLO_REPLAY && sam.result==OK){
			HandShakeWasSuccesfullDone=true;
		}
		
		delete Analyser;
		Analyser=NULL;
		QByteArray Data;
		

		if(Mode==ACCEPT){
			Data.append("STREAM ACCEPT ID="+StreamBridgeName);
		}
		else if(Mode==CONNECT){
			Data.append("STREAM CONNECT ID="+StreamBridgeName+" DESTINATION="+Destination);
		}
		
		if(Silence==true){
			Data.append(" Silence=true\n");
		}
		else{
			Data.append(" Silence=false\n");
		}

		IncomingPackets->remove(0,IncomingPackets->indexOf("\n",0)+1);
		*(this)<<Data;
	}
	else if(StatusRecived==false)
	{	
		IncomingPackets->append(newData);
		if(IncomingPackets->indexOf("\n",0)==-1){
			//Not the complead Packet recived ??? maybe possible ???
			return;
		}

		QByteArray CurrentPacket;
		CurrentPacket=IncomingPackets->left(IncomingPackets->indexOf("\n",0)+1);
	
		
		//Get Stream Status
		Analyser= new I2PSamMessageAnalyser();
		
		QString t(CurrentPacket.data());
		
		SAM_MESSAGE sam=Analyser->Analyse(t);
		emit StreamStatusRecived(sam.result,ID,sam.Message);
		
		delete Analyser;
		Analyser=NULL;
		StatusRecived=true;

		IncomingPackets->remove(0,IncomingPackets->indexOf("\n",0)+1);
		if(ModeStreamConnect==true){
			if(IncomingPackets->length()!=0){
				emit DataRecived(ID,*(IncomingPackets)); 
			}
		}
		

		
	}
	else if (StatusRecived==true && ModeStreamAccept==true && DestinationRecived==false){
		//get Destaintion
		IncomingPackets->append(newData);
		if(IncomingPackets->indexOf("\n",0)==-1){
			//Not the complead Packet recived ??? maybe possible ???
			return;
		}

		QByteArray CurrentPacket;
			CurrentPacket=IncomingPackets->left(IncomingPackets->indexOf("\n",0)+1);

		Destination=QString(CurrentPacket.data());
		Destination=Destination.trimmed();
		DestinationRecived=true;

		IncomingPackets->remove(0,IncomingPackets->indexOf("\n",0)+1);
		
		
		emit ModeAcceptIncomingStream(ID);
	
		if(IncomingPackets->length()!=0){
			emit DataRecived(ID,*(IncomingPackets)); 

		}

		//start unKnownConnectionTimeout
		unKnownConnectionTimeout.start();
		emit debugMessages("<-- I2PStream start unKnownConnectionTimeout (ID="+sID+")-->\n");
		//--------------------------------
	}
	else{
		emit  DataRecived(ID,newData); 
	}
}

void cI2PStream::doDisconnect()
{
	doneDisconnect=true;
	tcpSocket.disconnectFromHost();
}

QString cI2PStream::getDestination()
{
	return Destination;
}

qint32 cI2PStream::getID()
{
	return ID;
}

void cI2PStream::operator <<(const QByteArray Data)
{
	QString sID=QString::number(ID,10);

	if(tcpSocket.state()==QTcpSocket::ConnectedState&& HandShakeWasSuccesfullDone){
		emit debugMessages("<OUTGOING TO StreamID: "+sID+">\n"+Data+"\n");

		tcpSocket.write(Data);
		tcpSocket.flush();
	}
	else{
		QByteArray Message="<- I2PStream not connected, can't sent Data(StreamID: ";
		Message+=sID+" ) ->\n";
		emit debugMessages(Message);
	}
	
}
void cI2PStream::operator <<(const QString Data)
{
	QByteArray t="";
	t.insert(0,Data);
	
	*(this)<<t;
}

StreamMode cI2PStream::getStreamMode()
{
	return Mode;
}


Type cI2PStream::getConnectionType() const
{
	return connectionType;
}


void cI2PStream::setConnectionType ( const Type newTyp )
{
	QString sID=QString::number(ID,10);

	connectionType = newTyp;
	if(newTyp==KNOWN){
		unKnownConnectionTimeout.stop();
		emit debugMessages("<-- I2PStream stop unKnownConnectionTimeout,- ConnectionType change to KNOWN (ID="+sID+")-->\n");
	}
}

void cI2PStream::startUnlimintedReconnect(qint32 msec)
{
	if(timer==NULL) {
		timer= new QTimer();
		connect(timer,SIGNAL(timeout()),this,SLOT(checkForReconnect()));
	}
	timer->start(msec);	
}

void cI2PStream::stopUnlimintedReconnect()
{
	timer->stop();
	delete timer;
	timer=NULL;
}

void cI2PStream::checkForReconnect()
{
	timer->stop();
	if(Mode==CONNECT){
		doConnect(Destination);
	}

	
	timer->start();
}

void cI2PStream::initConnectionTimeout()
{
	QString sID=QString::number(ID,10);
	emit debugMessages("<-- I2PStream initConnection Timeout, close connection Stream ID("+sID+")-->\n");
	doDisconnect();	
}

bool cI2PStream::getFIRSTPAKETCHAT_allreadySended() const
{
	return FIRSTPAKETCHAT_allreadySended;
}


void cI2PStream::setFIRSTPAKETCHAT_allreadySended ( bool theValue )
{
	FIRSTPAKETCHAT_allreadySended = theValue;
}
#undef SAM_HANDSHAKE_V3