/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "FileTransferSend.h"
#include "gui/form_fileSend.h"
#include "Core.h"

cFileTransferSend::cFileTransferSend(cCore * Core,cConnectionManager* ConnectionManager, QString FilePath,QString Destination)
:FilePath(FilePath),Destination(Destination)
{
	this->Core=Core;
	this->ConnectionManager=ConnectionManager;
	this->Stream=(cI2PStream*)ConnectionManager->CreateNewStreamObject(CONNECT,false);

	connect(Stream,SIGNAL(StreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)),this,
		SLOT(StreamStatus(const SAM_Message_Types::RESULT, const qint32, QString)));
	
	connect(Stream,SIGNAL(DataRecived(const qint32, const QByteArray)),this,
		SLOT(DataRecive(const qint32, QByteArray)));

	StreamID=Stream->getID();
	Core->set_StreamTypeToKnown(StreamID,NULL,true);
	Stream->doConnect(Destination);
	
	
	haveAllreadyAWindow=false;
	sendFirstPaket=true;
	FileName=FilePath.mid(FilePath.lastIndexOf("/")+1);
	FileTransferAccepted=false;
	FileForSend  = new QFile(FilePath);
	FileSize=FileForSend->size();
	allreadySendedSize=0;
}

void cFileTransferSend::abbortFileSend()
{
	FileForSend->close();
	Core->removeFileTransfer(StreamID);
	ConnectionManager->DestroyStreamObjectByID(Stream->getID());

}

void cFileTransferSend::StreamStatus(const SAM_Message_Types::RESULT result, const qint32 ID, QString Message)
{
	using namespace FileTransferProtocol;	


	switch(result){
		case (SAM_Message_Types::OK):{
			if(sendFirstPaket==true){
				QString StringFileSize;
				StringFileSize.setNum(FileSize);
	
				Stream->operator <<(FIRSTPAKET+StringFileSize+"\n"+FileName);
				sendFirstPaket=false;
			}
			break;
		}
		
		case (SAM_Message_Types::CANT_REACH_PEER):
		case (SAM_Message_Types::TIMEOUT):
		case (SAM_Message_Types::CLOSED):{
			if(allreadySendedSize==FileSize){
			emit event_FileTransferFinishedOK();	
			Core->get_UserByI2P_Destination(Destination)->
				IncomingMessageFromSystem("Filetransfer finished (OK)<br>FileName: "+FileName+"<br>");
			}
			else{
				emit event_FileTransferAborted();
				if(allreadySendedSize==0){
					Core->get_UserByI2P_Destination(Destination)->
					IncomingMessageFromSystem("Can't connect the User for Filetransfer<br>Filename: "+FileName);
				}
				else
				{
					Core->get_UserByI2P_Destination(Destination)->
						IncomingMessageFromSystem("The Reciver abort the Filerecive<br>Filename: "+FileName);
				}
			}
			FileForSend->close();
			ConnectionManager->DestroyStreamObjectByID(StreamID);
			Core->removeFileTransfer(StreamID);

			break;
		}
		case (SAM_Message_Types::I2P_ERROR):{
			emit event_FileTransferAborted();
			Core->get_UserByI2P_Destination(Destination)->
				IncomingMessageFromSystem("Filetransfer: "+FileName+"Stream get a I2P_ERROR:<br>"+Message);

			FileForSend->close();
			ConnectionManager->DestroyStreamObjectByID(StreamID);
			Core->removeFileTransfer(StreamID);
			break;
		}
		case (SAM_Message_Types::INVALID_KEY):{
			emit event_FileTransferAborted();
			Core->get_UserByI2P_Destination(Destination)->
				IncomingMessageFromSystem("Filetransfer: "+FileName+"Stream get a INVALID_KEY ERROR:<br>"+Message);

			FileForSend->close();
			ConnectionManager->DestroyStreamObjectByID(StreamID);
			Core->removeFileTransfer(StreamID);
			break;
		}
		case (SAM_Message_Types::INVALID_ID):{
			emit event_FileTransferAborted();
			Core->get_UserByI2P_Destination(Destination)->
				IncomingMessageFromSystem("Filetransfer: "+FileName+"Stream get a INVALID_ID ERROR:<br>"+Message);
			
			FileForSend->close();
			ConnectionManager->DestroyStreamObjectByID(StreamID);
			Core->removeFileTransfer(StreamID);
			break;
		}
		default:{
			break;
		}
	}
}
cFileTransferSend::~ cFileTransferSend()
{
	delete FileForSend;
}

void cFileTransferSend::DataRecive(const qint32 ID,QByteArray t)
{
	if(t.length()==1){

		if(t.contains("0")){//true
			emit event_FileTransferAccepted(true);
			FileTransferAccepted=true;
			StartFileTransfer();
			
		}
		else{
			emit event_FileTransferAccepted(false);
			Core->get_UserByI2P_Destination(Destination)->
				IncomingMessageFromSystem("Filetransfer don't accepted,filesending abborted<br>Filename: "+FileName);
			ConnectionManager->DestroyStreamObjectByID(ID);
			Core->removeFileTransfer(StreamID);
			
		}
	}
	else{
		emit event_FileTransferAccepted(false);
		Core->get_UserByI2P_Destination(Destination)->
				IncomingMessageFromSystem("Filetransfer don't accepted,filesending abborted<br>Filename: "+FileName);
		ConnectionManager->DestroyStreamObjectByID(ID);
		Core->removeFileTransfer(StreamID);
	}

}

void cFileTransferSend::StartFileTransfer()
{
	allreadySendedSize=0;
	FileForSend->open(QIODevice::ReadOnly);
	SendFile();

}

void cFileTransferSend::set_haveAllreadyAWindow(bool b)
{
	haveAllreadyAWindow=b;
	if(b==true && FileTransferAccepted==true)
		emit event_FileTransferAccepted(FileTransferAccepted);
}

void cFileTransferSend::SendFile()
{
	while(allreadySendedSize<FileSize){
		QByteArray Buffer;

		Buffer=FileForSend->read(MAXPAKETSIZE);
		allreadySendedSize+=Buffer.length();

		Stream->operator <<(Buffer);
		emit event_allreadySendedSizeChanged(allreadySendedSize);	
	}

	emit event_FileTransferFinishedOK();
	Core->get_UserByI2P_Destination(Destination)->
			IncomingMessageFromSystem("Filetransfer Finished (OK)<br>FileName: "+FileName+"<br>");

	return;
}
