/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FILETRANSFER_H
#define FILETRANSFER_H

#include "I2PStream.h"
#include <QtGui>

class cCore;
class cFileTransferRecive:public QObject
{
	Q_OBJECT
	public:
	cFileTransferRecive(cCore* Core,cI2PStream* Stream,qint32 StreamID,QString FileName,quint64 FileSize,QString Destination);
	~cFileTransferRecive();
	void start(QString FilePath,bool Accepted);
	void set_haveAllreadyAWindow(bool b){haveAllreadyAWindow=b;};
	
	quint64 get_FileSize(){return FileSize;};
	QString get_FileName(){return FileName;};
	QString get_Destination(){return Destination;};
	qint32 	get_StreamID(){return StreamID;};
	bool 	CheckIfAllreadyHaveAWindow(){return haveAllreadyAWindow; };
	bool 	checkIfAllreadyAcceptTheRequest(){return RequestAccepted;};

	public slots:
	void abbortFileRecive();

	private slots:
	void StreamStatusRecived(const SAM_Message_Types::RESULT result,const qint32 ID,QString Message);
	void DataRecive (const qint32 ID, QByteArray t );

	signals:
	void event_allreadyRecivedSizeChanged(quint64 Size);
	void event_FileReciveError();
	void event_FileRecivedFinishedOK();
	void event_FileReciveAborted();

	private:
	cCore* Core;
	cI2PStream* Stream;
	const quint64 FileSize;
	quint64 allreadyRecivedSize;
	const QString FileName;
	const qint32 StreamID;
	QFile* FileForRecive;
	const QString Destination;
	bool haveAllreadyAWindow;
	bool RequestAccepted;
};
#endif