/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "Core.h"
#include "FileTransferRecive.h"



cFileTransferRecive::cFileTransferRecive(cCore * Core,cI2PStream* Stream, qint32 StreamID, QString FileName, quint64 FileSize,QString Destination)
:StreamID(StreamID),FileName(FileName),FileSize(FileSize),Destination(Destination)
{
	QSettings settings(QApplication::applicationDirPath()+"/application.ini",QSettings::IniFormat);
	bool AutoAcceptFileRecive=false;
	QString AutoAcceptedFilePath;

	this->Core=Core;
	this->Stream=Stream;
	this->FileForRecive=NULL;

	connect(Stream,SIGNAL(StreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)),this,
		SLOT(StreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)));

	connect(Stream,SIGNAL(DataRecived(const qint32, const QByteArray)),this,
		SLOT(DataRecive(const qint32, QByteArray)));

	allreadyRecivedSize=0;
	haveAllreadyAWindow=false;
	RequestAccepted=false;
	
	settings.beginGroup("General");
		AutoAcceptFileRecive=(settings.value("AutoAcceptFileRecive",false).toBool());
		AutoAcceptedFilePath=(settings.value("IncomingFileFolder", QApplication::applicationDirPath()+"/Incoming").toString());
	settings.endGroup();


	if(AutoAcceptFileRecive==true){
		Core->get_UserByI2P_Destination(Destination)->
			IncomingMessageFromSystem(" Autoaccepted incoming Filetransfer<br>Filename: "+FileName);

		QDir dir(AutoAcceptedFilePath);
 		if (!dir.exists()){
			dir.mkdir(AutoAcceptedFilePath);
		}
		
		start(AutoAcceptedFilePath+"/"+FileName,true);
	}
	else{
		Core->get_UserByI2P_Destination(Destination)->
			IncomingMessageFromSystem(" Incoming Filetransfer<br>Filename: "+FileName+
				"<br>please accept or  don't accepted it (you can do it at the Userlist)");

	}
}

cFileTransferRecive::~ cFileTransferRecive()
{
	if(FileForRecive!=NULL){
		delete FileForRecive;
	}
}

void cFileTransferRecive::StreamStatusRecived(const SAM_Message_Types::RESULT result, const qint32 ID, QString Message)
{

	switch(result){
		case (SAM_Message_Types::OK):{
			break;
		}
		
		case (SAM_Message_Types::CANT_REACH_PEER):
		case (SAM_Message_Types::TIMEOUT):
		case (SAM_Message_Types::CLOSED):{
			if(allreadyRecivedSize==FileSize){
				emit event_FileRecivedFinishedOK();

				QString SizeName;
				QString SSize;		
				
				if(FileSize>=(1024*1024)){
				//MB
					QString MB;
					QString KB;
			
					qint32 tmp= FileSize/(1024*1024);
					qint32 tmp2=FileSize-(tmp*(1024*1024));
					tmp2 =qRound(tmp2/1024);
					
					MB.setNum(tmp,10);
					KB.setNum(tmp2,10);
					
					SSize=MB+"."+KB;
					SizeName="MB";
				}
				else if(FileSize>=1024){
				//KB
					QString KB;
					QString Bytes;
			
					qint32 tmp= FileSize/(1024);
					qint32 tmp2=FileSize-(tmp*(1024));
					tmp2 =qRound(tmp2/1024);
			
					KB.setNum(tmp,10);
					Bytes.setNum(tmp2,10);
			
					SSize=KB+"."+Bytes;
					SizeName="KB";
				}
				else{
				//Byte
					SSize.setNum(FileSize,10);
					SizeName="Bytes";
			
				}
				Core->get_UserByI2P_Destination(Destination)->
					IncomingMessageFromSystem(" Filetransfer finished (OK)<br>Filename: "+FileName+"<br>Filesize: "+SSize+" "+SizeName);	
			}
			else{
				emit event_FileReciveAborted();
				if(RequestAccepted==true){
					Core->get_UserByI2P_Destination(Destination)->
						IncomingMessageFromSystem("The Sender abort the Filetransfer<br>FileName: "+FileName +"<br>incomplead File deleted");
				}
				else{
					Core->get_UserByI2P_Destination(Destination)->
						IncomingMessageFromSystem("You abborted the Filerecive<br>FileName: "+FileName +"<br>incomplead File deleted");
				}
			
			}
			if(FileForRecive!=NULL){
				FileForRecive->close();
			}
			Core->DestroyStreamObjectByID(StreamID);
			Core->removeFileRecive(StreamID);
			break;
		}
		case (SAM_Message_Types::I2P_ERROR):{
			emit event_FileReciveAborted();
			Core->get_UserByI2P_Destination(Destination)->
				IncomingMessageFromSystem("Filerecive: "+FileName+"Stream get a I2P_ERROR:<br>"+Message);
			if(FileForRecive!=NULL){
				FileForRecive->close();
			}
			Core->DestroyStreamObjectByID(StreamID);
			Core->removeFileRecive(StreamID);
			break;
		}
		case (SAM_Message_Types::INVALID_KEY):{
			emit event_FileReciveAborted();
			Core->get_UserByI2P_Destination(Destination)->
				IncomingMessageFromSystem("Filerecive: "+FileName+"Stream get a INVALID_KEY ERROR:<br>"+Message);

			if(FileForRecive!=NULL){
				FileForRecive->close();
			}
			Core->DestroyStreamObjectByID(StreamID);
			Core->removeFileRecive(StreamID);
			break;
		}
		case (SAM_Message_Types::INVALID_ID):{
			emit event_FileReciveAborted();
			Core->get_UserByI2P_Destination(Destination)->
				IncomingMessageFromSystem("Filerecive: "+FileName+"Stream get a INVALID_ID ERROR:<br>"+Message);
			
			if(FileForRecive!=NULL){
				FileForRecive->close();
			}
			Core->DestroyStreamObjectByID(StreamID);
			Core->removeFileRecive(StreamID);
			break;
		}
		default:{
			break;
		}
	}

}

void cFileTransferRecive::DataRecive (const qint32 ID, QByteArray t )
{

	allreadyRecivedSize+=t.length();
	FileForRecive->write(t);
	FileForRecive->flush();

	emit event_allreadyRecivedSizeChanged(allreadyRecivedSize);

	if(allreadyRecivedSize==FileSize)
	{

		QString SizeName;
		QString SSize;

		FileForRecive->close();	

		if(FileSize>=(1024*1024)){
		//MB
			QString MB;
			QString KB;
	
			qint32 tmp= FileSize/(1024*1024);
			qint32 tmp2=FileSize-(tmp*(1024*1024));
			tmp2 =qRound(tmp2/1024);
			
			MB.setNum(tmp,10);
			KB.setNum(tmp2,10);
			
			SSize=MB+"."+KB;
			SizeName="MB";
		}
		else if(FileSize>=1024){
		//KB
			QString KB;
			QString Bytes;
	
			qint32 tmp= FileSize/(1024);
			qint32 tmp2=FileSize-(tmp*(1024));
			tmp2 =qRound(tmp2/1024);
	
			KB.setNum(tmp,10);
			Bytes.setNum(tmp2,10);
	
			SSize=KB+"."+Bytes;
			SizeName="KB";
		}
		else{
		//Byte
			SSize.setNum(FileSize,10);
			SizeName="Bytes";
	
		}
		Core->get_UserByI2P_Destination(Destination)->
			IncomingMessageFromSystem("<br>Filetransfer finished (OK)<br>Filename: "+FileName+"<br>Filesize: "+SSize+" "+SizeName);

		FileForRecive->close();
		Core->removeFileRecive(StreamID);
		Core->DestroyStreamObjectByID(StreamID);

		emit event_FileRecivedFinishedOK();	
	}
}

void cFileTransferRecive::abbortFileRecive()
{
	if(FileForRecive!=NULL){
		FileForRecive->close();
		FileForRecive->remove();
	}

	Core->DestroyStreamObjectByID(StreamID);
	Core->removeFileRecive(StreamID);
	
}

void cFileTransferRecive::start(QString FilePath,bool Accepted)
{	
	if(Accepted==true){	
		FileForRecive= new QFile(FilePath);
		FileForRecive->open(QIODevice::WriteOnly);

		Stream->operator <<(QString("0"));//true
		RequestAccepted=true;
	}
	else{
		

		Stream->operator <<(QString("1"));//false
		Core->DestroyStreamObjectByID(StreamID);
		Core->removeFileRecive(StreamID);

		RequestAccepted=false;
	}
}
