/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CORE_H
#define CORE_H

#include <QtGui>
#include <QSettings>
#include <QtXml>
#include <QTextStream>
#include <QList>

#include "User.h"
#include "ConnectionManager.h"
#include "DebugMessageManager.h"
#include "I2PSamMessageAnalyser.h"

#include "Protocol.h"
#include "PacketManager.h"
#include "FileTransferSend.h"
#include "FileTransferRecive.h"
#include "SoundManager.h"
#include "I2PStream.h"

#define CLIENTVERSION "0.2.12 Beta"
#define CLIENTNAME "I2P-Messenger (QT)"


using namespace SAM_Message_Types;
using namespace User;
class cUserConnectThread;
class cCore :public QObject
{

		Q_OBJECT
	public:
		cCore();
		~cCore();
		cDebugMessageManager* get_DebugMessageHandler();
		const QList<cUser*> get_userList();
		const QList<cFileTransferRecive*> get_FileTransferReciveList();
		const QList<cFileTransferSend*>   get_FileSendsList();

		bool checkIfAFileTransferOrReciveisActive();
		bool doesUserAllReadyExitsByI2PDestination ( QString I2PDestination );

		QString 		get_UserProtocolVersionByStreamID ( qint32 ID );
		cUser* 			get_UserByI2P_ID ( qint32 ID );
		cUser* 			get_UserByI2P_Destination ( QString Destination );
		QString 		get_DestinationByID(qint32 ID);
		const QString 		get_MyDestination() const;
		ONLINESTATE 		get_OnlineStatus()const;
		QString 		get_ClientName() {return CLIENTNAME;};
		QString 		get_ClientVersion(){return CLIENTVERSION;};
		QString 		get_ProtocolVersion(){return Protocol->get_ProtocolVersion();};
		cFileTransferRecive*	get_FileTransferReciveByID(qint32 ID);
		cFileTransferSend*	get_get_FileSendsByID(qint32 ID);
		QString			get_UserInfosByI2P_Destination(QString Destination);
		const cI2PStream* 	get_I2PStreamObjectByID(qint32 ID);
		
		void changeUserPositionInUserList(int oldPos,int newPos);
		void set_UserProtocolVersionByStreamID ( qint32 ID,QString Version );
		void set_OnlineStatus(const ONLINESTATE newStatus);
		void set_StreamTypeToKnown(qint32 ID,const QByteArray Data,bool isFileTransfer_Recive=false);

		void addNewFileTransfer(QString FilePath,QString Destination);
		void addNewFileRecive(qint32 ID,QString FileName,QString FileSize,QString Destination);

		void removeFileTransfer(const qint32 ID);
		void removeFileRecive  (const qint32 ID);
		
		void removeUnknownIDCreateUserIfNeeded( const qint32 ID,const QString ProtocolVersion );
		void DestroyStreamObjectByID(qint32 ID);
		bool UseThisChatConnection(const QString Destination,const qint32 ID);
			
		

	public slots:
		bool addNewUser (QString Name,QString I2PDestination,qint32 I2PStream_ID=0);
		bool deleteUserByI2PDestination (const QString I2PDestination );
		bool renameuserByI2PDestination (const QString Destination, const QString newNickname);
		void doNamingLookUP ( QString Name );
		void MuteSound(bool t);
		

		QString get_connectionDump();

	private slots:
		// <SIGNALS FROM STREAM CONTROLLER>
		void StreamStatusRecived ( const SAM_Message_Types::RESULT result,const qint32 ID,QString Message );
		void NamingReplyRecived ( const SAM_Message_Types::RESULT result,QString Name,QString Value="",QString Message="" );
		void StreamControllerStatusOK(bool Status);
		void IncomingStream(cI2PStream* stream);
		void NewSamPrivKeyGenerated(const QString SamPrivKey);
	signals:
		void eventUserChanged();
		void eventOnlineStatusChanged();

	private:
		cConnectionManager* ConnectionManager;
		cDebugMessageManager* DebugMessageHandler;
		cProtocol* Protocol;
		QList<cUser*> users;
		QString MyDestination;
		QList<cPacketManager*> DataPacketsManagers;
		ONLINESTATE currentOnlineStatus;
		ONLINESTATE nextOnlineStatus;

		QList<cFileTransferSend*> FileSends;
		QList<cFileTransferRecive*> FileRecives;
		cSoundManager* SoundManager;

		
		void init();
		void saveUserList();
		void loadUserList();
		void stopCore();
		void restartCore();
		void closeAllActiveConnections();
		void deletePacketManagerByID ( qint32 ID );
		void createOpenStreamObjectsForUsers();
		void createStreamObjectForUser(cUser& User);

		bool isThisID_a_FileSendID(qint32 ID);
		bool isThisID_a_FileReciveID(qint32 ID);
		

};
#endif