/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "Core.h"
#include "I2PStream.h"

cCore::cCore(){
	ConnectionManager=NULL;
	DebugMessageHandler=NULL;
	Protocol=NULL;
	SoundManager=new cSoundManager();
	Protocol= new cProtocol(this);
	this->currentOnlineStatus=User::USEROFFLINE;

	if(users.count()==0){
		this->loadUserList();
	}
}

cCore::~cCore(){
	this->saveUserList();
	this->closeAllActiveConnections();
	for(int i=0;i<this->users.count();i++)
		delete users.at(i);

		
	QList<cPacketManager*>::Iterator it;
	for(it=DataPacketsManagers.begin(); it<DataPacketsManagers.end() ;++it){
		DataPacketsManagers.erase(it);
	}
	
	if(DebugMessageHandler!=NULL){	
		delete this->DebugMessageHandler;
	}

	if(Protocol!=NULL){
		delete this->Protocol;
	}

	if(ConnectionManager!=NULL) {
		delete this->ConnectionManager;
	}
	if(SoundManager!=NULL){
		delete this->SoundManager;
	}
}

cDebugMessageManager* cCore::get_DebugMessageHandler(){
	return this->DebugMessageHandler;
}

bool cCore::addNewUser(QString Name,QString I2PDestination,qint32 I2PStream_ID){
	//check if user already exist
	if(I2PDestination.length()!=516){
		//Destination must be 516 length
		return false;
	}
	
	
	if(!I2PDestination.right(4).contains("AAAA",Qt::CaseInsensitive)){
		//the last 4 char must be "AAAA"
		return false;
	}


	if(I2PDestination.length()>0)
		if(this->doesUserAllReadyExitsByI2PDestination(I2PDestination)==true)
			return false;


	//add newuser
	cUser* newuser=new cUser(Protocol,Name,I2PDestination,I2PStream_ID);
	connect(newuser,SIGNAL(newIncomingMessageRecived()),SoundManager,
		SLOT(event_NewChatMessage()));

	connect(newuser,SIGNAL(connectionOnline()),SoundManager,
		SLOT(event_User_go_Online()));

	connect(newuser,SIGNAL(connectionOffline()),SoundManager,
		SLOT(event_User_go_Offline()));


	this->users.append(newuser);
	saveUserList();

	if(currentOnlineStatus!=USEROFFLINE && currentOnlineStatus!=USERTRYTOCONNECT){
		if(ConnectionManager!=NULL && I2PStream_ID==0){
			createStreamObjectForUser(*newuser);
		}
	}
	emit eventUserChanged();
	return true;
}

bool cCore::deleteUserByI2PDestination(QString I2PDestination){
	for(int i=0;i<users.count();i++){
		if(users.at(i)->get_I2PDestination()==I2PDestination){
			if(users.at(i)->get_ConnectionStatus()==ONLINE ||users.at(i)->get_ConnectionStatus()==TRYTOCONNECT)
			{
				deletePacketManagerByID(users.at(i)->get_I2PStreamID());
				ConnectionManager->DestroyStreamObjectByID(users.at(i)->get_I2PStreamID());
			}
			
			if(ConnectionManager!=NULL){
				ConnectionManager->DestroyStreamObjectByID(users.at(i)->get_I2PStreamID());
			}

			users.removeAt(i);
			saveUserList();
			emit eventUserChanged();
			return true;
		}
	}
	return false;
}


bool cCore::doesUserAllReadyExitsByI2PDestination(const QString I2PDestination){
	if(I2PDestination==MyDestination) return true;

	for(int i=0;i<users.count();i++){
		if(users.at(i)->get_I2PDestination()==I2PDestination){
			
			return true;
		}
	}
	
	return false;
}
void cCore::doNamingLookUP(QString Name){
	ConnectionManager->doNamingLookUP(Name);
}

void cCore::init(){
	using namespace SESSION_ENUMS;

	this->MyDestination="";
	

	QSettings* settings= new QSettings(QApplication::applicationDirPath()+"/application.ini",QSettings::IniFormat);
	settings->beginGroup("Network");

	if(ConnectionManager==NULL){
		QString SamPrivKey;
		SamPrivKey=settings->value("SamPrivKey","").toString();

		this->ConnectionManager= new cConnectionManager(
						settings->value("SamHost","127.0.0.1").toString(),
						settings->value("SamPort","7656").toString());
	
		if(DebugMessageHandler==NULL){
			this->DebugMessageHandler= new cDebugMessageManager(ConnectionManager);
		}
		else{
			this->DebugMessageHandler->reInit(ConnectionManager);
		}


		this->ConnectionManager->doCreateSession(
			STREAM,
			SamPrivKey,
			settings->value("SessionOptionString","inbound.nickname=I2P-Messenger inbound.quantity=1 inbound.backupQuantity=1 inbound.length=1 outbound.quantity=1 outbound.backupQuantity=1 outbound.length=1").toString());
	
		connect (ConnectionManager,SIGNAL(NamingReplyRecived(const SAM_Message_Types::RESULT, QString, QString, QString)),this,
			SLOT(NamingReplyRecived(const SAM_Message_Types::RESULT, QString, QString, QString)),Qt::DirectConnection);
	
		connect (ConnectionManager,SIGNAL(StreamControllerStatusOK(bool)),this,
			SLOT(StreamControllerStatusOK(bool)));

		connect (ConnectionManager,SIGNAL(NewSamPrivKeyGenerated(const QString)),this,
			SLOT(NewSamPrivKeyGenerated(const QString)));
	
		connect (ConnectionManager,SIGNAL(StreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)),this,
			SLOT(StreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, QString)));
		
		connect(ConnectionManager,SIGNAL(IncomingStream(cI2PStream*)),this,
			SLOT(IncomingStream(cI2PStream*)));

		if(settings->contains("Destination")){
			settings->remove("Destination");
		}
		

	}
	settings->endGroup();
	
			
	if(Protocol==NULL){
		this->Protocol= new cProtocol(this);
	}
	
	delete settings;	
}
void cCore::saveUserList(){
     QFile file(QApplication::applicationDirPath()+"/users.config");
     file.open(QIODevice::WriteOnly | QIODevice::Text);
     QTextStream out(&file);

	for(int i=0;i<this->users.count();i++){		
		out<<"Nick:\t"<<(users.at(i)->get_Name())<<endl
		<<"I2PDest:\t"<<(users.at(i)->get_I2PDestination())<<endl;
	}
	out.flush();
	file.close();
}
void cCore::loadUserList(){
	QFile file(QApplication::applicationDirPath()+"/users.config");
     	if (!file.open(QIODevice::ReadOnly|QIODevice::Text))
		return;

 	QTextStream in(&file);
	in.skipWhiteSpace();
	QString NickName;QString I2PDest;
     	while (!in.atEnd()) {
		QString line = in.readLine();
		QStringList temp=line.split("\t");
	
		if(temp[0]=="Nick:")NickName=temp[1];	
		if(temp[0]=="I2PDest:"){
			I2PDest=temp[1];
			this->addNewUser(NickName,I2PDest);
			NickName.clear();
			I2PDest.clear();
		}
		else if(temp[0]=="TorDest:"){
			//ignore it
		}
	file.close();	
	}
}

void cCore::StreamStatusRecived(const SAM_Message_Types::RESULT result,const qint32 ID,QString Message){

	cI2PStream* stream=(cI2PStream*)ConnectionManager->getStreamObjectByID(ID);
	cUser* user=NULL;
	QString Destination;

	if(stream==NULL){
		//Stream where delete,- asyn SIGNAL/SLOT
		return;
	}

	if(stream!=NULL){
		Destination=stream->getDestination();
		user=this->get_UserByI2P_ID(ID);
	}

	if(result==SAM_Message_Types::OK && ID>0){
		if(isThisID_a_FileSendID(ID)==false){
			Protocol->newConnectionChat(ID);
		}
	}
	else if( result==SAM_Message_Types::CANT_REACH_PEER || 
			result==SAM_Message_Types::TIMEOUT
		){
		if(user==NULL){
			DestroyStreamObjectByID(ID);
			return;
		}
		else{
			if(user->get_OnlineState()!=USEROFFLINE && user->get_OnlineState()!=USERTRYTOCONNECT){
				user->IncomingMessageFromSystem("The Connection is broken: "+Message+"\nConnection closed");
			}
			deletePacketManagerByID(ID);
			user->set_ConnectionStatus(TRYTOCONNECT);
			user->set_OnlineState(USEROFFLINE);
			//reconnect stream
		}
	}
	else if( result==SAM_Message_Types::CLOSED){
		if(ID<0){
			//incoming stream
			QString Destination=stream->getDestination();

			//remove old stream
				deletePacketManagerByID(ID);
				DestroyStreamObjectByID(ID);
			//---------------------------

			if(user!=NULL && user->get_I2PStreamID()==ID){
				user->set_ConnectionStatus(OFFLINE);
				user->set_OnlineState(USEROFFLINE);
				//create a new outgoing stream for this user
				createStreamObjectForUser(*user);
			}
		}
		else{//ID>0
			//outgoing stream
			if(user!=NULL){
				user->set_ConnectionStatus(TRYTOCONNECT);
				user->set_OnlineState(USEROFFLINE);
			}
			stream->setConnectionType(UNKNOWN);
			connect(stream,SIGNAL(DataRecived(const qint32, const QByteArray)),Protocol,
			SLOT(inputUnknown(const qint32, const QByteArray)));
			deletePacketManagerByID(ID);
		}
	}


	else if(result==SAM_Message_Types::INVALID_KEY){
		if(user==NULL){
			DestroyStreamObjectByID(ID);
			return;
		}	
		user->IncomingMessageFromSystem("Invalid User - Destination: please delete the user\n");
		deletePacketManagerByID(ID);
		DestroyStreamObjectByID(ID);
		user->set_ConnectionStatus(ERROR);

	}
	else if(result==SAM_Message_Types::I2P_ERROR){
		if(user==NULL){
			DestroyStreamObjectByID(ID);
			return;
		}
		user->IncomingMessageFromSystem("I2P_Error: "+Message);
		deletePacketManagerByID(ID);
		DestroyStreamObjectByID(ID);
		user->set_ConnectionStatus(ERROR);
	}

	emit eventUserChanged();
}

QString cCore::get_UserProtocolVersionByStreamID(qint32 ID){

	for(int i=0;i< users.size();i++)
		if(users.at(i)->get_I2PStreamID()==ID){
			
			return users.at(i)->get_ProtocolVersion();
		}
	
	return "";
}
void cCore::set_UserProtocolVersionByStreamID(qint32 ID,QString Version){

	for(int i=0;i< users.size();i++)
		if(users.at(i)->get_I2PStreamID()==ID){
			users.at(i)->set_ProtocolVersion(Version);
			
			return;
		}
	
}

const QList<cUser*> cCore::get_userList(){
	return users;
}

void cCore::closeAllActiveConnections(){
	//close all known Online||TrytoConnect Connections

	for(int i=0;i<users.size();i++){
		if(users.at(i)->get_ConnectionStatus()==ONLINE ||
			users.at(i)->get_ConnectionStatus()==TRYTOCONNECT)
		{
			deletePacketManagerByID(users.at(i)->get_I2PStreamID());
			DestroyStreamObjectByID(users.at(i)->get_I2PStreamID());
			//I2P->doStreamClose(users.at(i)->get_I2PStreamID());
			//removeUnknownID(users.at(i)->get_I2PStreamID());
			users.at(i)->set_ConnectionStatus(User::OFFLINE);
			users.at(i)->set_OnlineState(USEROFFLINE);
				
		}
	}

	emit eventUserChanged();
}


cUser* cCore::get_UserByI2P_ID(qint32 ID){

	for(int i=0;i<users.size();i++){
		if(users.at(i)->get_I2PStreamID()==ID){
			
			return users.at(i);
		}
	}
	
	return NULL;
}
cUser* cCore::get_UserByI2P_Destination(QString Destination){

	for(int i=0;i<users.size();i++){
		if(users.at(i)->get_I2PDestination()==Destination){
			
			return users.at(i);
		}
	}
	
	return NULL;
}
void cCore::NamingReplyRecived(const SAM_Message_Types::RESULT result,QString Name,QString Value,QString Message){
	if(result==SAM_Message_Types::OK && Name=="ME")
		this->MyDestination=Value;
}
const QString cCore::get_MyDestination()const{
	return this->MyDestination;
}
	
void cCore::deletePacketManagerByID(qint32 ID){

	const cI2PStream* Stream=NULL;
	if(ConnectionManager!=NULL){
		Stream=ConnectionManager->getStreamObjectByID(ID);
	}
	
	QList<cPacketManager*>::Iterator it;
	for(it=DataPacketsManagers.begin(); it!=DataPacketsManagers.end() ;++it){
		if((*(it))->getID()==ID){
			//delete (*(it));
			if(Stream!=NULL){
				disconnect(Stream,SIGNAL(DataRecived(const qint32, const QByteArray)),(*(it)),
				SLOT(DataInput(qint32, QByteArray)));
			}

			DataPacketsManagers.erase(it);
			break;
			
		}
	}

}

QString cCore::get_connectionDump(){
	QString Message;
	QString StreamControllerBridgeName;

	if(ConnectionManager==NULL){
		Message="The Core is stopped !";
		return Message;
	}
	StreamControllerBridgeName=ConnectionManager->getStreamControllerBridgeName();

	Message="< Stream Controller >\n";
	Message+="\tNetwork:\tI2P\n";
	Message+="\tStreamControllerBridgeName:\t"+StreamControllerBridgeName+"\n";
	Message+="-----------------------------------------------\n\n";


	Message+="< Streams >\n";
	const QMap<qint32,cI2PStream*>* allStreams=ConnectionManager->getAllStreamObjects();
	const QList<cI2PStream*> allStreamsList=allStreams->values();
	


	for(int n=0;n<allStreamsList.size();n++){
		
		cI2PStream* Stream=allStreamsList.value(n);
		QString StreamID;
		cUser* theUser=NULL;
		
		StreamID.setNum(Stream->getID(),10);

		Message+="\n\tStreamID:\t"+StreamID+"\n";

		//Print StreamMode
		if(Stream->getStreamMode()==STREAMS::CONNECT){
			Message+="\tStreamMode:\tCONNECT\n";
		}
		else if(Stream->getStreamMode()==STREAMS::ACCEPT){
			Message+="\tStreamMode:\tACCEPT\n";
		}
		else{
			Message+="\tStreamMode:\t???\n";
		}
		//-----------------------------------------
	
			//Print ConnectionType		
			if(Stream->getConnectionType()==UNKNOWN){
				Message+="\tConnectionTrust:\tUNKNOWN\n";
			}
			else if (Stream->getConnectionType()==KNOWN){
				Message+="\tConnectionTrust:\tKNOWN\n";
			}
			else{
				Message+="\tConnectionTrust:\t???\n";
			}
			//------------------------------------------
		
		
		theUser=get_UserByI2P_ID(Stream->getID());
		if(theUser==NULL){
			Message+="\tUser: \n";
		}
		else{
			Message+="\tUser:\t\t"		+theUser->get_Name()+"\n";
			Message+="\tClientName:\t\t"	+theUser->get_ClientName()+"\n";
			Message+="\tClientVersion:\t\t"	+theUser->get_ClientVersion()+"\n";
			Message+="\tProtocolVersion:\t"	+theUser->get_ProtocolVersion()+"\n";
		}

	}
	Message+="-----------------------------------------------\n\n";

	return Message;
}

bool cCore::renameuserByI2PDestination(const QString Destination, const QString newNickname){
	for(int i=0;i<users.size();i++){
		if(users.at(i)->get_I2PDestination()==Destination){
			users.at(i)->set_Name(newNickname);
			saveUserList();
			emit eventUserChanged();
			return true;
		}
	}
	return false;
}

ONLINESTATE cCore::get_OnlineStatus() const
{
	return this->currentOnlineStatus;
}

void cCore::set_OnlineStatus(const ONLINESTATE newStatus)
{
	if(currentOnlineStatus==newStatus) return;

	if(currentOnlineStatus==USEROFFLINE){		
		nextOnlineStatus=newStatus;
		currentOnlineStatus=USERTRYTOCONNECT;
		init();
		emit eventOnlineStatusChanged();
		return;
	}
	

	if(newStatus==User::USEROFFLINE){
		this->currentOnlineStatus=newStatus;
		stopCore();
	}
	else if(newStatus==USERTRYTOCONNECT){
		if(currentOnlineStatus==USEROFFLINE)
		{
			this->currentOnlineStatus=newStatus;
			restartCore();	
		}
	}
	else
	{
		//send new Status to every connected User
		this->currentOnlineStatus=newStatus;

		for(int i=0;i<users.size();i++){
			if(users.at(i)->get_ConnectionStatus()==ONLINE)
			{
				switch(this->currentOnlineStatus)
				{
					case USERONLINE:
					{
						Protocol->send(USER_ONLINESTATUS_ONLINE,users.at(i)->get_I2PStreamID(),"");
						break;
					}
					case USEROFFLINE:
					{
						break;
					}
					case USERINVISIBLE:
					{
						Protocol->send(USER_ONLINESTATUS_OFFLINE,users.at(i)->get_I2PStreamID(),"");
						break;
					}
					case USERAWAY:
					{
						Protocol->send(USER_ONLINESTATUS_AWAY,users.at(i)->get_I2PStreamID(),"");
						break;
						
					}
					case USERWANTTOCHAT:
					{
						Protocol->send(USER_ONLINESTATUS_WANTTOCHAT,users.at(i)->get_I2PStreamID(),"");
						break;
					}
					case USERDONT_DISTURB:
					{
						Protocol->send(USER_ONLINESTATUS_DONT_DISTURB,users.at(i)->get_I2PStreamID(),"");
						break;
					}
					case USERTRYTOCONNECT:
					{
						break;
					}
					default:
					{
						QMessageBox* msgBox= new QMessageBox(NULL);
						msgBox->setIcon(QMessageBox::Warning);
						msgBox->setText("cCore(setOnlineStatus)");
						msgBox->setInformativeText("Unknown USERSTATE");
						msgBox->setStandardButtons(QMessageBox::Ok);
						msgBox->setDefaultButton(QMessageBox::Ok);
						msgBox->setWindowModality(Qt::NonModal);
						msgBox->show();
	
					}
				}
			
	
			}//if
		}//for
	}
	emit eventOnlineStatusChanged();
}

void cCore::stopCore()
{
	closeAllActiveConnections();

	delete ConnectionManager;
	ConnectionManager=NULL;
}

void cCore::restartCore()
{
	this->init();
}

void cCore::addNewFileTransfer(QString FilePath, QString Destination)
{
	cFileTransferSend * t= new cFileTransferSend(this,ConnectionManager,FilePath,Destination);
	connect (t,SIGNAL(event_FileTransferFinishedOK()),SoundManager,
		SLOT(event_FileSend_Finished()));

	FileSends.append(t);
	emit eventUserChanged();
}

bool cCore::isThisID_a_FileSendID(qint32 ID)
{
	for(int i=0;i<FileSends.size();i++){
		if(FileSends.at(i)->get_StreamID()==ID){
			return true;
		}
	}
	return false;
}

bool cCore::isThisID_a_FileReciveID(qint32 ID)
{
	for(int i=0;i<FileRecives.size();i++){
		if(FileRecives.at(i)->get_StreamID()==ID){
			return true;
		}
	}
	return false;
}

void cCore::addNewFileRecive(qint32 ID, QString FileName, QString FileSize,QString Destination)
{
	cI2PStream* Stream=(cI2PStream*)ConnectionManager->getStreamObjectByID(ID);

	quint64 Size;
	bool OK;
	Size=FileSize.toULongLong(&OK,10);
	if(OK==false)
	{
		QMessageBox* msgBox= new QMessageBox(NULL);
		msgBox->setIcon(QMessageBox::Critical);
		msgBox->setText("cCore(addNewFileRecive)");
		msgBox->setInformativeText("Error convert QString to Quint64\nValue: "+FileSize +"\nFilerecive aborted");
		msgBox->setStandardButtons(QMessageBox::Ok);
		msgBox->setDefaultButton(QMessageBox::Ok);
		msgBox->setWindowModality(Qt::NonModal);
		msgBox->show();

		//abort the Filerecive
		Stream->operator <<(QString("1"));//false
		ConnectionManager->DestroyStreamObjectByID(ID);
		removeFileRecive(ID);

		return;
	}
	SoundManager->event_FileRecive_Incoming();
	
	disconnect(Stream,SIGNAL(StreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)),this,
		SLOT(StreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, QString)));
	
	cFileTransferRecive* t= new cFileTransferRecive(this,Stream,ID,FileName,Size,Destination);
	connect(t,SIGNAL(event_FileRecivedFinishedOK()),SoundManager,
		SLOT(event_FileRecive_Finished()));

	FileRecives.append(t);
	emit eventUserChanged();

}

bool cCore::checkIfAFileTransferOrReciveisActive()
{
	if(FileSends.count()>0) return true;
	if(FileRecives.count()>0) return true;

	return false;
}

void cCore::MuteSound(bool t)
{
	SoundManager->doMute(t);
}

QString cCore::get_DestinationByID(qint32 ID)
{
	for(int i=0;i<users.size();i++){
		if(users.at(i)->get_I2PStreamID()==ID){
			return users.at(i)->get_I2PDestination();
		}
	}

	for(int i=0;i<FileSends.size();i++){
		if(FileSends.at(i)->get_StreamID()==ID){
			return FileSends.at(i)->get_Destination();
		}
	}
	
	for(int i=0;i<FileRecives.size();i++){
		if(FileRecives.at(i)->get_StreamID()==ID){
			return FileRecives.at(i)->get_Destination();
		}
	}

	return "";
}



const QList< cFileTransferRecive * > cCore::get_FileTransferReciveList()
{
	return FileRecives;
}

cFileTransferRecive * cCore::get_FileTransferReciveByID(qint32 ID)
{
	for(int i=0;i<FileRecives.size();i++){
		if(FileRecives.at(i)->get_StreamID()==ID){
			return FileRecives.at(i);
		}
	}
	return NULL;
}

const QList< cFileTransferSend * > cCore::get_FileSendsList()
{
	return FileSends;
}

cFileTransferSend * cCore::get_get_FileSendsByID(qint32 ID)
{
	for(int i=0;i<FileSends.size();i++){
		if(FileSends.at(i)->get_StreamID()==ID){
			return FileSends.at(i);
		}
	}
	return NULL;
}

QString cCore::get_UserInfosByI2P_Destination(QString Destination)
{
	QString Infos="No Informations recived";

	for(int i=0;i<users.size();i++){
		if(users.at(i)->get_I2PDestination()==Destination){
			Infos= "Nickname: "  		+users.at(i)->get_Name()+"\n";
			Infos+="Clientname: "		+users.at(i)->get_ClientName()+"\n";
			Infos+="Clientversion: "	+users.at(i)->get_ClientVersion()+"\n";
			Infos+="Protocolversion: "	+users.at(i)->get_ProtocolVersion()+"\n";
		}
	}
	return Infos;
}

void cCore::changeUserPositionInUserList(int oldPos, int newPos)
{
	users.swap(oldPos,newPos);
	saveUserList();
	emit eventUserChanged();
}

void cCore::StreamControllerStatusOK(bool Status)
{
	if(Status==true){
		currentOnlineStatus=nextOnlineStatus;
		emit eventOnlineStatusChanged();
		ConnectionManager->doNamingLookUP("ME");//get the current Destination from this client
		createOpenStreamObjectsForUsers();
	}

}


void cCore::createOpenStreamObjectsForUsers()
{
	for(int i=0;i<users.size();i++){
		if(ConnectionManager!=NULL){
			this->createStreamObjectForUser(*(users.at(i)));
		}
	}

}

void cCore::set_StreamTypeToKnown(qint32 ID,const QByteArray Data,bool isFileTransfer_Recive)
{
	cI2PStream* t=(cI2PStream*)ConnectionManager->getStreamObjectByID(ID);
	t->setConnectionType(KNOWN);
	disconnect(t,SIGNAL(DataRecived(const qint32, const QByteArray)),Protocol,
		SLOT(inputUnknown(const qint32, const QByteArray)));
	
	if(isFileTransfer_Recive==false){
		cPacketManager* packetManager= new cPacketManager(ID);
		connect(t,SIGNAL(DataRecived(const qint32, const QByteArray)),packetManager,
			SLOT(DataInput(qint32, QByteArray)));
		
		connect(packetManager,SIGNAL(aPacketIsComplead(const qint32, const QByteArray)),Protocol,
			SLOT(inputKnown(const qint32, const QByteArray)));

		if(Data.isEmpty()==false){
			packetManager->DataInput(ID,Data);
		}
		DataPacketsManagers.push_back(packetManager);
		
		
	}
	if(isFileTransfer_Recive==true){

	}

}

void cCore::DestroyStreamObjectByID(qint32 ID)
{
	ConnectionManager->DestroyStreamObjectByID(ID);
}

const cI2PStream * cCore::get_I2PStreamObjectByID(qint32 ID)
{
	return ConnectionManager->getStreamObjectByID(ID);
}

void cCore::IncomingStream(cI2PStream * stream)
{
	//all incoming stream are first Unknown
	connect(stream,SIGNAL(DataRecived(const qint32, const QByteArray)),Protocol,
			SLOT(inputUnknown(const qint32, const QByteArray)));
}

void cCore::createStreamObjectForUser(cUser& User)
{
	qint32 msec=0;
	qint32 ID=User.get_I2PStreamID();

	if(ConnectionManager==NULL) return;

	if(ConnectionManager->getStreamObjectByID(ID)!=NULL){
		return;
	}

	QSettings* settings= new QSettings(QApplication::applicationDirPath()+"/application.ini",QSettings::IniFormat);
	settings->beginGroup("General");
		msec=settings->value("Waittime_between_rechecking_offline_users","30000").toInt();
	settings->endGroup();

	cI2PStream* t =(cI2PStream*)ConnectionManager->CreateNewStreamObject(CONNECT);
	connect(t,SIGNAL(StreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)),this,
		SLOT(StreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, QString)));

	User.set_I2PStreamID(t->getID());
			
	if(t!=NULL){
		connect(t,SIGNAL(DataRecived(const qint32, const QByteArray)),Protocol,
			SLOT(inputUnknown(const qint32, const QByteArray)));
		t->doConnect(User.get_I2PDestination());
		t->startUnlimintedReconnect(msec);
	}
	delete settings;
}

void cCore::removeFileTransfer(const qint32 ID)
{
	if(FileSends.count()>0){
		for(int i=0;i<FileSends.count();i++){
			if(FileSends.at(i)->get_StreamID()==ID){
				FileSends.removeAt(i);
				emit eventUserChanged();
				break;
			}
		}	
	}
	
}

void cCore::removeFileRecive(const qint32 ID)
{	
	if(FileRecives.count()>0){
		for(int i=0;i<FileRecives.count();i++){
			if(FileRecives.at(i)->get_StreamID()==ID){
				FileRecives.removeAt(i);
				emit eventUserChanged();
				break;
			}
		}
	}

}

void cCore::NewSamPrivKeyGenerated(const QString SamPrivKey)
{
	QSettings* settings= new QSettings(QApplication::applicationDirPath()+"/application.ini",QSettings::IniFormat);
	settings->beginGroup("Network");
		settings->setValue("SamPrivKey",SamPrivKey);
	settings->endGroup();
	delete settings;
}

bool cCore::UseThisChatConnection(const QString Destination, const qint32 ID)
{
	cUser* theUser=NULL;

	theUser=get_UserByI2P_Destination(Destination);
	if(theUser!=NULL){
	//check if connection to user allready exist
		if(theUser->get_I2PStreamID()!=ID){
			if(theUser->get_ConnectionStatus()==ONLINE){
				//close the new connection,- we have allready a connection to this user
				DestroyStreamObjectByID(ID);
				return false;
			}
			else if(theUser->get_ConnectionStatus()==TRYTOCONNECT){
				//use the new connection
				//close the TRYTOCONNECT connection
				deletePacketManagerByID(theUser->get_I2PStreamID());
				DestroyStreamObjectByID(theUser->get_I2PStreamID());
				theUser->set_I2PStreamID(ID);
				return true;
			}
		}
	}	
	return true;
}




