/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CONNECTIONMANAGER_H
#define CONNECTIONMANAGER_H

#include "StreamController.h"
#include "I2PStream.h"
#include <QMap>
#include <QMapIterator>

namespace SESSION_ENUMS
{
	enum SESSION_STYLEV3
	{
		STREAM,
		DATAGRAMM//,
		//RAW
	};
};

class cConnectionManager :public QObject
{
	Q_OBJECT
	public:
 		cConnectionManager(QString SamHost,QString SamPort);
		~cConnectionManager();

		bool doCreateSession(
			SESSION_ENUMS::SESSION_STYLEV3 SessionStyle,
			QString SamPrivKey,
			QString SessionOptions
			);
		QString getSamPrivKey();

	public slots:
		void SessionStreamStatusOK(bool Status);
		bool DestroyStreamObjectByID(qint32 ID);
		const cI2PStream* CreateNewStreamObject(StreamMode Mode,bool Silence=false);
		const cI2PStream* getStreamObjectByID(qint32 ID);
		const cI2PStream* getStreamObjectByDestination(QString Destination);
		const QMap<qint32,cI2PStream*>* getAllStreamObjects();
		void doNamingLookUP(QString Name);
		QString getStreamControllerBridgeName();
		void ModeAcceptIncomingStream(qint32 ID);

	signals:
		void debugMessages(const QString Message);
		void StreamControllerStatusOK(bool Status);
		void StreamStatusRecived(const SAM_Message_Types::RESULT result,const qint32 ID,const QString Message);
		void NamingReplyRecived(const SAM_Message_Types::RESULT result,QString Name,QString Value="",QString Message="");
		void IncomingStream(cI2PStream* stream);
		void NewSamPrivKeyGenerated(const QString SamPrivKey);

	private:
		qint32 nextFreePosID ();
		qint32 nextFreeNegID ();
		QString generateBridgeName();

		
		QMap<qint32,cI2PStream*> StreamIncomingListener;
		cStreamController* StreamController;
		bool bSessionStreamStatusOK;
		const QString SamHost;
		const QString SamPort;
		inline void SessionStreamStatusOKCheck(){
			if(bSessionStreamStatusOK==false)return;
		}
		QMap<qint32,cI2PStream*> allStreams;
};
#endif
