/***************************************************************************
 *   Copyright (C) 2008 by I2P-Messenger   				   *
 *   Messenger-Dev@I2P-Messenger   					   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "ConnectionManager.h"

cConnectionManager::cConnectionManager(QString SamHost,QString SamPort)
:SamHost(SamHost),SamPort(SamPort)
{
	StreamController=NULL;
	bSessionStreamStatusOK=false;
	emit debugMessages("<-- ConnectionManager started -->");
	
}

bool cConnectionManager::doCreateSession(
SESSION_ENUMS::SESSION_STYLEV3 SessionStyle, QString SamPrivKey, 
QString SessionOptions)
{
	using namespace SESSION_ENUMS;

	QString BridgeName=generateBridgeName();

	if(SessionStyle==STREAM &&StreamController==NULL){
		this->StreamController=new cStreamController(	SamHost,
								SamPort,
								BridgeName,
								SamPrivKey,
								SessionOptions
								);
		
		connect(StreamController,SIGNAL(debugMessages(const QString)),this,SIGNAL(debugMessages(const QString)));
		connect(StreamController,SIGNAL(SessionStreamStatusOK(bool)),this,SLOT(SessionStreamStatusOK(bool)));
		connect(StreamController,SIGNAL(NamingReplyRecived(const SAM_Message_Types::RESULT, QString, QString, QString)),this,
			SIGNAL(NamingReplyRecived(const SAM_Message_Types::RESULT, QString, QString, QString)));
		connect(StreamController,SIGNAL(NewSamPrivKeyGenerated(const QString)),this,
			SIGNAL(NewSamPrivKeyGenerated(const QString)));

		StreamController->doConnect();		
	}
	else{
		return false;
	}
	
	return false;
}

void cConnectionManager::SessionStreamStatusOK(bool Status)
{
	QString Message;
	bSessionStreamStatusOK=Status;
	//start StreamListener
	cI2PStream* t= new cI2PStream(SamHost,SamPort,nextFreeNegID(),StreamController->getBridgeName(),ACCEPT,false);		
		connect(t,SIGNAL(ModeAcceptIncomingStream(qint32)),this,SLOT(ModeAcceptIncomingStream(qint32)));
		connect(t,SIGNAL(debugMessages(const QString)),this,SIGNAL(debugMessages(const QString)));
		
		connect(t,SIGNAL(StreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)),this,
				SIGNAL(StreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)));
		
		t->doAccept();
		Message="<-- Create new StreamObjectListener ID(";
		Message+=QString::number(t->getID(),10);
		Message+=") -->\n";

		emit debugMessages(Message);
	StreamIncomingListener.insert(t->getID(),t);

	emit StreamControllerStatusOK(Status);
}

qint32 cConnectionManager::nextFreePosID()
{
	qint32 nextNumber=1;
	
	for(int i=0;i<allStreams.size();i++){
		if(allStreams.contains(nextNumber)==true){
			nextNumber++;
		}
		else{
			break;;
		}
	}
	return nextNumber;
}	

qint32 cConnectionManager::nextFreeNegID()
{
	qint32 nextNumber=-1;
	
	for(int i=0;i<allStreams.size();i++){
		if(allStreams.contains(nextNumber)==true){
			nextNumber--;
		}
		else{
			break;
		}
	}
	return nextNumber;
}

bool cConnectionManager::DestroyStreamObjectByID(qint32 ID)
{	
	QString Message;
	if(allStreams.contains(ID)==false)return false;
	cI2PStream* t=allStreams.take(ID);
	
	
	disconnect(t,SIGNAL(StreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)),this,
		SIGNAL(StreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)));	

	disconnect(t,SIGNAL(debugMessages(const QString)),this,SIGNAL(debugMessages(const QString)));
	
	Message="<-- Delete StreamObject ID(";
	Message+=QString::number(t->getID(),10);
	Message+=") -->\n";

	delete t;

	emit debugMessages(Message);
	return true;
}

const cI2PStream * cConnectionManager::CreateNewStreamObject(StreamMode Mode,bool Silence)
{
	QString Message;

	if(bSessionStreamStatusOK==true){
		qint32 IDforNewObject;
		QString StreamControllerBridgeName=StreamController->getBridgeName();

		if(Mode==CONNECT)
			IDforNewObject=nextFreePosID();
		else if(Mode==ACCEPT)
			IDforNewObject=nextFreeNegID();
		
		
		cI2PStream* t= new cI2PStream(SamHost,SamPort,IDforNewObject,StreamControllerBridgeName,Mode,Silence);
		connect(t,SIGNAL(debugMessages(const QString)),this,SIGNAL(debugMessages(const QString)));
		connect(t,SIGNAL(StreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)),this,
			SIGNAL(StreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)));

		Message="<-- Create new StreamObject ID(";
		Message+=QString::number(t->getID(),10);
		Message+=") -->\n";

		emit debugMessages(Message);
		allStreams.insert(IDforNewObject,t);
		return t;
	}
	else{
		return NULL;
	}
}

void cConnectionManager::doNamingLookUP(QString Name)
{
	SessionStreamStatusOKCheck();

	if(StreamController!=NULL){
		StreamController->doNamingLookUP(Name);
	}
}

const cI2PStream * cConnectionManager::getStreamObjectByID(qint32 ID)
{
	if(allStreams.contains(ID)==false){
		return NULL;
	}
	else{
		return *(allStreams.find(ID));
	}
}

QString cConnectionManager::getStreamControllerBridgeName()
{
	if(StreamController!=NULL){
		return StreamController->getBridgeName();
	}
	return 0;
}

const cI2PStream * cConnectionManager::getStreamObjectByDestination(QString Destination)
{
	QMapIterator<qint32, cI2PStream* > i(allStreams);
 	while (i.hasNext()) {
		if(i.value()->getDestination()==Destination) return i.value();
	}
	return NULL;
}

void cConnectionManager::ModeAcceptIncomingStream(qint32 ID)
{
	QString Message;

	if(StreamIncomingListener.contains(ID)==true){
		//change old StreamIncomingListener to a normal Stream
			cI2PStream* t=StreamIncomingListener.take(ID);
			disconnect(t,SIGNAL(ModeAcceptIncomingStream(qint32)),this,SLOT(ModeAcceptIncomingStream(qint32)));

			connect(t,SIGNAL(StreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)),this,
				SIGNAL(StreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)));
			allStreams.insert(ID,t);
		//----------------------------------------------------


		//create new StreamIncomingListener
			cI2PStream* t2= new cI2PStream(SamHost,SamPort,nextFreeNegID(),StreamController->getBridgeName(),ACCEPT,false);
			connect(t2,SIGNAL(debugMessages(const QString)),this,SIGNAL(debugMessages(const QString)));		
			connect(t2,SIGNAL(ModeAcceptIncomingStream(qint32)),this,SLOT(ModeAcceptIncomingStream(qint32)));

			connect(t2,SIGNAL(StreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)),this,
				SIGNAL(StreamStatusRecived(const SAM_Message_Types::RESULT, const qint32, const QString)));
			
			Message="<-- Create new StreamObjectListener ID(";
			Message+=QString::number(t2->getID(),10);
			Message+=") -->\n";
	
			emit debugMessages(Message);
			t2->doAccept();
			StreamIncomingListener.insert(t2->getID(),t2);
		//-----------------------------------
		emit IncomingStream(t);
	}
}

cConnectionManager::~ cConnectionManager()
{

	//close all StreamObjekts
	QMapIterator<qint32,cI2PStream*> i(allStreams);
	while (i.hasNext()) {
     		i.next();
		DestroyStreamObjectByID((i.value())->getID());
	}

	//close all StreamIncomingListener
	QMapIterator<qint32,cI2PStream*>i2(StreamIncomingListener);
	while (i2.hasNext()) {
     		i2.next();
		delete i2.value();
	}

	//close all StreamContoller
	delete StreamController;

	emit debugMessages("<-- ConnectionManager stopped -->");
}

const QMap< qint32, cI2PStream * >* cConnectionManager::getAllStreamObjects()
{ 
	return &allStreams;
}

QString cConnectionManager::getSamPrivKey()
{
	if(StreamController!=NULL){
		return StreamController->getSamPrivKey();
	}
	else{
		return "";
	}
}

QString cConnectionManager::generateBridgeName()
{
	QString Name;
	int length=0;

	srand ( time(NULL) );

	while(length<3){
		length=rand()% 9;
	}

	for(int i=0;i<length;i++){
		Name.append(("ABCDEFGHIJKLMNOPQRSTUVWXYZ"[rand() % 26]));
	}

	return Name;
}